/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.RenameQuickFix;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.MemoryBlockStartFieldLocation;
import ghidra.program.util.ProgramLocation;

public class RenameMemoryBlockQuickFix
extends RenameQuickFix {
    private MemoryBlock block;

    public RenameMemoryBlockQuickFix(Program program, MemoryBlock block, String newName) {
        super(program, block.getName(), newName);
        this.block = block;
    }

    @Override
    public String getItemType() {
        return "Memory Block";
    }

    @Override
    public String doGetCurrent() {
        return this.block.getName();
    }

    @Override
    public void execute() {
        try {
            this.block.setName(this.replacement);
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename Failed! " + String.valueOf(e));
        }
    }

    @Override
    public Address getAddress() {
        return this.block.getStart();
    }

    @Override
    public String getPath() {
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return new MemoryBlockStartFieldLocation(this.program, this.getAddress(), null, 0, 0, null, 0);
    }
}

