/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.gui;

import ghidra.app.util.SearchConstants;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.bean.opteditor.OptionsVetoException;

public class MemorySearchOptions {
    private static final String PRE_POPULATE_MEM_SEARCH = "Pre-populate Memory Search";
    private static final String AUTO_RESTRICT_SELECTION = "Auto Restrict Search on Selection";
    private OptionsChangeListener searchOptionsListener;
    private OptionsChangeListener browserOptionsListener;
    private boolean prepopulateSearch = true;
    private int searchLimit = 500;
    private boolean highlightMatches = true;
    private boolean autoRestrictSelection = true;
    private int byteGroupSize;
    private String byteDelimiter;

    public MemorySearchOptions(PluginTool tool) {
        this.registerSearchOptions(tool);
        this.registerBrowserOptionsListener(tool);
    }

    public MemorySearchOptions() {
    }

    public int getByteGroupSize() {
        return this.byteGroupSize;
    }

    public String getByteDelimiter() {
        return this.byteDelimiter;
    }

    public boolean isShowHighlights() {
        return this.highlightMatches;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public boolean isAutoRestrictSelection() {
        return this.autoRestrictSelection;
    }

    private void registerSearchOptions(PluginTool tool) {
        ToolOptions options = tool.getOptions("Search");
        options.registerOption(PRE_POPULATE_MEM_SEARCH, (Object)this.prepopulateSearch, null, "Initializes memory search byte sequence from the current selection provided the selection is less than 10 bytes.");
        options.registerOption(AUTO_RESTRICT_SELECTION, (Object)this.autoRestrictSelection, null, "Automactically restricts searches to the to the current selection, if a selection exists");
        options.registerOption("Highlight Search Results", (Object)this.highlightMatches, null, "Toggles highlight search results");
        options.registerThemeColorBinding(" Highlight Color", SearchConstants.SEARCH_HIGHLIGHT_COLOR.getId(), null, "The search result highlight color");
        options.registerThemeColorBinding("Highlight Color for Current Match", SearchConstants.SEARCH_HIGHLIGHT_CURRENT_ADDR_COLOR.getId(), null, "The search result highlight color for the currently selected match");
        this.loadSearchOptions(options);
        this.searchOptionsListener = this::searchOptionsChanged;
        options.addOptionsChangeListener(this.searchOptionsListener);
    }

    private void registerBrowserOptionsListener(PluginTool tool) {
        ToolOptions options = tool.getOptions("Listing Fields");
        this.loadBrowserOptions(options);
        this.browserOptionsListener = this::browserOptionsChanged;
        options.addOptionsChangeListener(this.browserOptionsListener);
    }

    private void loadBrowserOptions(ToolOptions options) {
        this.byteGroupSize = options.getInt("Bytes Field.Byte Group Size", 1);
        this.byteDelimiter = options.getString("Bytes Field.Delimiter", " ");
    }

    private void searchOptionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        int limit;
        if (optionName.equals("Search Limit") && (limit = ((Integer)newValue).intValue()) <= 0) {
            throw new OptionsVetoException("Search limit must be greater than 0");
        }
        this.loadSearchOptions(options);
    }

    private void loadSearchOptions(ToolOptions options) {
        this.searchLimit = options.getInt("Search Limit", 500);
        this.highlightMatches = options.getBoolean("Highlight Search Results", true);
        this.autoRestrictSelection = options.getBoolean(AUTO_RESTRICT_SELECTION, true);
        this.prepopulateSearch = options.getBoolean(PRE_POPULATE_MEM_SEARCH, true);
    }

    private void browserOptionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.loadBrowserOptions(options);
    }
}

