/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import generic.jar.ResourceFile;
import ghidra.app.util.datatype.microsoft.GUID;
import ghidra.app.util.datatype.microsoft.GuidDataType;
import ghidra.app.util.datatype.microsoft.GuidInfo;
import ghidra.app.util.datatype.microsoft.NewGuid;
import ghidra.app.util.datatype.microsoft.VersionedGuidInfo;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.Application;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Conv;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class GuidUtil {
    private static String ARCHIVE_DIR = "msvcrt";
    private static String ARCHIVE_DIR_PARENT = "typeinfo/win32";
    private static boolean initialized = false;
    private static GuidType[] guidTypes = new GuidType[]{GuidType.CLSID, GuidType.IID, GuidType.GUID, GuidType.SYNTAX};
    private static Hashtable<GuidType, Hashtable<String, GuidInfo>> idTables;
    private static final String MS_GUID_PREFIX = "_GUID_";

    private static final void initialize() {
        if (initialized) {
            return;
        }
        idTables = new Hashtable();
        for (GuidType guidType : guidTypes) {
            idTables.put(guidType, new Hashtable());
        }
        GuidUtil.buildGuidMap();
        initialized = true;
    }

    public static GuidInfo getKnownGuid(Program program, Address address) {
        String guidString = GuidUtil.getGuidString(program, address, false);
        return GuidUtil.getKnownGuid(guidString);
    }

    public static GuidInfo getKnownGuid(String guidString) {
        if (guidString == null) {
            return null;
        }
        GuidUtil.initialize();
        guidString = guidString.toUpperCase();
        for (GuidType guidType : guidTypes) {
            Hashtable<String, GuidInfo> table;
            GuidInfo guidInfo;
            if (guidType.equals((Object)GuidType.SYNTAX) || (guidInfo = (table = idTables.get((Object)guidType)).get(guidString)) == null) continue;
            return guidInfo;
        }
        return null;
    }

    public static GuidInfo getKnownVersionedGuid(String versionedGuidString) {
        GuidUtil.initialize();
        versionedGuidString = versionedGuidString.toUpperCase();
        Hashtable<String, GuidInfo> table = idTables.get((Object)GuidType.SYNTAX);
        GuidInfo guidInfo = table.get(versionedGuidString);
        if (guidInfo != null) {
            return guidInfo;
        }
        return null;
    }

    private static void buildGuidMap() {
        for (GuidType guidType : guidTypes) {
            Hashtable<String, GuidInfo> table = idTables.get((Object)guidType);
            String filename = guidType.getFilename();
            GuidUtil.readGuidFile(guidType, filename, table);
        }
    }

    private static void readGuidFile(GuidType guidType, String filename, Hashtable<String, GuidInfo> table) {
        try {
            String inline;
            ResourceFile dir = Application.getModuleDataSubDirectory((String)(ARCHIVE_DIR_PARENT + "/" + ARCHIVE_DIR));
            ResourceFile infile = new ResourceFile(dir, filename);
            if (!infile.exists()) {
                Msg.error(GuidUtil.class, (Object)("ERROR: file not found: " + filename));
                return;
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(infile.getInputStream()));
            while ((inline = input.readLine()) != null) {
                GuidInfo guidInfo;
                if (inline.startsWith("#") || inline.length() < 30 || (guidInfo = GuidUtil.parseLine(inline, "-", guidType)) == null) continue;
                table.put(guidInfo.getUniqueIdString(), guidInfo);
            }
            input.close();
        }
        catch (IOException e1) {
            Msg.error(GuidUtil.class, (Object)("Unexpected Exception: " + e1.getMessage()), (Throwable)e1);
        }
    }

    public static GuidInfo parseLine(String guidNameLine, String delim, GuidType guidType) {
        int vpos;
        int NUM_BYTES = 16;
        long[] data = new long[4];
        String version = null;
        boolean hasVersion = guidType.hasVersion();
        String guidString = (guidNameLine = guidNameLine.replaceAll("\t", " ")).substring(0, guidNameLine.indexOf(" "));
        String strippedGUID = guidString.replaceAll(delim, "");
        if (strippedGUID.length() != 32) {
            Msg.error(GuidUtil.class, (Object)("ERROR PARSING GUID: " + guidNameLine));
            return null;
        }
        data[0] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)strippedGUID.substring(0, 8));
        Object str = strippedGUID.substring(8, 16);
        str = ((String)str).substring(4, 8) + ((String)str).substring(0, 4);
        data[1] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)str);
        str = strippedGUID.substring(16, 24);
        str = ((String)str).substring(6, 8) + ((String)str).substring(4, 6) + ((String)str).substring(2, 4) + ((String)str).substring(0, 2);
        data[2] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)str);
        str = strippedGUID.substring(24, 32);
        str = ((String)str).substring(6, 8) + ((String)str).substring(4, 6) + ((String)str).substring(2, 4) + ((String)str).substring(0, 2);
        data[3] = 0xFFFFFFFFL & NumericUtilities.parseHexLong((String)str);
        String left = guidNameLine.substring(36);
        if (hasVersion && (vpos = left.indexOf("v")) > 0) {
            int sppos = (left = left.substring(vpos)).indexOf(" ");
            version = sppos > 0 ? left.substring(0, sppos) : left.substring(0);
            left = left.substring(version.length());
        }
        String name = left.substring(left.indexOf(" ") + 1);
        if (GuidUtil.isOK(data)) {
            if (!hasVersion) {
                return new GuidInfo(guidString, name, guidType);
            }
            return new VersionedGuidInfo(guidString, version, name, guidType);
        }
        return null;
    }

    private static boolean isOK(long[] data) {
        for (long element : data) {
            if (element == 0L && element == 0xFFFFFFFFL) continue;
            return true;
        }
        return false;
    }

    public static String getGuidString(Program program, Address address, boolean validate) {
        int i;
        String delim = "-";
        byte[] bytes = new byte[16];
        long[] data = new long[4];
        boolean isBigEndian = program.getMemory().isBigEndian();
        DataConverter conv = DataConverter.getInstance((boolean)isBigEndian);
        try {
            program.getMemory().getBytes(address, bytes);
            for (int i2 = 0; i2 < data.length; ++i2) {
                data[i2] = 0xFFFFFFFFL & (long)conv.getInt(bytes, i2 * 4);
                conv.getBytes((int)data[i2], bytes, i2 * 4);
            }
        }
        catch (MemoryAccessException e) {
            return null;
        }
        String guidString = Conv.toHexString((int)((int)data[0])) + delim;
        guidString = guidString + Conv.toHexString((short)((short)data[1])) + delim;
        guidString = guidString + Conv.toHexString((short)((short)(data[1] >> 16))) + delim;
        for (i = 0; i < 4; ++i) {
            guidString = guidString + Conv.toHexString((byte)((byte)(data[2] >> i * 8)));
            if (i != 1) continue;
            guidString = guidString + delim;
        }
        for (i = 0; i < 4; ++i) {
            guidString = guidString + Conv.toHexString((byte)((byte)(data[3] >> i * 8)));
        }
        if (validate && !NewGuid.isOKForGUID(bytes, 0)) {
            return null;
        }
        return guidString;
    }

    public static String getVersionedGuidString(Program program, Address address, boolean validate) {
        int i;
        String delim = "-";
        byte[] bytes = new byte[20];
        long[] data = new long[4];
        int[] versionData = new int[2];
        boolean isBigEndian = program.getMemory().isBigEndian();
        DataConverter conv = DataConverter.getInstance((boolean)isBigEndian);
        try {
            program.getMemory().getBytes(address, bytes);
            for (int i2 = 0; i2 < data.length; ++i2) {
                data[i2] = 0xFFFFFFFFL & (long)conv.getInt(bytes, i2 * 4);
                conv.getBytes((int)data[i2], bytes, i2 * 4);
            }
        }
        catch (MemoryAccessException e) {
            return null;
        }
        String guidString = Conv.toHexString((int)((int)data[0])) + delim;
        guidString = guidString + Conv.toHexString((short)((short)data[1])) + delim;
        guidString = guidString + Conv.toHexString((short)((short)(data[1] >> 16))) + delim;
        for (i = 0; i < 4; ++i) {
            guidString = guidString + Conv.toHexString((byte)((byte)(data[2] >> i * 8)));
            if (i != 1) continue;
            guidString = guidString + delim;
        }
        for (i = 0; i < 4; ++i) {
            guidString = guidString + Conv.toHexString((byte)((byte)(data[3] >> i * 8)));
        }
        guidString = guidString + " v";
        versionData[0] = (bytes[17] << 8) + bytes[16];
        guidString = guidString + Integer.toString(versionData[0]) + ".";
        versionData[1] = (bytes[19] << 8) + bytes[18];
        guidString = guidString + Integer.toString(versionData[1]);
        if (validate && !NewGuid.isOKForGUID(bytes, 0)) {
            return null;
        }
        return guidString;
    }

    public static boolean isGuidLabel(Program program, Address address, String label) {
        if (!label.startsWith(MS_GUID_PREFIX)) {
            return false;
        }
        String guidString = label.substring(MS_GUID_PREFIX.length()).replace("_", "-");
        try {
            new GUID(guidString);
        }
        catch (Exception e) {
            return false;
        }
        GuidDataType dt = new GuidDataType();
        String guidRep = dt.getRepresentation((MemBuffer)new DumbMemBufferImpl(program.getMemory(), address), SettingsImpl.NO_SETTINGS, -1);
        return guidRep.endsWith(guidString);
    }

    public static enum GuidType {
        CLSID("clsids.txt", false),
        IID("iids.txt", false),
        GUID("guids.txt", false),
        SYNTAX("syntaxes.txt", true);

        private String filename;
        private boolean hasVersion;

        private GuidType(String filename, boolean hasVersion) {
            this.filename = filename;
            this.hasVersion = hasVersion;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean hasVersion() {
            return this.hasVersion;
        }
    }
}

