/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;

public class SetPrimaryRefCmd
implements Command<Program> {
    private Address fromAddr;
    private int opIndex;
    private Address toAddr;
    private boolean isPrimary;
    private String status;

    public SetPrimaryRefCmd(Reference ref, boolean isPrimary) {
        this(ref.getFromAddress(), ref.getOperandIndex(), ref.getToAddress(), isPrimary);
    }

    public SetPrimaryRefCmd(Address fromAddr, int opIndex, Address toAddr, boolean isPrimary) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
        this.toAddr = toAddr;
        this.isPrimary = isPrimary;
    }

    public boolean applyTo(Program program) {
        ReferenceManager refMgr = program.getReferenceManager();
        Reference ref = refMgr.getReference(this.fromAddr, this.toAddr, this.opIndex);
        if (ref == null) {
            this.status = "Reference not found";
            return false;
        }
        refMgr.setPrimary(ref, this.isPrimary);
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Set Primary Reference";
    }
}

