/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MutableMemBuffer;
import ghidra.util.GhidraDataConverter;
import java.math.BigInteger;

public class MemoryBufferImpl
implements MutableMemBuffer {
    private final GhidraDataConverter converter;
    private static final int DEFAULT_BUFSIZE = 1024;
    private Memory mem;
    private Address startAddr;
    private byte[] buffer;
    private int startAddrIndex = 0;
    private int minOffset = 0;
    private int maxOffset = -1;
    private int threshold = 0;

    public MemoryBufferImpl(Memory mem, Address addr) {
        this(mem, addr, 1024);
    }

    public MemoryBufferImpl(Memory mem, Address addr, int bufSize) {
        this.mem = mem;
        this.buffer = new byte[bufSize];
        this.threshold = bufSize / 100;
        this.converter = GhidraDataConverter.getInstance(mem.isBigEndian());
        this.setPosition(addr);
    }

    @Override
    public MemoryBufferImpl clone() {
        return new MemoryBufferImpl(this.mem, this.startAddr, this.buffer.length);
    }

    @Override
    public void advance(int displacement) throws AddressOverflowException {
        Address addr = this.startAddr.addNoWrap(displacement);
        this.setPosition(addr);
    }

    @Override
    public void setPosition(Address addr) {
        long diff;
        if (this.minOffset <= this.maxOffset && addr.getAddressSpace().equals(this.startAddr.getAddressSpace()) && (diff = addr.subtract(this.startAddr)) >= (long)this.minOffset && diff < (long)(this.maxOffset - this.threshold)) {
            this.startAddr = addr;
            this.minOffset -= (int)diff;
            this.maxOffset -= (int)diff;
            this.startAddrIndex = (int)((long)this.startAddrIndex + diff);
            return;
        }
        this.startAddr = addr;
        this.startAddrIndex = 0;
        this.minOffset = 0;
        this.maxOffset = -1;
        try {
            this.maxOffset = this.mem.getBytes(addr, this.buffer, 0, this.buffer.length) - 1;
        }
        catch (AddressOutOfBoundsException | MemoryAccessException object) {
            // empty catch block
        }
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        if (offset >= this.minOffset && offset <= this.maxOffset) {
            return this.buffer[this.startAddrIndex + offset];
        }
        try {
            Address addr = this.startAddr.addNoWrap(offset);
            int nRead = this.mem.getBytes(addr, this.buffer, 0, this.buffer.length);
            this.startAddrIndex = -offset;
            this.minOffset = offset;
            this.maxOffset = offset + nRead - 1;
            return this.buffer[0];
        }
        catch (AddressOverflowException e) {
            throw new MemoryAccessException(e.getMessage());
        }
    }

    @Override
    public Address getAddress() {
        return this.startAddr;
    }

    @Override
    public Memory getMemory() {
        return this.mem;
    }

    @Override
    public int getBytes(byte[] b, int offset) {
        if (offset >= this.minOffset && b.length + offset <= this.maxOffset) {
            System.arraycopy(this.buffer, this.startAddrIndex + offset, b, 0, b.length);
            return b.length;
        }
        try {
            return this.mem.getBytes(this.startAddr.addNoWrap(offset), b);
        }
        catch (AddressOverflowException | MemoryAccessException e) {
            return 0;
        }
    }

    @Override
    public boolean isBigEndian() {
        return this.mem.isBigEndian();
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        return this.converter.getShort(this, offset);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        return this.converter.getInt(this, offset);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        return this.converter.getLong(this, offset);
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        return this.converter.getBigInteger(this, offset, size, signed);
    }
}

