/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.NamespaceDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;

public class NamespaceSymbol
extends SymbolDB {
    private NamespaceDB namespace;

    NamespaceSymbol(SymbolManager mgr, DBObjectCache<SymbolDB> cache, Address addr, DBRecord record) {
        super(mgr, cache, addr, record);
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isExternal() {
        Symbol parentSymbol = this.getParentSymbol();
        return parentSymbol != null ? parentSymbol.isExternal() : false;
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.NAMESPACE;
    }

    @Override
    public Object getObject() {
        return this.getNamespace();
    }

    private Namespace getNamespace() {
        if (this.namespace == null) {
            this.namespace = new NamespaceDB(this, this.symbolMgr.getProgram().getNamespaceManager());
        }
        return this.namespace;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return super.isValidParent(parent) && SymbolType.NAMESPACE.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }
}

