/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.hash;

import generic.hash.MessageDigest;
import generic.hash.MessageDigestFactory;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.feature.fid.hash.FidHashQuadImpl;
import ghidra.feature.fid.hash.FidHasher;
import ghidra.feature.fid.hash.FunctionExtentGenerator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.IncompatibleMaskException;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.Mask;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.search.InstructionSkipper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class MessageDigestFidHasher
implements FidHasher {
    private static final int BUFFER_SIZE = 110000;
    protected final byte shortCodeUnitLimit;
    protected final FunctionExtentGenerator generator;
    protected final MessageDigest fullDigest;
    protected final MessageDigest specificDigest;
    protected final byte[] buffer;
    protected final Collection<InstructionSkipper> skippers;

    public MessageDigestFidHasher(FunctionExtentGenerator generator, byte shortCodeUnitLimit, MessageDigestFactory digestFactory, Collection<InstructionSkipper> skippers) {
        this.shortCodeUnitLimit = shortCodeUnitLimit;
        this.generator = generator;
        this.fullDigest = digestFactory.createDigest();
        this.specificDigest = digestFactory.createDigest();
        this.skippers = skippers;
        this.buffer = new byte[110000];
    }

    private static boolean hasRelocation(Mask mask, Address minAddress, Address maxAddress, RelocationTable relocationTable) {
        AddressSet range;
        Iterator relocations;
        byte[] bytes;
        for (byte b : bytes = mask.getBytes()) {
            if (b != 0) break;
            minAddress = minAddress.addWrap(1L);
        }
        for (int jj = bytes.length - 1; jj >= 0 && bytes[jj] == 0; --jj) {
            maxAddress = maxAddress.subtract(1L);
        }
        return minAddress.compareTo((Object)maxAddress) <= 0 && (relocations = relocationTable.getRelocations((AddressSetView)(range = new AddressSet(minAddress, maxAddress)))).hasNext();
    }

    @Override
    public FidHashQuad hash(Function func) throws MemoryAccessException {
        List<CodeUnit> extent = this.generator.calculateExtent(func);
        if (extent.size() < this.shortCodeUnitLimit) {
            return null;
        }
        Program program = func.getProgram();
        Memory memory = program.getMemory();
        RelocationTable relocationTable = program.getRelocationTable();
        this.fullDigest.reset();
        this.specificDigest.reset();
        int specificCount = 0;
        int callCount = 0;
        int codeUnitIndex = -1;
        Iterator<CodeUnit> codeUnitIterator = extent.iterator();
        CodeUnit codeUnit = null;
        while (codeUnitIterator.hasNext()) {
            codeUnit = codeUnitIterator.next();
            if (++codeUnitIndex >= 32766) break;
            Address minAddress = codeUnit.getMinAddress();
            Address maxAddress = codeUnit.getMaxAddress();
            int amountToFetch = codeUnit.getLength();
            int actualNumberRead = memory.getBytes(minAddress, this.buffer, 0, amountToFetch);
            if (codeUnit instanceof Instruction) {
                Instruction instruction = (Instruction)codeUnit;
                boolean skip = false;
                for (InstructionSkipper skipper : this.skippers) {
                    if (!skipper.shouldSkip(this.buffer, amountToFetch)) continue;
                    skip = true;
                    --codeUnitIndex;
                    break;
                }
                if (skip) continue;
                if (instruction.getFlowType().isCall()) {
                    ++callCount;
                }
                InstructionPrototype prototype = instruction.getPrototype();
                Mask instructMask = prototype.getInstructionMask();
                for (int ii = 0; ii < instruction.getNumOperands(); ++ii) {
                    int specificUpdate;
                    Mask operandMask = prototype.getOperandValueMask(ii);
                    if (operandMask == null) continue;
                    Object[] opObjects = instruction.getOpObjects(ii);
                    int fullUpdate = specificUpdate = (ii + 1) * 7777;
                    for (Object obj : opObjects) {
                        if (obj instanceof Scalar) {
                            int operandType = instruction.getOperandType(ii);
                            Scalar scalar = (Scalar)obj;
                            long val = scalar.getSignedValue();
                            if (MessageDigestFidHasher.hasRelocation(operandMask, minAddress, maxAddress, relocationTable)) {
                                val = -17965395L;
                            } else if (OperandType.isScalar((int)operandType)) {
                                if (OperandType.isAddress((int)operandType)) {
                                    val = -17965395L;
                                } else {
                                    ++specificCount;
                                }
                            } else if (val >= 256L || val <= -256L) {
                                val = -17965395L;
                            } else {
                                ++specificCount;
                            }
                            specificUpdate += ((int)val + 1234567) * 67999;
                            fullUpdate -= 17965395;
                            continue;
                        }
                        if (obj instanceof Register) {
                            Register reg = (Register)obj;
                            int val = reg.getOffset();
                            val = (val + 7654321) * 98777;
                            fullUpdate += val;
                            specificUpdate += val;
                            continue;
                        }
                        if (!(obj instanceof Address)) continue;
                        specificUpdate += 486760268;
                        fullUpdate -= 17965395;
                    }
                    this.fullDigest.update(fullUpdate);
                    this.specificDigest.update(specificUpdate);
                }
                try {
                    instructMask.applyMask(this.buffer, 0, this.buffer, 0);
                }
                catch (NullPointerException e) {
                    for (int ii = 0; ii < actualNumberRead; ++ii) {
                        this.buffer[ii] = -91;
                    }
                }
                catch (IncompatibleMaskException e) {
                    throw new RuntimeException("Internal error - mask exception implies buffer too small", e);
                }
            }
            this.fullDigest.update(this.buffer, 0, actualNumberRead);
            this.specificDigest.update(this.buffer, 0, actualNumberRead);
        }
        if (++codeUnitIndex < this.shortCodeUnitLimit) {
            return null;
        }
        short fullCount = (short)(codeUnitIndex - callCount);
        byte additionalSpecificCount = (byte)Math.min(specificCount, 127);
        return new FidHashQuadImpl(fullCount, this.fullDigest.digestLong(), additionalSpecificCount, this.specificDigest.digestLong());
    }
}

