/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.flatapi;

import ghidra.app.services.TraceRmiLauncherService;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.tracermi.TraceRmiLaunchOffer;
import ghidra.debug.flatapi.FlatDebuggerAPI;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public interface FlatDebuggerRmiAPI
extends FlatDebuggerAPI {
    default public TraceRmiLauncherService getTraceRmiLauncherService() {
        return this.requireService(TraceRmiLauncherService.class);
    }

    default public Collection<TraceRmiLaunchOffer> getLaunchOffers(Program program) {
        return this.getTraceRmiLauncherService().getOffers(program);
    }

    default public Collection<TraceRmiLaunchOffer> getLaunchOffers() {
        return this.getLaunchOffers(this.getCurrentProgram());
    }

    default public List<TraceRmiLaunchOffer> getSavedLaunchOffers(Program program) {
        return this.getTraceRmiLauncherService().getSavedOffers(program);
    }

    default public List<TraceRmiLaunchOffer> getSavedLaunchOffers() {
        return this.getSavedLaunchOffers(this.getCurrentProgram());
    }

    default public TraceRmiLaunchOffer requireLastLaunchOffer(Program program) {
        List<TraceRmiLaunchOffer> offers = this.getSavedLaunchOffers(program);
        if (offers.isEmpty()) {
            throw new NoSuchElementException("No saved offers to launch " + String.valueOf(program));
        }
        return offers.get(0);
    }

    default public TraceRmiLaunchOffer requireLastLaunchOffer() {
        return this.requireLastLaunchOffer(this.getCurrentProgram());
    }

    default public TraceRmiLaunchOffer.LaunchResult launch(TraceRmiLaunchOffer offer, final Map<String, ?> overrideArgs, TaskMonitor monitor) {
        return offer.launchProgram(monitor, new TraceRmiLaunchOffer.LaunchConfigurator(){

            @Override
            public Map<String, ValStr<?>> configureLauncher(TraceRmiLaunchOffer offer, Map<String, ValStr<?>> arguments, TraceRmiLaunchOffer.RelPrompt relPrompt) {
                if (arguments.isEmpty()) {
                    return arguments;
                }
                HashMap args = new HashMap(arguments);
                for (Map.Entry ent : overrideArgs.entrySet()) {
                    args.put((String)ent.getKey(), ValStr.from(ent.getValue()));
                }
                return args;
            }
        });
    }

    default public TraceRmiLaunchOffer.LaunchResult launch(TraceRmiLaunchOffer offer, TaskMonitor monitor) {
        return this.launch(offer, Map.of(), monitor);
    }

    default public TraceRmiLaunchOffer.LaunchResult launch(Program program, TaskMonitor monitor) {
        return this.launch(this.requireLastLaunchOffer(program), monitor);
    }

    default public TraceRmiLaunchOffer.LaunchResult launch(TaskMonitor monitor) {
        return this.launch(this.requireLastLaunchOffer(), monitor);
    }
}

