/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.typeinfo;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.datatype.modifier.MDBasedAttribute;
import mdemangler.typeinfo.MDFunctionInfo;
import mdemangler.typeinfo.MDGuard;
import mdemangler.typeinfo.MDMemberFunctionInfo;
import mdemangler.typeinfo.MDRTTI0;
import mdemangler.typeinfo.MDRTTI1;
import mdemangler.typeinfo.MDRTTI2;
import mdemangler.typeinfo.MDRTTI3;
import mdemangler.typeinfo.MDRTTI4;
import mdemangler.typeinfo.MDTypeInfo;
import mdemangler.typeinfo.MDVBTable;
import mdemangler.typeinfo.MDVCall;
import mdemangler.typeinfo.MDVFAdjustor;
import mdemangler.typeinfo.MDVFTable;
import mdemangler.typeinfo.MDVariableInfo;
import mdemangler.typeinfo.MDVtordisp;
import mdemangler.typeinfo.MDVtordispex;

public class MDTypeInfoParser {
    public static MDTypeInfo parse(MDMang dmang, int rttiNum) throws MDException {
        MDTypeInfo typeInfo;
        boolean isBased = false;
        if (dmang.peek() == '_') {
            isBased = true;
            dmang.increment();
        }
        char code = dmang.peek();
        block0 : switch (code) {
            case '$': {
                dmang.increment();
                typeInfo = MDTypeInfoParser.parseSpecialHandlingFunction(dmang, rttiNum);
                break;
            }
            case '0': {
                dmang.increment();
                typeInfo = new MDVariableInfo(dmang);
                typeInfo.setPrivate();
                typeInfo.setStatic();
                break;
            }
            case '1': {
                dmang.increment();
                typeInfo = new MDVariableInfo(dmang);
                typeInfo.setProtected();
                typeInfo.setStatic();
                break;
            }
            case '2': {
                dmang.increment();
                typeInfo = new MDVariableInfo(dmang);
                typeInfo.setPublic();
                typeInfo.setStatic();
                break;
            }
            case '3': {
                dmang.increment();
                typeInfo = new MDVariableInfo(dmang);
                break;
            }
            case '4': {
                dmang.increment();
                typeInfo = new MDVariableInfo(dmang);
                break;
            }
            case '5': {
                dmang.increment();
                typeInfo = new MDGuard(dmang);
                break;
            }
            case '6': {
                dmang.increment();
                if (rttiNum == 4) {
                    typeInfo = new MDRTTI4(dmang);
                    break;
                }
                typeInfo = new MDVFTable(dmang);
                break;
            }
            case '7': {
                dmang.increment();
                typeInfo = new MDVBTable(dmang);
                break;
            }
            case '8': {
                dmang.increment();
                switch (rttiNum) {
                    case 0: {
                        typeInfo = new MDRTTI0(dmang);
                        break block0;
                    }
                    case 1: {
                        typeInfo = new MDRTTI1(dmang);
                        break block0;
                    }
                    case 2: {
                        typeInfo = new MDRTTI2(dmang);
                        break block0;
                    }
                    case 3: {
                        typeInfo = new MDRTTI3(dmang);
                        break block0;
                    }
                }
                typeInfo = new MDTypeInfo(dmang);
                break;
            }
            case '9': {
                dmang.increment();
                typeInfo = new MDTypeInfo(dmang);
                break;
            }
            case 'A': 
            case 'B': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setPrivate();
                typeInfo.setPointerFormat((code - 65) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case 'C': 
            case 'D': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setPrivate();
                typeInfo.setStatic();
                break;
            }
            case 'E': 
            case 'F': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setPrivate();
                typeInfo.setVirtual();
                break;
            }
            case 'G': 
            case 'H': {
                dmang.increment();
                typeInfo = new MDVFAdjustor(dmang);
                typeInfo.setPrivate();
                typeInfo.setPointerFormat((code - 65) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case 'I': 
            case 'J': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setProtected();
                typeInfo.setPointerFormat((code - 65) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case 'K': 
            case 'L': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setProtected();
                typeInfo.setStatic();
                break;
            }
            case 'M': 
            case 'N': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setProtected();
                typeInfo.setVirtual();
                break;
            }
            case 'O': 
            case 'P': {
                dmang.increment();
                typeInfo = new MDVFAdjustor(dmang);
                typeInfo.setProtected();
                typeInfo.setPointerFormat((code - 65) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case 'Q': 
            case 'R': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setPublic();
                typeInfo.setPointerFormat((code - 65) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case 'S': 
            case 'T': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setPublic();
                typeInfo.setStatic();
                break;
            }
            case 'U': 
            case 'V': {
                dmang.increment();
                typeInfo = new MDMemberFunctionInfo(dmang);
                typeInfo.setPublic();
                typeInfo.setVirtual();
                break;
            }
            case 'W': 
            case 'X': {
                dmang.increment();
                typeInfo = new MDVFAdjustor(dmang);
                typeInfo.setPublic();
                typeInfo.setPointerFormat((code - 65) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case 'Y': 
            case 'Z': {
                dmang.increment();
                typeInfo = new MDFunctionInfo(dmang);
                typeInfo.setNonMember();
                break;
            }
            default: {
                if (dmang.allowMDTypeInfoParserDefault()) {
                    typeInfo = new MDTypeInfo(dmang);
                    break;
                }
                throw new MDException("Invalid MDTypeInfo, unknown case: " + code);
            }
        }
        if (isBased && typeInfo instanceof MDFunctionInfo) {
            MDBasedAttribute based = new MDBasedAttribute(dmang);
            based.parse();
            ((MDFunctionInfo)typeInfo).setBased(based);
        }
        return typeInfo;
    }

    public static MDTypeInfo parseSpecialHandlingFunction(MDMang dmang, int rttiNum) throws MDException {
        MDTypeInfo typeInfo;
        char ch = dmang.getAndIncrement();
        block0 : switch (ch) {
            case '0': 
            case '1': {
                typeInfo = new MDVtordisp(dmang);
                typeInfo.setPrivate();
                typeInfo.setPointerFormat((ch - 48) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case '2': 
            case '3': {
                typeInfo = new MDVtordisp(dmang);
                typeInfo.setProtected();
                typeInfo.setPointerFormat((ch - 48) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case '4': 
            case '5': {
                typeInfo = new MDVtordisp(dmang);
                typeInfo.setPublic();
                typeInfo.setPointerFormat((ch - 48) % 2 == 0 ? MDTypeInfo.PointerFormat._NEAR : MDTypeInfo.PointerFormat._FAR);
                break;
            }
            case '$': {
                char ch2 = dmang.getAndIncrement();
                switch (ch2) {
                    case 'J': 
                    case 'N': 
                    case 'O': {
                        char c = dmang.getAndIncrement();
                        if (c < '0' || c > '9') {
                            throw new MDException("Access Level 'extern \"C\"' count is wrong: " + c);
                        }
                        int cnt = c - 48;
                        while (cnt-- > 0) {
                            c = dmang.getAndIncrement();
                        }
                        typeInfo = MDTypeInfoParser.parse(dmang, rttiNum);
                        typeInfo.setExternC();
                        break;
                    }
                    case 'F': 
                    case 'H': 
                    case 'L': 
                    case 'M': 
                    case 'Q': {
                        typeInfo = MDTypeInfoParser.parse(dmang, rttiNum);
                        break;
                    }
                    default: {
                        throw new MDException("Access Level $$, unknown case: " + ch2);
                    }
                }
                typeInfo.setSpecialHandlingCode(ch2);
                break;
            }
            case 'B': {
                typeInfo = new MDVCall(dmang);
                break;
            }
            case 'R': {
                typeInfo = new MDVtordispex(dmang);
                char ch3 = dmang.getAndIncrement();
                switch (ch3) {
                    case '0': 
                    case '1': {
                        typeInfo.setPrivate();
                        break block0;
                    }
                    case '2': 
                    case '3': {
                        typeInfo.setProtected();
                        break block0;
                    }
                    case '4': 
                    case '5': {
                        typeInfo.setPublic();
                        break block0;
                    }
                }
                throw new MDException("Access Level $R, unknown case: " + ch3);
            }
            default: {
                throw new MDException("Access Level $, unknown case: " + ch);
            }
        }
        return typeInfo;
    }
}

