/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.HashMap;
import java.util.Map;

public class FrameSecurityCookieMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4410;
    protected long offset;
    protected int registerIndex;
    protected RegisterName registerName;
    protected CookieType cookieType;
    protected int flags;

    public FrameSecurityCookieMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.offset = reader.parseVarSizedOffset(32);
        this.registerIndex = reader.parseUnsignedShortVal();
        this.registerName = new RegisterName(pdb, this.registerIndex);
        this.cookieType = CookieType.fromValue(reader.parseUnsignedByteVal());
        this.flags = reader.parseUnsignedByteVal();
    }

    @Override
    public int getPdbId() {
        return 4410;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getRegisterIndex() {
        return this.registerIndex;
    }

    public String getRegisterNameString() {
        return this.registerName.toString();
    }

    public CookieType getCookieType() {
        return this.cookieType;
    }

    public int getFlags() {
        return this.flags;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: %s+%08X, Type: %s, %02X", this.getSymbolTypeName(), this.registerName.toString(), this.offset, this.cookieType.toString(), this.flags));
    }

    @Override
    protected String getSymbolTypeName() {
        return "FRAMECOOKIE";
    }

    public static enum CookieType {
        INVALID("invalid", -1),
        COPY("COPY", 0),
        XOR_SP("XOR_SP", 1),
        XOR_BP("XOR_BP", 2),
        XOR_R13("XOR_R13", 3);

        private static final Map<Integer, CookieType> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static CookieType fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private CookieType(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, CookieType>();
            for (CookieType val : CookieType.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

