/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeThread;
import ghidra.trace.model.time.schedule.AbstractStep;
import ghidra.trace.model.time.schedule.Step;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class SkipStep
extends AbstractStep {
    public static SkipStep parse(long threadKey, String stepSpec, TraceSchedule.TimeRadix radix) {
        if (!stepSpec.startsWith("s")) {
            throw new IllegalArgumentException("Cannot parse skip step: '" + stepSpec + "'");
        }
        try {
            return new SkipStep(threadKey, radix.decode(stepSpec.substring(1)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Cannot parse skip step: '" + stepSpec + "'");
        }
    }

    public SkipStep(long threadKey, long tickCount) {
        super(threadKey, tickCount);
    }

    @Override
    public Step.StepType getType() {
        return Step.StepType.SKIP;
    }

    @Override
    public long getSkipCount() {
        return this.tickCount;
    }

    @Override
    protected String toStringStepPart(TraceSchedule.TimeRadix radix) {
        return "s" + radix.format(this.tickCount);
    }

    @Override
    public AbstractStep clone() {
        return new SkipStep(this.threadKey, this.tickCount);
    }

    @Override
    public Step subtract(Step step) {
        assert (this.isCompatible(step));
        SkipStep that = (SkipStep)step;
        return new SkipStep(this.threadKey, this.tickCount - that.tickCount);
    }

    @Override
    public void execute(PcodeThread<?> emuThread, Stepper stepper, TaskMonitor monitor) throws CancelledException {
        int i = 0;
        while ((long)i < this.tickCount) {
            monitor.incrementProgress(1L);
            monitor.checkCancelled();
            stepper.skip(emuThread);
            ++i;
        }
    }
}

