/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.util.ByteStreamGobbler;
import edu.stanford.nlp.util.StreamGobbler;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class BZip2PipedOutputStream
extends OutputStream {
    private String filename;
    private Process process;
    private ByteStreamGobbler outGobbler;
    private StreamGobbler errGobbler;
    private PrintWriter errWriter;

    public BZip2PipedOutputStream(String filename) throws IOException {
        this(filename, System.err);
    }

    public BZip2PipedOutputStream(String filename, OutputStream err2) throws IOException {
        String bzip2;
        String cmd = bzip2 = System.getProperty("bzip2", "bzip2");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmd);
        this.process = pb.start();
        this.filename = filename;
        FileOutputStream outStream = new FileOutputStream(filename);
        this.errWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(err2)));
        this.outGobbler = new ByteStreamGobbler("Output stream gobbler: " + cmd + " " + filename, this.process.getInputStream(), outStream);
        this.errGobbler = new StreamGobbler(this.process.getErrorStream(), this.errWriter);
        this.outGobbler.start();
        this.errGobbler.start();
    }

    public void flush() throws IOException {
        this.process.getOutputStream().flush();
    }

    public void write(int b) throws IOException {
        this.process.getOutputStream().write(b);
    }

    public void close() throws IOException {
        this.process.getOutputStream().close();
        try {
            this.outGobbler.join();
            this.errGobbler.join();
            this.outGobbler.getOutputStream().close();
            this.process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

