/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class HttpServlet
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_DELETE = "DELETE";
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_TRACE = "TRACE";
    private static final String HEADER_IFMODSINCE = "If-Modified-Since";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    private static final List<String> SENSITIVE_HTTP_HEADERS = Arrays.asList("authorization", "cookie", "x-forwarded", "forwarded", "proxy-authorization");

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_get_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    protected void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (DispatcherType.INCLUDE.equals((Object)httpServletRequest.getDispatcherType())) {
            this.doGet(httpServletRequest, httpServletResponse);
        } else {
            NoBodyResponse noBodyResponse = new NoBodyResponse(httpServletResponse);
            this.doGet(httpServletRequest, noBodyResponse);
            if (httpServletRequest.isAsyncStarted()) {
                httpServletRequest.getAsyncContext().addListener(new NoBodyAsyncContextListener(noBodyResponse));
            } else {
                noBodyResponse.setContentLength();
            }
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_post_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_put_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = lStrings.getString("http.method_delete_not_supported");
        this.sendMethodNotAllowed(httpServletRequest, httpServletResponse, string);
    }

    private void sendMethodNotAllowed(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = httpServletRequest.getProtocol();
        if (string2.length() == 0 || string2.endsWith("0.9") || string2.endsWith("1.0")) {
            httpServletResponse.sendError(400, string);
        } else {
            httpServletResponse.sendError(405, string);
        }
    }

    private static Method[] getAllDeclaredMethods(Class<?> clazz) {
        if (clazz.equals(HttpServlet.class)) {
            return null;
        }
        Method[] methodArray = HttpServlet.getAllDeclaredMethods(clazz.getSuperclass());
        Method[] methodArray2 = clazz.getDeclaredMethods();
        if (methodArray != null && methodArray.length > 0) {
            Method[] methodArray3 = new Method[methodArray.length + methodArray2.length];
            System.arraycopy(methodArray, 0, methodArray3, 0, methodArray.length);
            System.arraycopy(methodArray2, 0, methodArray3, methodArray.length, methodArray2.length);
            methodArray2 = methodArray3;
        }
        return methodArray2;
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Method[] methodArray = HttpServlet.getAllDeclaredMethods(this.getClass());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        boolean bl7 = true;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.apache.catalina.connector.RequestFacade");
            Method method = clazz.getMethod("getAllowTrace", null);
            bl6 = (Boolean)method.invoke((Object)httpServletRequest, (Object[])null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getName().equals("doGet")) {
                bl = true;
                bl2 = true;
            }
            if (method.getName().equals("doPost")) {
                bl3 = true;
            }
            if (method.getName().equals("doPut")) {
                bl4 = true;
            }
            if (!method.getName().equals("doDelete")) continue;
            bl5 = true;
        }
        String string = null;
        if (bl) {
            string = METHOD_GET;
        }
        if (bl2) {
            string = string == null ? METHOD_HEAD : string + ", HEAD";
        }
        if (bl3) {
            string = string == null ? METHOD_POST : string + ", POST";
        }
        if (bl4) {
            string = string == null ? METHOD_PUT : string + ", PUT";
        }
        if (bl5) {
            string = string == null ? METHOD_DELETE : string + ", DELETE";
        }
        if (bl6) {
            string = string == null ? METHOD_TRACE : string + ", TRACE";
        }
        if (bl7) {
            string = string == null ? METHOD_OPTIONS : string + ", OPTIONS";
        }
        httpServletResponse.setHeader("Allow", string);
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = "\r\n";
        StringBuilder stringBuilder = new StringBuilder("TRACE ").append(httpServletRequest.getRequestURI()).append(' ').append(httpServletRequest.getProtocol());
        Enumeration<String> enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (this.isSensitiveHeader((String)object)) continue;
            Enumeration<String> enumeration2 = httpServletRequest.getHeaders((String)object);
            while (enumeration2.hasMoreElements()) {
                String string2 = enumeration2.nextElement();
                stringBuilder.append(string).append((String)object).append(": ").append(string2);
            }
        }
        stringBuilder.append(string);
        int n = stringBuilder.length();
        httpServletResponse.setContentType("message/http");
        httpServletResponse.setContentLength(n);
        object = httpServletResponse.getOutputStream();
        ((ServletOutputStream)object).print(stringBuilder.toString());
        ((OutputStream)object).close();
    }

    private boolean isSensitiveHeader(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        for (String string3 : SENSITIVE_HTTP_HEADERS) {
            if (!string2.startsWith(string3)) continue;
            return true;
        }
        return false;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals(METHOD_GET)) {
            long l = this.getLastModified(httpServletRequest);
            if (l == -1L) {
                this.doGet(httpServletRequest, httpServletResponse);
            } else {
                long l2;
                try {
                    l2 = httpServletRequest.getDateHeader(HEADER_IFMODSINCE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    l2 = -1L;
                }
                if (l2 < l / 1000L * 1000L) {
                    this.maybeSetLastModified(httpServletResponse, l);
                    this.doGet(httpServletRequest, httpServletResponse);
                } else {
                    httpServletResponse.setStatus(304);
                }
            }
        } else if (string.equals(METHOD_HEAD)) {
            long l = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l);
            this.doHead(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_POST)) {
            this.doPost(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_PUT)) {
            this.doPut(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_DELETE)) {
            this.doDelete(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_OPTIONS)) {
            this.doOptions(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_TRACE)) {
            this.doTrace(httpServletRequest, httpServletResponse);
        } else {
            String string2 = lStrings.getString("http.method_not_implemented");
            Object[] objectArray = new Object[]{string};
            string2 = MessageFormat.format(string2, objectArray);
            httpServletResponse.sendError(501, string2);
        }
    }

    private void maybeSetLastModified(HttpServletResponse httpServletResponse, long l) {
        if (httpServletResponse.containsHeader(HEADER_LASTMOD)) {
            return;
        }
        if (l >= 0L) {
            httpServletResponse.setDateHeader(HEADER_LASTMOD, l);
        }
    }

    @Override
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        try {
            httpServletRequest = (HttpServletRequest)servletRequest;
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        catch (ClassCastException classCastException) {
            throw new ServletException(lStrings.getString("http.non_http"));
        }
        this.service(httpServletRequest, httpServletResponse);
    }

    private static class NoBodyResponse
    extends HttpServletResponseWrapper {
        private final NoBodyOutputStream noBodyOutputStream = new NoBodyOutputStream(this);
        private ServletOutputStream originalOutputStream;
        private NoBodyPrintWriter noBodyWriter;
        private boolean didSetContentLength;

        private NoBodyResponse(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        private void setContentLength() {
            if (!this.didSetContentLength) {
                if (this.noBodyWriter != null) {
                    this.noBodyWriter.flush();
                }
                super.setContentLengthLong(this.noBodyOutputStream.getWrittenByteCount());
            }
        }

        @Override
        public void setContentLength(int n) {
            super.setContentLength(n);
            this.didSetContentLength = true;
        }

        @Override
        public void setContentLengthLong(long l) {
            super.setContentLengthLong(l);
            this.didSetContentLength = true;
        }

        @Override
        public void setHeader(String string, String string2) {
            super.setHeader(string, string2);
            this.checkHeader(string);
        }

        @Override
        public void addHeader(String string, String string2) {
            super.addHeader(string, string2);
            this.checkHeader(string);
        }

        @Override
        public void setIntHeader(String string, int n) {
            super.setIntHeader(string, n);
            this.checkHeader(string);
        }

        @Override
        public void addIntHeader(String string, int n) {
            super.addIntHeader(string, n);
            this.checkHeader(string);
        }

        private void checkHeader(String string) {
            if ("content-length".equalsIgnoreCase(string)) {
                this.didSetContentLength = true;
            }
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            this.originalOutputStream = this.getResponse().getOutputStream();
            return this.noBodyOutputStream;
        }

        @Override
        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.noBodyWriter == null) {
                this.noBodyWriter = new NoBodyPrintWriter(this.noBodyOutputStream, this.getCharacterEncoding());
            }
            return this.noBodyWriter;
        }

        @Override
        public void reset() {
            super.reset();
            this.resetBuffer();
            this.originalOutputStream = null;
        }

        @Override
        public void resetBuffer() {
            this.noBodyOutputStream.resetBuffer();
            if (this.noBodyWriter != null) {
                this.noBodyWriter.resetBuffer();
            }
        }
    }

    private static class NoBodyAsyncContextListener
    implements AsyncListener {
        private final NoBodyResponse noBodyResponse;

        NoBodyAsyncContextListener(NoBodyResponse noBodyResponse) {
            this.noBodyResponse = noBodyResponse;
        }

        @Override
        public void onComplete(AsyncEvent asyncEvent) throws IOException {
            this.noBodyResponse.setContentLength();
        }

        @Override
        public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        }

        @Override
        public void onError(AsyncEvent asyncEvent) throws IOException {
        }

        @Override
        public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
        }
    }

    private static class NoBodyPrintWriter
    extends PrintWriter {
        private final NoBodyOutputStream out;
        private final String encoding;
        private PrintWriter pw;

        NoBodyPrintWriter(NoBodyOutputStream noBodyOutputStream, String string) throws UnsupportedEncodingException {
            super(noBodyOutputStream);
            this.out = noBodyOutputStream;
            this.encoding = string;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)noBodyOutputStream, string);
            this.pw = new PrintWriter(outputStreamWriter);
        }

        private void resetBuffer() {
            this.out.resetBuffer();
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)this.out, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.pw = new PrintWriter(outputStreamWriter);
        }

        @Override
        public void flush() {
            this.pw.flush();
        }

        @Override
        public void close() {
            this.pw.close();
        }

        @Override
        public boolean checkError() {
            return this.pw.checkError();
        }

        @Override
        public void write(int n) {
            this.pw.write(n);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            this.pw.write(cArray, n, n2);
        }

        @Override
        public void write(char[] cArray) {
            this.pw.write(cArray);
        }

        @Override
        public void write(String string, int n, int n2) {
            this.pw.write(string, n, n2);
        }

        @Override
        public void write(String string) {
            this.pw.write(string);
        }

        @Override
        public void print(boolean bl) {
            this.pw.print(bl);
        }

        @Override
        public void print(char c) {
            this.pw.print(c);
        }

        @Override
        public void print(int n) {
            this.pw.print(n);
        }

        @Override
        public void print(long l) {
            this.pw.print(l);
        }

        @Override
        public void print(float f) {
            this.pw.print(f);
        }

        @Override
        public void print(double d) {
            this.pw.print(d);
        }

        @Override
        public void print(char[] cArray) {
            this.pw.print(cArray);
        }

        @Override
        public void print(String string) {
            this.pw.print(string);
        }

        @Override
        public void print(Object object) {
            this.pw.print(object);
        }

        @Override
        public void println() {
            this.pw.println();
        }

        @Override
        public void println(boolean bl) {
            this.pw.println(bl);
        }

        @Override
        public void println(char c) {
            this.pw.println(c);
        }

        @Override
        public void println(int n) {
            this.pw.println(n);
        }

        @Override
        public void println(long l) {
            this.pw.println(l);
        }

        @Override
        public void println(float f) {
            this.pw.println(f);
        }

        @Override
        public void println(double d) {
            this.pw.println(d);
        }

        @Override
        public void println(char[] cArray) {
            this.pw.println(cArray);
        }

        @Override
        public void println(String string) {
            this.pw.println(string);
        }

        @Override
        public void println(Object object) {
            this.pw.println(object);
        }
    }

    private static class NoBodyOutputStream
    extends ServletOutputStream {
        private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
        private static final ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
        private final NoBodyResponse response;
        private boolean flushed = false;
        private long writtenByteCount = 0L;

        private NoBodyOutputStream(NoBodyResponse noBodyResponse) {
            this.response = noBodyResponse;
        }

        private long getWrittenByteCount() {
            return this.writtenByteCount;
        }

        @Override
        public void write(int n) throws IOException {
            ++this.writtenByteCount;
            this.checkCommit();
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException(lStrings.getString("err.io.nullArray"));
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                String string = lStrings.getString("err.io.indexOutOfBounds");
                Object[] objectArray = new Object[]{n, n2, byArray.length};
                string = MessageFormat.format(string, objectArray);
                throw new IndexOutOfBoundsException(string);
            }
            this.writtenByteCount += (long)n2;
            this.checkCommit();
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
            this.response.originalOutputStream.setWriteListener(writeListener);
        }

        private void checkCommit() throws IOException {
            if (!this.flushed && this.writtenByteCount > (long)this.response.getBufferSize()) {
                this.response.flushBuffer();
                this.flushed = true;
            }
        }

        private void resetBuffer() {
            if (this.flushed) {
                throw new IllegalStateException(lStrings.getString("err.state.commit"));
            }
            this.writtenByteCount = 0L;
        }
    }
}

