/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;

public class ZkDynamicConfig {
    public static final Pattern linePattern = Pattern.compile("server\\.(?<serverId>\\d+) ?= ?(?<address>[^:]+):(?<leaderPort>\\d+):(?<leaderElectionPort>\\d+)(:(?<role>.*?))?(\\|.*?)?(;((?<clientPortAddress>.*?):)?(?<clientPort>\\d+))?");
    private List<Server> servers = new ArrayList<Server>();
    private String version = "";

    private ZkDynamicConfig() {
    }

    public static ZkDynamicConfig parseLines(String lines) {
        ZkDynamicConfig zkDynamicConfig = new ZkDynamicConfig();
        if (StrUtils.isNotNullOrEmpty((String)lines)) {
            lines.lines().forEach(l -> {
                if (l.startsWith("version=")) {
                    zkDynamicConfig.version = l.split("=")[1];
                }
                if (l.startsWith("server.")) {
                    zkDynamicConfig.servers.add(Server.parseLine(l));
                }
            });
        }
        return zkDynamicConfig;
    }

    public static ZkDynamicConfig fromZkConnectString(String zkHost) {
        ZkDynamicConfig zkDynamicConfig = new ZkDynamicConfig();
        zkDynamicConfig.servers = Arrays.stream(zkHost.split("/")[0].split(",")).map(h -> new Server(null, null, null, null, null, h.split(":")[0], h.contains(":") ? Integer.parseInt(h.split(":")[1]) : 2181)).collect(Collectors.toList());
        return zkDynamicConfig;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public String getVersion() {
        return this.version;
    }

    public int size() {
        return this.servers.size();
    }

    public static class Server {
        public final Integer serverId;
        public final String address;
        public final Integer leaderPort;
        public final Integer leaderElectionPort;
        public final String role;
        public final String clientPortAddress;
        public final Integer clientPort;

        Server(Integer serverId, String address, Integer leaderPort, Integer leaderElectionPort, String role, String clientPortAddress, Integer clientPort) {
            this.serverId = serverId;
            this.address = address;
            this.leaderPort = leaderPort;
            this.leaderElectionPort = leaderElectionPort;
            this.role = role;
            this.clientPortAddress = clientPortAddress;
            this.clientPort = clientPort;
        }

        public String resolveClientPortAddress() {
            return "0.0.0.0".equals(this.clientPortAddress) || this.clientPortAddress == null ? this.address : this.clientPortAddress;
        }

        public static Server parseLine(String line) {
            Matcher m = linePattern.matcher(line);
            if (!m.matches()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not parse dynamic zk config line: " + line);
            }
            String clientPortStr = m.group("clientPort");
            return new Server(Integer.parseInt(m.group("serverId")), m.group("address"), Integer.parseInt(m.group("leaderPort")), Integer.parseInt(m.group("leaderElectionPort")), m.group("role"), m.group("clientPortAddress"), clientPortStr != null ? Integer.valueOf(Integer.parseInt(clientPortStr)) : null);
        }
    }
}

