/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Locale;

public class EarlyTerminatingCollectorException
extends RuntimeException {
    private static final long serialVersionUID = 5939241340763428118L;
    private final int numberScanned;
    private final int numberCollected;

    public EarlyTerminatingCollectorException(int numberCollected, int numberScanned) {
        super(String.format(Locale.ROOT, "maxHitsAllowed reached: %d documents collected out of %d scanned", numberCollected, numberScanned));
        assert (numberCollected <= numberScanned) : numberCollected + "<=" + numberScanned;
        assert (0 < numberCollected);
        this.numberCollected = numberCollected;
        this.numberScanned = numberScanned;
    }

    public int getNumberScanned() {
        return this.numberScanned;
    }

    public int getNumberCollected() {
        return this.numberCollected;
    }

    public long getApproximateTotalHits(int maxDocId) {
        if (this.numberScanned == maxDocId) {
            return this.numberCollected;
        }
        return (long)((double)maxDocId * (double)this.numberCollected / (double)this.numberScanned);
    }
}

