/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Collection;
import java.util.List;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.model.GetSegmentDataResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.api.GetSegmentData;
import org.apache.solr.handler.api.V2ApiUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;

public class SegmentsInfoRequestHandler
extends RequestHandlerBase {
    public static final String FIELD_INFO_PARAM = "fieldInfo";
    public static final String CORE_INFO_PARAM = "coreInfo";
    public static final String SIZE_INFO_PARAM = "sizeInfo";
    public static final String RAW_SIZE_PARAM = "rawSize";
    public static final String RAW_SIZE_SUMMARY_PARAM = "rawSizeSummary";
    public static final String RAW_SIZE_DETAILS_PARAM = "rawSizeDetails";
    public static final String RAW_SIZE_SAMPLING_PERCENT_PARAM = "rawSizeSamplingPercent";

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        GetSegmentData segmentDataApi = new GetSegmentData(req.getCore(), req, rsp);
        GetSegmentDataResponse response = segmentDataApi.getSegmentData(params.getBool(CORE_INFO_PARAM), params.getBool(FIELD_INFO_PARAM), params.getBool(RAW_SIZE_PARAM), params.getBool(RAW_SIZE_SUMMARY_PARAM), params.getBool(RAW_SIZE_DETAILS_PARAM), params.getFloat(RAW_SIZE_SAMPLING_PERCENT_PARAM), params.getBool(SIZE_INFO_PARAM));
        V2ApiUtils.squashIntoSolrResponseWithoutHeader(rsp, response);
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "Lucene segments info.";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_READ_PERM;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Class<? extends JerseyResource>> getJerseyResources() {
        return List.of(GetSegmentData.class);
    }
}

