/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.solr.cloud.ActiveReplicaWatcher;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.DeleteReplicaCmd;
import org.apache.solr.cloud.api.collections.LeaderRecoveryWatcher;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaMigrationUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    static boolean migrateReplicas(CollectionCommandContext ccc, Map<Replica, String> movements, boolean parallel, boolean waitForFinalState, int timeout, String asyncId, NamedList<Object> results) throws IOException, InterruptedException, KeeperException {
        int numLeaders = 0;
        for (Replica replica : movements.keySet()) {
            if (!replica.isLeader() && !waitForFinalState) continue;
            ++numLeaders;
        }
        HashMap<CallSite, ActiveReplicaWatcher> watchers = new HashMap<CallSite, ActiveReplicaWatcher>();
        ArrayList<ZkNodeProps> createdReplicas = new ArrayList<ZkNodeProps>();
        AtomicBoolean anyOneFailed = new AtomicBoolean(false);
        SolrCloseableLatch countDownLatch = new SolrCloseableLatch(movements.size(), ccc.getCloseableToLatchOn());
        SolrCloseableLatch replicasToRecover = new SolrCloseableLatch(numLeaders, ccc.getCloseableToLatchOn());
        ClusterState clusterState = ccc.getZkStateReader().getClusterState();
        for (Map.Entry<Replica, String> entry : movements.entrySet()) {
            NamedList nl;
            ZkNodeProps addedReplica;
            Replica sourceReplica = entry.getKey();
            String targetNode = entry.getValue();
            String sourceCollection = sourceReplica.getCollection();
            if (log.isInfoEnabled()) {
                log.info("Going to create replica for collection={} shard={} on node={}", new Object[]{sourceCollection, sourceReplica.getShard(), targetNode});
            }
            ZkNodeProps msg = sourceReplica.toFullProps().plus("parallel", (Object)String.valueOf(parallel)).plus("node", (Object)targetNode);
            if (asyncId != null) {
                msg.getProperties().put("async", asyncId);
            }
            if ((addedReplica = new AddReplicaCmd(ccc).addReplica(clusterState, msg, (NamedList<Object>)(nl = new NamedList()), () -> {
                countDownLatch.countDown();
                if (nl.get("failure") != null) {
                    String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s", sourceCollection, sourceReplica.getShard(), targetNode);
                    log.warn(errorString);
                    NamedList namedList = results;
                    synchronized (namedList) {
                        results.add("failure", (Object)errorString);
                        anyOneFailed.set(true);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Successfully created replica for collection={} shard={} on node={}", new Object[]{sourceCollection, sourceReplica.getShard(), targetNode});
                }
            }).get(0)) == null) continue;
            createdReplicas.add(addedReplica);
            if (sourceReplica.isLeader() || waitForFinalState) {
                String shardName = sourceReplica.getShard();
                String replicaName = sourceReplica.getName();
                String key = sourceCollection + "_" + replicaName;
                Object watcher = waitForFinalState ? new ActiveReplicaWatcher(sourceCollection, null, Collections.singletonList(addedReplica.getStr("core")), replicasToRecover) : new LeaderRecoveryWatcher(sourceCollection, shardName, replicaName, addedReplica.getStr("core"), replicasToRecover);
                watchers.put((CallSite)((Object)key), (ActiveReplicaWatcher)watcher);
                log.debug("--- adding {}, {}", (Object)key, watcher);
                ccc.getZkStateReader().registerCollectionStateWatcher(sourceCollection, (CollectionStateWatcher)watcher);
                continue;
            }
            log.debug("--- not waiting for {}", (Object)addedReplica);
        }
        log.debug("Waiting for replicas to be added");
        if (!countDownLatch.await((long)timeout, TimeUnit.SECONDS)) {
            log.info("Timed out waiting for replicas to be added");
            anyOneFailed.set(true);
        } else {
            log.debug("Finished waiting for replicas to be added");
        }
        log.debug("Waiting for {} leader replicas to recover", (Object)numLeaders);
        if (!replicasToRecover.await((long)timeout, TimeUnit.SECONDS)) {
            if (log.isInfoEnabled()) {
                log.info("Timed out waiting for {} leader replicas to recover", (Object)replicasToRecover.getCount());
            }
            anyOneFailed.set(true);
        } else {
            log.debug("Finished waiting for leader replicas to recover");
        }
        for (Map.Entry<Object, String> entry : watchers.entrySet()) {
            ccc.getZkStateReader().removeCollectionStateWatcher((String)entry.getKey(), (CollectionStateWatcher)entry.getValue());
        }
        if (anyOneFailed.get()) {
            log.info("Failed to create some replicas. Cleaning up all newly created replicas.");
            SolrCloseableLatch cleanupLatch = new SolrCloseableLatch(createdReplicas.size(), ccc.getCloseableToLatchOn());
            for (ZkNodeProps createdReplica : createdReplicas) {
                NamedList deleteResult = new NamedList();
                try {
                    new DeleteReplicaCmd(ccc).deleteReplica(ccc.getZkStateReader().getClusterState(), createdReplica.plus("parallel", (Object)"true"), (NamedList<Object>)deleteResult, () -> {
                        cleanupLatch.countDown();
                        if (deleteResult.get("failure") != null) {
                            NamedList namedList = results;
                            synchronized (namedList) {
                                results.add("failure", (Object)("Could not cleanup, because of : " + String.valueOf(deleteResult.get("failure"))));
                            }
                        }
                    });
                }
                catch (KeeperException e) {
                    cleanupLatch.countDown();
                    log.warn("Error deleting replica ", (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("Error deleting replica ", (Throwable)e);
                    cleanupLatch.countDown();
                    throw e;
                }
            }
            cleanupLatch.await(5L, TimeUnit.MINUTES);
            return false;
        }
        return ReplicaMigrationUtils.cleanupReplicas(results, ccc.getZkStateReader().getClusterState(), movements.keySet(), ccc, asyncId);
    }

    static boolean cleanupReplicas(NamedList<Object> results, ClusterState clusterState, Collection<Replica> sourceReplicas, CollectionCommandContext ccc, String async) throws IOException, InterruptedException {
        SolrCloseableLatch cleanupLatch = new SolrCloseableLatch(sourceReplicas.size(), ccc.getCloseableToLatchOn());
        for (Replica sourceReplica : sourceReplicas) {
            String coll = sourceReplica.getCollection();
            String shard = sourceReplica.getShard();
            String type = sourceReplica.getType().toString();
            String node = sourceReplica.getNodeName();
            log.info("Deleting replica type={} for collection={} shard={} on node={}", new Object[]{type, coll, shard, node});
            NamedList deleteResult = new NamedList();
            try {
                ZkNodeProps cmdMessage = sourceReplica.toFullProps();
                if (async != null) {
                    cmdMessage = cmdMessage.plus("async", (Object)async);
                }
                new DeleteReplicaCmd(ccc).deleteReplica(clusterState, cmdMessage.plus("parallel", (Object)"true"), (NamedList<Object>)deleteResult, () -> {
                    cleanupLatch.countDown();
                    if (deleteResult.get("failure") != null) {
                        NamedList namedList = results;
                        synchronized (namedList) {
                            results.add("failure", (Object)String.format(Locale.ROOT, "Failed to delete replica for collection=%s shard=%s on node=%s", coll, shard, node));
                        }
                    }
                });
            }
            catch (KeeperException e) {
                log.warn("Error deleting ", (Throwable)e);
                cleanupLatch.countDown();
            }
            catch (Exception e) {
                log.warn("Error deleting ", (Throwable)e);
                cleanupLatch.countDown();
                throw e;
            }
        }
        log.debug("Waiting for delete node action to complete");
        return cleanupLatch.await(5L, TimeUnit.MINUTES);
    }

    static List<Replica> getReplicasOfNodes(Collection<String> nodeNames, ClusterState state) {
        return state.collectionStream().flatMap(dc -> dc.getSlices().stream()).flatMap(s -> s.getReplicas().stream()).filter(r -> nodeNames.contains(r.getNodeName())).collect(Collectors.toList());
    }

    static List<Replica> getReplicasOfNode(String nodeName, ClusterState state) {
        return state.collectionStream().flatMap(dc -> dc.getSlices().stream()).flatMap(s -> s.getReplicas().stream()).filter(r -> nodeName.equals(r.getNodeName())).collect(Collectors.toList());
    }
}

