/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.XML;

public class RequestWriter {
    public ContentWriter getContentWriter(SolrRequest<?> req) {
        if (req instanceof UpdateRequest) {
            final UpdateRequest updateRequest = (UpdateRequest)req;
            if (this.isEmpty(updateRequest)) {
                return null;
            }
            return new ContentWriter(){

                @Override
                public void write(OutputStream os) throws IOException {
                    OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                    RequestWriter.this.writeXML(updateRequest, writer);
                    writer.flush();
                }

                @Override
                public String getContentType() {
                    return "application/xml; charset=UTF-8";
                }
            };
        }
        return req.getContentWriter("application/xml; charset=UTF-8");
    }

    @Deprecated
    public Collection<ContentStream> getContentStreams(SolrRequest<?> req) throws IOException {
        if (req instanceof UpdateRequest) {
            return null;
        }
        return req.getContentStreams();
    }

    protected boolean isEmpty(UpdateRequest updateRequest) {
        return this.isNull(updateRequest.getDocuments()) && this.isNull(updateRequest.getDeleteByIdMap()) && this.isNull(updateRequest.getDeleteQuery()) && updateRequest.getDocIterator() == null;
    }

    @Deprecated
    public String getPath(SolrRequest<?> req) {
        return req.getPath();
    }

    public void write(SolrRequest<?> request, OutputStream os) throws IOException {
        if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));
            this.writeXML(updateRequest, writer);
            writer.flush();
        }
    }

    public String getUpdateContentType() {
        return "application/xml; charset=UTF-8";
    }

    protected boolean isNull(List<?> l) {
        return l == null || l.isEmpty();
    }

    protected boolean isNull(Map<?, ?> l) {
        return l == null || l.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public void writeXML(UpdateRequest request, Writer writer) throws IOException {
        boolean hasDeleteByQuery;
        List<Map<SolrInputDocument, Map<String, Object>>> getDocLists = this.getDocLists(request);
        for (Map<SolrInputDocument, Map<String, Object>> docs : getDocLists) {
            void var9_11;
            void var9_14;
            if (docs == null || docs.isEmpty()) continue;
            Map.Entry<SolrInputDocument, Map<String, Object>> firstDoc = docs.entrySet().iterator().next();
            Map<String, Object> map = firstDoc.getValue();
            Integer cw = null;
            Object var9_12 = null;
            if (map != null) {
                cw = (Integer)firstDoc.getValue().get("cw");
                Boolean bl = (Boolean)firstDoc.getValue().get("ow");
            }
            if (var9_14 == null) {
                Boolean bl = true;
            }
            int commitWithin = cw != null && cw != -1 ? cw.intValue() : request.getCommitWithin();
            boolean overwrite = var9_11.booleanValue();
            if (commitWithin > -1 || !overwrite) {
                writer.write("<add commitWithin=\"" + commitWithin + "\" overwrite=\"" + overwrite + "\">");
            } else {
                writer.write("<add>");
            }
            Set<Map.Entry<SolrInputDocument, Map<String, Object>>> entries = docs.entrySet();
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry : entries) {
                ClientUtils.writeXML(entry.getKey(), writer);
            }
            writer.write("</add>");
        }
        Map<String, Map<String, Object>> deleteById = request.getDeleteByIdMap();
        List<String> deleteQuery = request.getDeleteQuery();
        boolean hasDeleteById = deleteById != null && !deleteById.isEmpty();
        boolean bl = hasDeleteByQuery = deleteQuery != null && !deleteQuery.isEmpty();
        if (hasDeleteById || hasDeleteByQuery) {
            if (request.getCommitWithin() > 0) {
                writer.append("<delete commitWithin=\"").append(String.valueOf(request.getCommitWithin())).append("\">");
            } else {
                writer.append("<delete>");
            }
            if (hasDeleteById) {
                for (Map.Entry entry : deleteById.entrySet()) {
                    writer.append("<id");
                    Map map = (Map)entry.getValue();
                    if (map != null) {
                        Long version = (Long)map.get("ver");
                        String route = (String)map.get("_route_");
                        if (version != null) {
                            writer.append(" version=\"").append(String.valueOf(version)).append('\"');
                        }
                        if (route != null) {
                            writer.append(" _route_=\"").append(route).append('\"');
                        }
                    }
                    writer.append(">");
                    XML.escapeCharData((String)entry.getKey(), writer);
                    writer.append("</id>");
                }
            }
            if (hasDeleteByQuery) {
                for (String string : deleteQuery) {
                    writer.append("<query>");
                    XML.escapeCharData(string, writer);
                    writer.append("</query>");
                }
            }
            writer.append("</delete>");
        }
    }

    private List<Map<SolrInputDocument, Map<String, Object>>> getDocLists(UpdateRequest request) {
        Iterator<SolrInputDocument> docIterator;
        ArrayList<Map<SolrInputDocument, Map<String, Object>>> docLists = new ArrayList<Map<SolrInputDocument, Map<String, Object>>>();
        LinkedHashMap<SolrInputDocument, Map<String, Object>> docList = null;
        if (request.getDocumentsMap() != null) {
            Boolean lastOverwrite = true;
            Integer lastCommitWithin = -1;
            Map<SolrInputDocument, Map<String, Object>> documents = request.getDocumentsMap();
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry : documents.entrySet()) {
                Map<String, Object> map = entry.getValue();
                Boolean overwrite = null;
                Integer commitWithin = null;
                if (map != null) {
                    overwrite = (Boolean)entry.getValue().get("ow");
                    commitWithin = (Integer)entry.getValue().get("cw");
                }
                if (!Objects.equals(overwrite, lastOverwrite) || !Objects.equals(commitWithin, lastCommitWithin) || docLists.isEmpty()) {
                    docList = new LinkedHashMap();
                    docLists.add(docList);
                }
                docList.put(entry.getKey(), entry.getValue());
                lastCommitWithin = commitWithin;
                lastOverwrite = overwrite;
            }
        }
        if ((docIterator = request.getDocIterator()) != null) {
            docList = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
            docLists.add(docList);
            while (docIterator.hasNext()) {
                SolrInputDocument doc = docIterator.next();
                if (doc == null) continue;
                docList.put(doc, null);
            }
        }
        return docLists;
    }

    public static class StringPayloadContentWriter
    implements ContentWriter {
        public final String payload;
        public final String type;

        public StringPayloadContentWriter(String payload, String type) {
            this.payload = payload;
            this.type = type;
        }

        @Override
        public void write(OutputStream os) throws IOException {
            if (this.payload == null) {
                return;
            }
            os.write(this.payload.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public String getContentType() {
            return this.type;
        }
    }

    public static interface ContentWriter {
        public void write(OutputStream var1) throws IOException;

        public String getContentType();
    }
}

