/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.carrot2.util.ResourceLookup;

final class PathResourceLookup
implements ResourceLookup {
    private final List<Path> locations;

    PathResourceLookup(List<Path> locations) {
        if (locations == null || locations.isEmpty()) {
            throw new RuntimeException("At least one resource location is required.");
        }
        this.locations = locations;
    }

    public InputStream open(String resource) throws IOException {
        Path p = this.locate(resource);
        if (p == null) {
            throw new IOException("Resource " + String.valueOf(p) + " not found relative to: " + this.locations.stream().map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining(", ")));
        }
        return new BufferedInputStream(Files.newInputStream(p, new OpenOption[0]));
    }

    public boolean exists(String resource) {
        return this.locate(resource) != null;
    }

    public String pathOf(String resource) {
        return "[" + this.locations.stream().map(path -> path.resolve(resource).toAbsolutePath().toString()).collect(Collectors.joining(" | ")) + "]";
    }

    private Path locate(String resource) {
        for (Path base : this.locations) {
            Path p = base.resolve(resource);
            if (!Files.exists(p, new LinkOption[0])) continue;
            return p;
        }
        return null;
    }
}

