/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TermMatchesIterator;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

public class TermQuery
extends Query {
    private final Term term;
    private final TermStates perReaderTermState;

    public TermQuery(Term t) {
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = null;
    }

    public TermQuery(Term t, TermStates states) {
        assert (states != null);
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = Objects.requireNonNull(states);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        IndexReaderContext context = searcher.getTopReaderContext();
        TermStates termState = this.perReaderTermState == null || !this.perReaderTermState.wasBuiltFor(context) ? TermStates.build(searcher, this.term, scoreMode.needsScores()) : this.perReaderTermState;
        return new TermWeight(searcher, scoreMode, boost, termState);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.term.field())) {
            visitor.consumeTerms(this, this.term);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }

    public TermStates getTermStates() {
        return this.perReaderTermState;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals(((TermQuery)other).term);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final Similarity similarity;
        private final Similarity.SimScorer simScorer;
        private final TermStates termStates;
        private final ScoreMode scoreMode;

        public TermWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost, TermStates termStates) throws IOException {
            TermStatistics termStats;
            CollectionStatistics collectionStats;
            super(TermQuery.this);
            if (scoreMode.needsScores() && termStates == null) {
                throw new IllegalStateException("termStates are required when scores are needed");
            }
            this.scoreMode = scoreMode;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity();
            if (scoreMode.needsScores()) {
                collectionStats = searcher.collectionStatistics(TermQuery.this.term.field());
                termStats = termStates.docFreq() > 0 ? searcher.termStatistics(TermQuery.this.term, termStates.docFreq(), termStates.totalTermFreq()) : null;
            } else {
                collectionStats = new CollectionStatistics(TermQuery.this.term.field(), 1L, 1L, 1L, 1L);
                termStats = new TermStatistics(TermQuery.this.term.bytes(), 1L, 1L);
            }
            this.simScorer = termStats == null ? null : (scoreMode.needsScores() ? this.similarity.scorer(boost, collectionStats, termStats) : new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return 0.0f;
                }
            });
        }

        @Override
        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            TermsEnum te = this.getTermsEnum(context);
            if (te == null) {
                return null;
            }
            return MatchesUtils.forField(TermQuery.this.term.field(), () -> {
                PostingsEnum pe = te.postings(null, 56);
                if (pe.advance(doc) != doc) {
                    return null;
                }
                return new TermMatchesIterator(this.getQuery(), pe);
            });
        }

        public String toString() {
            return "weight(" + String.valueOf(TermQuery.this) + ")";
        }

        @Override
        public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
            assert (this.termStates == null || this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + String.valueOf(ReaderUtil.getTopLevelContext(context));
            final TermsEnum termsEnum = this.getTermsEnum(context);
            if (termsEnum == null) {
                return null;
            }
            final int docFreq = termsEnum.docFreq();
            return new ScorerSupplier(){
                private boolean topLevelScoringClause = false;

                @Override
                public Scorer get(long leadCost) throws IOException {
                    LeafSimScorer scorer = new LeafSimScorer(TermWeight.this.simScorer, context.reader(), TermQuery.this.term.field(), TermWeight.this.scoreMode.needsScores());
                    if (TermWeight.this.scoreMode == ScoreMode.TOP_SCORES) {
                        return new TermScorer(TermWeight.this, termsEnum.impacts(8), scorer, this.topLevelScoringClause);
                    }
                    return new TermScorer(TermWeight.this, termsEnum.postings(null, TermWeight.this.scoreMode.needsScores() ? 8 : 0), scorer);
                }

                @Override
                public long cost() {
                    return docFreq;
                }

                @Override
                public void setTopLevelScoringClause() throws IOException {
                    this.topLevelScoringClause = true;
                }
            };
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            ScorerSupplier supplier = this.scorerSupplier(context);
            if (supplier == null) {
                return null;
            }
            return supplier.get(Long.MAX_VALUE);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        private TermsEnum getTermsEnum(LeafReaderContext context) throws IOException {
            assert (this.termStates != null);
            assert (this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + String.valueOf(ReaderUtil.getTopLevelContext(context));
            TermState state = this.termStates.get(context);
            if (state == null) {
                assert (this.termNotInReader(context.reader(), TermQuery.this.term)) : "no termstate found but term exists in reader term=" + String.valueOf(TermQuery.this.term);
                return null;
            }
            TermsEnum termsEnum = context.reader().terms(TermQuery.this.term.field()).iterator();
            termsEnum.seekExact(TermQuery.this.term.bytes(), state);
            return termsEnum;
        }

        private boolean termNotInReader(LeafReader reader, Term term) throws IOException {
            return reader.docFreq(term) == 0;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            TermScorer scorer = (TermScorer)this.scorer(context);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = scorer.freq();
                LeafSimScorer docScorer = new LeafSimScorer(this.simScorer, context.reader(), TermQuery.this.term.field(), true);
                Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), "freq, occurrences of term within document", new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + String.valueOf(this.getQuery()) + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }

        @Override
        public int count(LeafReaderContext context) throws IOException {
            if (!context.reader().hasDeletions()) {
                TermsEnum termsEnum = this.getTermsEnum(context);
                if (termsEnum != null) {
                    return termsEnum.docFreq();
                }
                return 0;
            }
            return super.count(context);
        }
    }
}

