/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.style.NoStyleAvailableException;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.warning.Warning;

public class CommandSkinParam
extends SingleLineCommand2<TitledDiagram> {
    public static final CommandSkinParam ME = new CommandSkinParam();

    private CommandSkinParam() {
        super(CommandSkinParam.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandSkinParam.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "TYPE", "(skinparam|skinparamlocked)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "NAME", "([\\w.]*(?:\\<\\<[^<>]*\\>\\>)?[\\w.]*)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "VALUE", "([^{}]*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        try {
            String name = arg.get("NAME", 0);
            if ("handwritten".equalsIgnoreCase(name)) {
                diagram.addWarning(new Warning("Please use '!option handwritten true' to enable handwritten "));
            }
            diagram.setParam(name, arg.get("VALUE", 0));
            diagram.setSkinParamUsed(true);
            return CommandExecutionResult.ok();
        }
        catch (NoStyleAvailableException e) {
            return CommandExecutionResult.error("General failure: no style available.");
        }
    }
}

