/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework.schema;

import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.hadoop.shaded.org.apache.curator.framework.schema.DefaultSchemaValidator;
import org.apache.hadoop.shaded.org.apache.curator.framework.schema.Schema;
import org.apache.hadoop.shaded.org.apache.curator.framework.schema.SchemaValidator;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableMap;

public class SchemaBuilder {
    private final Pattern pathRegex;
    private final String path;
    private String name = UUID.randomUUID().toString();
    private String documentation = "";
    private SchemaValidator schemaValidator = new DefaultSchemaValidator();
    private Schema.Allowance ephemeral = Schema.Allowance.CAN;
    private Schema.Allowance sequential = Schema.Allowance.CAN;
    private Schema.Allowance watched = Schema.Allowance.CAN;
    private boolean canBeDeleted = true;
    private Map<String, String> metadata = ImmutableMap.of();

    public Schema build() {
        return new Schema(this.name, this.pathRegex, this.path, this.documentation, this.schemaValidator, this.ephemeral, this.sequential, this.watched, this.canBeDeleted, this.metadata);
    }

    public SchemaBuilder name(String name) {
        this.name = Preconditions.checkNotNull(name, "name cannot be null");
        return this;
    }

    public SchemaBuilder documentation(String documentation) {
        this.documentation = Preconditions.checkNotNull(documentation, "documentation cannot be null");
        return this;
    }

    public SchemaBuilder dataValidator(SchemaValidator schemaValidator) {
        this.schemaValidator = Preconditions.checkNotNull(schemaValidator, "dataValidator cannot be null");
        return this;
    }

    public SchemaBuilder ephemeral(Schema.Allowance ephemeral) {
        this.ephemeral = Preconditions.checkNotNull(ephemeral, "ephemeral cannot be null");
        return this;
    }

    public SchemaBuilder sequential(Schema.Allowance sequential) {
        this.sequential = Preconditions.checkNotNull(sequential, "sequential cannot be null");
        return this;
    }

    public SchemaBuilder watched(Schema.Allowance watched) {
        this.watched = watched;
        return this;
    }

    public SchemaBuilder canBeDeleted(boolean canBeDeleted) {
        this.canBeDeleted = canBeDeleted;
        return this;
    }

    public SchemaBuilder metadata(Map<String, String> metadata) {
        this.metadata = ImmutableMap.copyOf(metadata);
        return this;
    }

    SchemaBuilder(Pattern pathRegex, String path) {
        this.pathRegex = pathRegex;
        this.path = path;
    }
}

