/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.transport.response;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.jobscheduler.transport.response.GetScheduledInfoNodeResponse;

public class GetScheduledInfoResponse
extends BaseNodesResponse<GetScheduledInfoNodeResponse>
implements ToXContent {
    public GetScheduledInfoResponse(StreamInput in) throws IOException {
        super(in);
    }

    public GetScheduledInfoResponse(ClusterName clusterName, List<GetScheduledInfoNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public List<GetScheduledInfoNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(GetScheduledInfoNodeResponse::new);
    }

    public void writeNodesTo(StreamOutput out, List<GetScheduledInfoNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean byNode = params.paramAsBoolean("by_node", false);
        int totalJobs = 0;
        builder.startObject();
        if (byNode) {
            builder.startArray("nodes");
            for (Object nodeResponse : this.getNodes()) {
                ((GetScheduledInfoNodeResponse)((Object)nodeResponse)).toXContent(builder, params);
                totalJobs += ((Integer)((GetScheduledInfoNodeResponse)((Object)nodeResponse)).getScheduledJobInfo().get("total_jobs")).intValue();
            }
            builder.endArray();
        } else {
            builder.startArray("jobs");
            HashSet<String> seenJobIds = new HashSet<String>();
            for (GetScheduledInfoNodeResponse nodeResponse : this.getNodes()) {
                Object jobs = nodeResponse.getScheduledJobInfo().get("jobs");
                if (!(jobs instanceof List)) continue;
                for (Object job : (List)jobs) {
                    Map jobMap;
                    String jobId;
                    if (!(job instanceof Map) || (jobId = (String)(jobMap = (Map)job).get("job_id")) == null || !seenJobIds.add(jobId)) continue;
                    builder.value(job);
                    ++totalJobs;
                }
            }
            builder.endArray();
        }
        builder.startArray("failures");
        for (FailedNodeException failure : this.failures()) {
            builder.startObject();
            builder.field("node_id", failure.nodeId());
            builder.field("reason", failure.getMessage());
            builder.endObject();
        }
        builder.endArray();
        builder.field("total_jobs", totalJobs);
        builder.endObject();
        return builder;
    }

    public Map<String, Map<String, Object>> getScheduledJobInfoByNode() {
        return this.getNodes().stream().collect(Collectors.toMap(node -> node.getNode().getId(), GetScheduledInfoNodeResponse::getScheduledJobInfo));
    }
}

