/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement;

import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.indexstatemanagement.settings.ManagedIndexSettings;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.indexmanagement.util.OpenForTesting;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@OpenForTesting
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0017\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u0011\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0016H\u0016J\u000e\u0010\u001f\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\"\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\"H\u0092@\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0018\u0010\u0010\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006&"}, d2={"Lorg/opensearch/indexmanagement/IndexManagementIndices;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/IndicesAdminClient;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/cluster/service/ClusterService;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "historyNumberOfShards", "", "Ljava/lang/Integer;", "historyNumberOfReplicas", "checkAndUpdateIMConfigIndex", "", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/action/support/clustermanager/AcknowledgedResponse;", "", "(Lorg/apache/logging/log4j/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexManagementIndexExists", "attemptInitStateManagementIndex", "Lorg/opensearch/transport/client/Client;", "(Lorg/opensearch/transport/client/Client;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attemptUpdateConfigIndexMapping", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexStateManagementIndexHistoryExists", "checkAndUpdateHistoryIndex", "createHistoryIndex", "index", "", "alias", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "opensearch-index-management"})
public class IndexManagementIndices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndicesAdminClient client;
    @NotNull
    private final ClusterService clusterService;
    private final Logger logger;
    private volatile Integer historyNumberOfShards;
    private volatile Integer historyNumberOfReplicas;
    @NotNull
    public static final String HISTORY_INDEX_BASE = ".opendistro-ism-managed-index-history";
    @NotNull
    public static final String HISTORY_WRITE_INDEX_ALIAS = ".opendistro-ism-managed-index-history-write";
    @NotNull
    public static final String HISTORY_INDEX_PATTERN = "<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>";
    @NotNull
    public static final String HISTORY_ALL = ".opendistro-ism-managed-index-history*";
    @NotNull
    private static final String indexManagementMappings;
    @NotNull
    private static final String indexStateManagementHistoryMappings;
    @NotNull
    private static final String rollupTargetMappings;
    @NotNull
    private static final String transformTargetMappings;

    public IndexManagementIndices(@NotNull Settings settings, @NotNull IndicesAdminClient client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
        this.logger = LogManager.getLogger(this.getClass());
        this.historyNumberOfShards = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS().get(settings);
        this.historyNumberOfReplicas = (Integer)ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS().get(settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_SHARDS(), arg_0 -> IndexManagementIndices._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ManagedIndexSettings.Companion.getHISTORY_NUMBER_OF_REPLICAS(), arg_0 -> IndexManagementIndices._init_$lambda$1(this, arg_0));
    }

    public void checkAndUpdateIMConfigIndex(@NotNull ActionListener<AcknowledgedResponse> actionListener) {
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        if (!this.indexManagementIndexExists()) {
            CreateIndexRequest indexRequest = new CreateIndexRequest(".opendistro-ism-config").mapping(indexManagementMappings).settings(Settings.builder().put("index.hidden", true).build());
            this.client.create(indexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(actionListener){
                final /* synthetic */ ActionListener<AcknowledgedResponse> $actionListener;
                {
                    this.$actionListener = $actionListener;
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$actionListener.onFailure(e);
                }

                public void onResponse(CreateIndexResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    this.$actionListener.onResponse((Object)response2);
                }
            });
        } else {
            ClusterState clusterState = this.clusterService.state();
            Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"state(...)");
            IndexUtils.Companion.checkAndUpdateConfigIndexMapping(clusterState, this.client, actionListener);
        }
    }

    @Nullable
    public Object checkAndUpdateIMConfigIndex(@NotNull Logger logger, @NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.checkAndUpdateIMConfigIndex$suspendImpl(this, logger, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object checkAndUpdateIMConfigIndex$suspendImpl(IndexManagementIndices $this, Logger logger, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof checkAndUpdateIMConfigIndex.2)) ** GOTO lbl-1000
        var9_3 = $completion;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.checkAndUpdateIMConfigIndex$suspendImpl(this.this$0, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.L$1 = logger;
                $continuation.label = 1;
                var4_6 = (Continuation)$continuation;
                var5_7 = new SafeContinuation(IntrinsicsKt.intercepted((Continuation)var4_6));
                cont = (Continuation)var5_7;
                $i$a$-suspendCoroutine-IndexManagementIndices$checkAndUpdateIMConfigIndex$response$1 = false;
                $this.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)((ActionListener)new ActionListener<AcknowledgedResponse>((Continuation<? super AcknowledgedResponse>)cont){
                    final /* synthetic */ Continuation<AcknowledgedResponse> $cont;
                    {
                        this.$cont = $cont;
                    }

                    public void onResponse(AcknowledgedResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        this.$cont.resumeWith(Result.constructor-impl((Object)response2));
                    }

                    public void onFailure(Exception e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.$cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
                    }
                }));
                v0 = var5_7.getOrThrow();
                if (v0 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    DebugProbesKt.probeCoroutineSuspended((Continuation)((Continuation)$continuation));
                }
                v1 = v0;
                if (v0 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl34
            }
            case 1: {
                logger = (Logger)$continuation.L$1;
                $this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                response = (AcknowledgedResponse)v1;
                if (response.isAcknowledged()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                logger.error("Unable to create or update .opendistro-ism-config with newest mapping.");
                throw new OpenSearchStatusException("Unable to create or update .opendistro-ism-config with newest mapping.", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public boolean indexManagementIndexExists() {
        return this.clusterService.state().getRoutingTable().hasIndex(".opendistro-ism-config");
    }

    @Nullable
    public Object attemptInitStateManagementIndex(@NotNull Client client, @NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.attemptInitStateManagementIndex$suspendImpl(this, client, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object attemptInitStateManagementIndex$suspendImpl(IndexManagementIndices $this, Client client, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof attemptInitStateManagementIndex.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.attemptInitStateManagementIndex$suspendImpl(this.this$0, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if ($this.indexManagementIndexExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $continuation.L$0 = $this;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, attemptInitStateManagementIndex$lambda$3(org.opensearch.indexmanagement.IndexManagementIndices org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexManagementIndices)$this), $continuation);
                ** if (v0 != var7_5) goto lbl22
lbl21:
                // 1 sources

                return var7_5;
lbl22:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                client = (Client)$continuation.L$1;
                $this = (IndexManagementIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    if ((response = (AcknowledgedResponse)v0).isAcknowledged()) {
                        return Boxing.boxBoolean((boolean)true);
                    }
                    $this.logger.error("Creating .opendistro-ism-config with mappings NOT acknowledged");
                    return Boxing.boxBoolean((boolean)false);
                }
                catch (ResourceAlreadyExistsException e) {
                    var3_7 = true;
                }
                catch (Exception e) {
                    $this.logger.error("Error trying to create .opendistro-ism-config", (Throwable)e);
                    var3_7 = false;
                }
                return Boxing.boxBoolean((boolean)(var3_7 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object attemptUpdateConfigIndexMapping(@NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.attemptUpdateConfigIndexMapping$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object attemptUpdateConfigIndexMapping$suspendImpl(IndexManagementIndices $this, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof attemptUpdateConfigIndexMapping.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.attemptUpdateConfigIndexMapping$suspendImpl(this.this$0, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this.client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, attemptUpdateConfigIndexMapping$lambda$4(org.opensearch.indexmanagement.IndexManagementIndices org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexManagementIndices)$this), $continuation);
                ** if (v0 != var6_4) goto lbl19
lbl18:
                // 1 sources

                return var6_4;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                $this = (IndexManagementIndices)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    if ((response = (AcknowledgedResponse)v0).isAcknowledged()) {
                        return Boxing.boxBoolean((boolean)true);
                    }
                    $this.logger.error("Trying to update config index mapping not acknowledged.");
                    return Boxing.boxBoolean((boolean)false);
                }
                catch (Exception e) {
                    $this.logger.error("Failed when trying to update config index mapping.", (Throwable)e);
                    return Boxing.boxBoolean((boolean)false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public boolean indexStateManagementIndexHistoryExists() {
        return this.clusterService.state().getMetadata().hasAlias(HISTORY_WRITE_INDEX_ALIAS);
    }

    @Nullable
    public Object checkAndUpdateHistoryIndex(@NotNull Continuation<? super Boolean> $completion) {
        return IndexManagementIndices.checkAndUpdateHistoryIndex$suspendImpl(this, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object checkAndUpdateHistoryIndex$suspendImpl(IndexManagementIndices $this, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof checkAndUpdateHistoryIndex.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.checkAndUpdateHistoryIndex$suspendImpl(this.this$0, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if ($this.indexStateManagementIndexHistoryExists()) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this);
                $continuation.label = 1;
                v0 = $this.createHistoryIndex("<.opendistro-ism-managed-index-history-{now/d{yyyy.MM.dd}}-1>", ".opendistro-ism-managed-index-history-write", (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                $this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                return v0;
            }
        }
        $continuation.L$0 = $this;
        $continuation.label = 2;
        v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)$this.client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, checkAndUpdateHistoryIndex$lambda$5(org.opensearch.indexmanagement.IndexManagementIndices org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexManagementIndices)$this), $continuation);
        if (v1 == var5_4) {
            return var5_4;
        }
        ** GOTO lbl34
        {
            case 2: {
                $this = (IndexManagementIndices)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                if ((response = (AcknowledgedResponse)v1).isAcknowledged()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                $this.logger.error("Updating .opendistro-ism-managed-index-history-write with new mappings NOT acknowledged");
                return Boxing.boxBoolean((boolean)false);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private Object createHistoryIndex(String index, String alias, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof createHistoryIndex.1)) ** GOTO lbl-1000
        var9_4 = $completion;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ IndexManagementIndices this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return IndexManagementIndices.access$createHistoryIndex(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = index;
                $continuation.L$1 = alias;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createHistoryIndex$lambda$6(org.opensearch.indexmanagement.IndexManagementIndices java.lang.String org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexManagementIndices)this, (String)index), $continuation);
                if (v0 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                alias = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((existsResponse = (IndicesExistsResponse)v0).isExists()) {
                    return Boxing.boxBoolean((boolean)true);
                }
                v1 = new CreateIndexRequest(index).mapping(IndexManagementIndices.indexStateManagementHistoryMappings);
                v2 = Settings.builder().put("index.hidden", true);
                v3 = this.historyNumberOfShards;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"historyNumberOfShards");
                v4 = v2.put("index.number_of_shards", ((Number)v3).intValue());
                v5 = this.historyNumberOfReplicas;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"historyNumberOfReplicas");
                request = v1.settings(v4.put("index.number_of_replicas", ((Number)v5).intValue()).build());
                if (alias != null) {
                    request.alias(new Alias(alias));
                }
                $continuation.L$0 = index;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)alias);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)existsResponse);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 2;
                v6 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createHistoryIndex$lambda$7(org.opensearch.indexmanagement.IndexManagementIndices org.opensearch.action.admin.indices.create.CreateIndexRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndexManagementIndices)this, (CreateIndexRequest)request), $continuation);
                ** if (v6 != var10_6) goto lbl47
lbl46:
                // 1 sources

                return var10_6;
lbl47:
                // 1 sources

                ** GOTO lbl57
            }
            case 2: {
                request = (CreateIndexRequest)$continuation.L$3;
                existsResponse = (IndicesExistsResponse)$continuation.L$2;
                alias = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl57:
                    // 2 sources

                    if ((createIndexResponse = (CreateIndexResponse)v6).isAcknowledged()) {
                        v7 = true;
                    } else {
                        this.logger.error("Creating " + index + " with mappings NOT acknowledged");
                        v7 = false;
                    }
                    var6_12 = v7;
                }
                catch (ResourceAlreadyExistsException e) {
                    var6_12 = true;
                }
                catch (Exception e) {
                    this.logger.error("Error trying to create " + index, (Throwable)e);
                    var6_12 = false;
                }
                return Boxing.boxBoolean((boolean)(var6_12 != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object createHistoryIndex$default(IndexManagementIndices indexManagementIndices, String string, String string2, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createHistoryIndex");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return indexManagementIndices.createHistoryIndex(string, string2, (Continuation<? super Boolean>)continuation);
    }

    private static final void _init_$lambda$0(IndexManagementIndices this$0, Integer it) {
        this$0.historyNumberOfShards = it;
    }

    private static final void _init_$lambda$1(IndexManagementIndices this$0, Integer it) {
        this$0.historyNumberOfReplicas = it;
    }

    private static final Unit attemptInitStateManagementIndex$lambda$3(IndexManagementIndices this$0, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)it);
        return Unit.INSTANCE;
    }

    private static final Unit attemptUpdateConfigIndexMapping$lambda$4(IndexManagementIndices this$0, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClusterState clusterState = this$0.clusterService.state();
        Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"state(...)");
        IndexUtils.Companion.checkAndUpdateConfigIndexMapping(clusterState, this$0.client, (ActionListener<AcknowledgedResponse>)it);
        return Unit.INSTANCE;
    }

    private static final Unit checkAndUpdateHistoryIndex$lambda$5(IndexManagementIndices this$0, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClusterState clusterState = this$0.clusterService.state();
        Intrinsics.checkNotNullExpressionValue((Object)clusterState, (String)"state(...)");
        IndexUtils.Companion.checkAndUpdateHistoryIndexMapping(clusterState, this$0.client, (ActionListener<AcknowledgedResponse>)it);
        return Unit.INSTANCE;
    }

    private static final Unit createHistoryIndex$lambda$6(IndexManagementIndices this$0, String $index, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{$index};
        this$0.client.exists((IndicesExistsRequest)new IndicesExistsRequest(stringArray).local(true), it);
        return Unit.INSTANCE;
    }

    private static final Unit createHistoryIndex$lambda$7(IndexManagementIndices this$0, CreateIndexRequest $request, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.client.create($request, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$createHistoryIndex(IndexManagementIndices $this, String index2, String alias, Continuation $completion) {
        return $this.createHistoryIndex(index2, alias, (Continuation<? super Boolean>)$completion);
    }

    static {
        URL uRL = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-ism-config.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        indexManagementMappings = new String(byArray, charset);
        URL uRL3 = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-ism-history.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL3, (String)"getResource(...)");
        uRL2 = uRL3;
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL2);
        indexStateManagementHistoryMappings = new String(byArray, charset);
        URL uRL4 = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-rollup-target.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL4, (String)"getResource(...)");
        uRL2 = uRL4;
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL2);
        rollupTargetMappings = new String(byArray, charset);
        URL uRL5 = IndexManagementIndices.class.getClassLoader().getResource("mappings/opendistro-transform-target.json");
        Intrinsics.checkNotNullExpressionValue((Object)uRL5, (String)"getResource(...)");
        uRL2 = uRL5;
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes((URL)uRL2);
        transformTargetMappings = new String(byArray, charset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/IndexManagementIndices$Companion;", "", "<init>", "()V", "HISTORY_INDEX_BASE", "", "HISTORY_WRITE_INDEX_ALIAS", "HISTORY_INDEX_PATTERN", "HISTORY_ALL", "indexManagementMappings", "getIndexManagementMappings", "()Ljava/lang/String;", "indexStateManagementHistoryMappings", "getIndexStateManagementHistoryMappings", "rollupTargetMappings", "getRollupTargetMappings", "transformTargetMappings", "getTransformTargetMappings", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getIndexManagementMappings() {
            return indexManagementMappings;
        }

        @NotNull
        public final String getIndexStateManagementHistoryMappings() {
            return indexStateManagementHistoryMappings;
        }

        @NotNull
        public final String getRollupTargetMappings() {
            return rollupTargetMappings;
        }

        @NotNull
        public final String getTransformTargetMappings() {
            return transformTargetMappings;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

