/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceRootVolumeTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplaceRootVolumeTask> {
    private static final SdkField<String> REPLACE_ROOT_VOLUME_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplaceRootVolumeTaskId").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::replaceRootVolumeTaskId)).setter(ReplaceRootVolumeTask.setter(Builder::replaceRootVolumeTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceRootVolumeTaskId").unmarshallLocationName("replaceRootVolumeTaskId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::instanceId)).setter(ReplaceRootVolumeTask.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> TASK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskState").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::taskStateAsString)).setter(ReplaceRootVolumeTask.setter(Builder::taskState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskState").unmarshallLocationName("taskState").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::startTime)).setter(ReplaceRootVolumeTask.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<String> COMPLETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompleteTime").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::completeTime)).setter(ReplaceRootVolumeTask.setter(Builder::completeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompleteTime").unmarshallLocationName("completeTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::tags)).setter(ReplaceRootVolumeTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::imageId)).setter(ReplaceRootVolumeTask.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::snapshotId)).setter(ReplaceRootVolumeTask.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<Boolean> DELETE_REPLACED_ROOT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteReplacedRootVolume").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::deleteReplacedRootVolume)).setter(ReplaceRootVolumeTask.setter(Builder::deleteReplacedRootVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteReplacedRootVolume").unmarshallLocationName("deleteReplacedRootVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACE_ROOT_VOLUME_TASK_ID_FIELD, INSTANCE_ID_FIELD, TASK_STATE_FIELD, START_TIME_FIELD, COMPLETE_TIME_FIELD, TAGS_FIELD, IMAGE_ID_FIELD, SNAPSHOT_ID_FIELD, DELETE_REPLACED_ROOT_VOLUME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplaceRootVolumeTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String replaceRootVolumeTaskId;
    private final String instanceId;
    private final String taskState;
    private final String startTime;
    private final String completeTime;
    private final List<Tag> tags;
    private final String imageId;
    private final String snapshotId;
    private final Boolean deleteReplacedRootVolume;

    private ReplaceRootVolumeTask(BuilderImpl builder) {
        this.replaceRootVolumeTaskId = builder.replaceRootVolumeTaskId;
        this.instanceId = builder.instanceId;
        this.taskState = builder.taskState;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.tags = builder.tags;
        this.imageId = builder.imageId;
        this.snapshotId = builder.snapshotId;
        this.deleteReplacedRootVolume = builder.deleteReplacedRootVolume;
    }

    public final String replaceRootVolumeTaskId() {
        return this.replaceRootVolumeTaskId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ReplaceRootVolumeTaskState taskState() {
        return ReplaceRootVolumeTaskState.fromValue(this.taskState);
    }

    public final String taskStateAsString() {
        return this.taskState;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String completeTime() {
        return this.completeTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Boolean deleteReplacedRootVolume() {
        return this.deleteReplacedRootVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceRootVolumeTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteReplacedRootVolume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRootVolumeTask)) {
            return false;
        }
        ReplaceRootVolumeTask other = (ReplaceRootVolumeTask)obj;
        return Objects.equals(this.replaceRootVolumeTaskId(), other.replaceRootVolumeTaskId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.taskStateAsString(), other.taskStateAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completeTime(), other.completeTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.deleteReplacedRootVolume(), other.deleteReplacedRootVolume());
    }

    public final String toString() {
        return ToString.builder((String)"ReplaceRootVolumeTask").add("ReplaceRootVolumeTaskId", (Object)this.replaceRootVolumeTaskId()).add("InstanceId", (Object)this.instanceId()).add("TaskState", (Object)this.taskStateAsString()).add("StartTime", (Object)this.startTime()).add("CompleteTime", (Object)this.completeTime()).add("Tags", this.hasTags() ? this.tags() : null).add("ImageId", (Object)this.imageId()).add("SnapshotId", (Object)this.snapshotId()).add("DeleteReplacedRootVolume", (Object)this.deleteReplacedRootVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplaceRootVolumeTaskId": {
                return Optional.ofNullable(clazz.cast(this.replaceRootVolumeTaskId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "TaskState": {
                return Optional.ofNullable(clazz.cast(this.taskStateAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CompleteTime": {
                return Optional.ofNullable(clazz.cast(this.completeTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "DeleteReplacedRootVolume": {
                return Optional.ofNullable(clazz.cast(this.deleteReplacedRootVolume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplaceRootVolumeTaskId", REPLACE_ROOT_VOLUME_TASK_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("TaskState", TASK_STATE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("CompleteTime", COMPLETE_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("DeleteReplacedRootVolume", DELETE_REPLACED_ROOT_VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplaceRootVolumeTask, T> g) {
        return obj -> g.apply((ReplaceRootVolumeTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replaceRootVolumeTaskId;
        private String instanceId;
        private String taskState;
        private String startTime;
        private String completeTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private String snapshotId;
        private Boolean deleteReplacedRootVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRootVolumeTask model) {
            this.replaceRootVolumeTaskId(model.replaceRootVolumeTaskId);
            this.instanceId(model.instanceId);
            this.taskState(model.taskState);
            this.startTime(model.startTime);
            this.completeTime(model.completeTime);
            this.tags(model.tags);
            this.imageId(model.imageId);
            this.snapshotId(model.snapshotId);
            this.deleteReplacedRootVolume(model.deleteReplacedRootVolume);
        }

        public final String getReplaceRootVolumeTaskId() {
            return this.replaceRootVolumeTaskId;
        }

        public final void setReplaceRootVolumeTaskId(String replaceRootVolumeTaskId) {
            this.replaceRootVolumeTaskId = replaceRootVolumeTaskId;
        }

        @Override
        public final Builder replaceRootVolumeTaskId(String replaceRootVolumeTaskId) {
            this.replaceRootVolumeTaskId = replaceRootVolumeTaskId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTaskState() {
            return this.taskState;
        }

        public final void setTaskState(String taskState) {
            this.taskState = taskState;
        }

        @Override
        public final Builder taskState(String taskState) {
            this.taskState = taskState;
            return this;
        }

        @Override
        public final Builder taskState(ReplaceRootVolumeTaskState taskState) {
            this.taskState(taskState == null ? null : taskState.toString());
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getCompleteTime() {
            return this.completeTime;
        }

        public final void setCompleteTime(String completeTime) {
            this.completeTime = completeTime;
        }

        @Override
        public final Builder completeTime(String completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Boolean getDeleteReplacedRootVolume() {
            return this.deleteReplacedRootVolume;
        }

        public final void setDeleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
        }

        @Override
        public final Builder deleteReplacedRootVolume(Boolean deleteReplacedRootVolume) {
            this.deleteReplacedRootVolume = deleteReplacedRootVolume;
            return this;
        }

        public ReplaceRootVolumeTask build() {
            return new ReplaceRootVolumeTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplaceRootVolumeTask> {
        public Builder replaceRootVolumeTaskId(String var1);

        public Builder instanceId(String var1);

        public Builder taskState(String var1);

        public Builder taskState(ReplaceRootVolumeTaskState var1);

        public Builder startTime(String var1);

        public Builder completeTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder snapshotId(String var1);

        public Builder deleteReplacedRootVolume(Boolean var1);
    }
}

