/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.store.RandomAccessInput;

public class ByteArrayBackedBitset {
    private final byte[] byteArray;

    public ByteArrayBackedBitset(int capacity) {
        this.byteArray = new byte[capacity];
    }

    public ByteArrayBackedBitset(RandomAccessInput in, long offset, int length) throws IOException {
        this.byteArray = new byte[length];
        in.readBytes(offset, this.byteArray, 0, length);
    }

    public void set(int index) {
        int byteArrIndex;
        int n = byteArrIndex = index >> 3;
        this.byteArray[n] = (byte)(this.byteArray[n] | (byte)(1 << (index & 7)));
    }

    public int write(ByteBuffer output) throws IOException {
        int numBytes = 0;
        byte[] byArray = this.byteArray;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte bitSet = byArray[i];
            output.put(bitSet);
            ++numBytes;
        }
        return numBytes;
    }

    public boolean get(int index) throws IOException {
        int byteArrIndex = index >> 3;
        return (this.byteArray[byteArrIndex] & 1 << (index & 7)) != 0;
    }

    public int getCurrBytesRead() {
        return this.byteArray.length;
    }
}

