/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.OracleType;
import oracle.rsi.internal.MetadataImpl;
import oracle.sql.CharacterSet;
import oracle.sql.ZONEIDMAP;

interface Metadata {
    public static final int DB_TYPE_VARCHAR2 = 1;
    public static final int DB_TYPE_NUMBER = 2;
    public static final int DB_TYPE_VNUM = 6;
    public static final int DB_TYPE_LONG = 8;
    public static final int DB_TYPE_DATE = 12;
    public static final int DB_TYPE_FLOAT = 21;
    public static final int DB_TYPE_RAW = 23;
    public static final int DB_TYPE_LONG_RAW = 24;
    public static final int DB_TYPE_ROWID = 69;
    public static final int DB_TYPE_CHAR = 96;
    public static final int DB_TYPE_BINARY_FLOAT = 100;
    public static final int DB_TYPE_BINARY_DOUBLE = 101;
    public static final int DB_TYPE_CLOB = 112;
    public static final int DB_TYPE_BLOB = 113;
    public static final int DB_TYPE_JSON = 119;
    public static final int DB_TYPE_TIMESTAMP = 180;
    public static final int DB_TYPE_TIMESTAMPTZ = 181;
    public static final int DB_TYPE_INTERVALYM = 182;
    public static final int DB_TYPE_INTERVALDS = 183;
    public static final int DB_TYPE_UROWID = 208;
    public static final int DB_TYPE_TIMESTAMPLTZ = 231;
    public static final int DB_CHARSET_FORM_NCHAR = 2;
    public static final int DB_TYPE_OPAQUE = 58;
    public static final int DB_TYPE_IREF = 111;
    public static final int DB_TYPE_ADT = 121;
    public static final int DB_TYPE_NESTEDTAB = 122;
    public static final int DB_TYPE_VARRAY = 123;
    public static final Map<Integer, Integer> dbTypeToOracleTypeMap = new HashMap<Integer, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(1, 12);
            this.put(2, 2);
            this.put(8, -1);
            this.put(12, 91);
            this.put(23, -2);
            this.put(24, OracleType.LONG_RAW.getVendorTypeNumber());
            this.put(96, 1);
            this.put(100, 100);
            this.put(101, 101);
            this.put(180, 93);
            this.put(181, -101);
            this.put(182, -103);
            this.put(183, -104);
            this.put(231, -102);
            this.put(112, 2005);
            this.put(113, 2004);
            this.put(69, -8);
            this.put(208, -8);
            this.put(6, 2);
            this.put(21, 6);
            this.put(119, 2016);
        }
    };

    public static Metadata getMetadata(String string, String string2, Connection connection) throws DBMetadataException {
        return new MetadataImpl(connection, string2, string);
    }

    public Table getTable();

    public NLSContext getNLSContext();

    public static interface TemplateSubPartition
    extends TablePartitionInfo {
        public int getBaseObjnum();

        public int getSpartPos();

        public String getSpartName();

        public int getFlags();

        public int getHiboundLen();

        public String getHiboundVal();

        @Override
        public byte[] getbHiboundVal();

        @Override
        public int getPartitionNum();

        @Override
        public boolean isDEFAULT();

        @Override
        public boolean isPartitionStaticallyDefined();

        public Collection<LobTemplateSubpartition> getTemplateLobs();
    }

    public static interface TableSubPartition
    extends TablePartitionInfo {
        public boolean isParentSubpartsItem();

        public boolean isParentLobs();

        public int getObjNum();

        public Schema getSchema();

        public int getBlockSize();

        public Storage getStorage();

        public DeferredStorage getDeferredStorage();

        public int getSubpartNum();

        @Override
        public int getPartitionNum();

        public String getName();

        public int getHiboundLen();

        public String getHiboundVal();

        public String[] getHiboundVals();

        @Override
        public byte[] getbHiboundVal();

        public int getFlags();

        public int getPctfree();

        public Collection<Lob> getLobs();

        @Override
        public boolean isDEFAULT();

        @Override
        public boolean isPartitionStaticallyDefined();
    }

    public static interface TablePartitionInfo {
        public int getPartitionNum();

        public byte[] getbHiboundVal();

        public boolean isDEFAULT();

        public boolean isPartitionStaticallyDefined();
    }

    public static interface TablePartition
    extends TablePartitionInfo {
        public boolean isParentPartListItem();

        public boolean isParentLobs();

        public int getObjNum();

        public Schema getSchema();

        public int getBlockSize();

        public Storage getStorage();

        public DeferredStorage getDeferredStorage();

        @Override
        public int getPartitionNum();

        public String getName();

        public int getHiboundLen();

        public String getHiboundVal();

        public int getFlags();

        public Collection<Lob> getLobs();

        @Override
        public boolean isPartitionStaticallyDefined();

        public String[] getHiboundVals();

        @Override
        public byte[] getbHiboundVal();

        public int getPctfree();

        @Override
        public boolean isDEFAULT();
    }

    public static interface TableCompositePartition
    extends TablePartitionInfo {
        public boolean isParentCompartListItem();

        public boolean isParentSubparts();

        public boolean isParentLobs();

        public int getObjNum();

        public Schema getSchema();

        @Override
        public int getPartitionNum();

        public String getName();

        public int getHiboundLen();

        public String getHiboundVal();

        @Override
        public byte[] getbHiboundVal();

        public int getSubpartCount();

        public int getSmatchTPL();

        public Collection<TableSubPartition> getSubpartitionsObj();

        public Collection<LobPartition> getLobPartitions();

        public int getLmatchTPL();

        public int getFlags();

        public int getDefpctfree();

        public long getSpare2();

        public boolean isDirpathCompressionEnabled();

        public Collection<TablePartitionInfo> getSubpartitions();

        public String getSubPartitionName(int var1);

        @Override
        public boolean isPartitionStaticallyDefined();
    }

    public static interface Table {
        public boolean isPartitioned();

        public PartitionType getPartitionType();

        public boolean isCompositePartition();

        public boolean isIntervalPartition();

        public PartitionType getSubpartitionType();

        public List<ColumnMetadata> getPartitionKeyColumnsMetadata();

        public int getPartitionCount();

        public List<ColumnMetadata> getSubpartitionColumns();

        public Collection<TablePartitionInfo> getPartitions();

        public String getPartitionName(int var1);

        public String getSubPartitionName(int var1, int var2);

        public Collection<TablePartitionInfo> getCompositePartitions();

        public Collection<TablePartitionInfo> getTemplateSubPartitions();

        public int getColumnCount();

        public String getName();

        public String getSchemaQualifiedName();

        public Collection<ColumnMetadata> getColumns();

        public ColumnMetadata getColumn(int var1);

        public ColumnMetadata getColumn(String var1);

        public Partition getPartitionObj();

        public Vector<Constraint> getConstraints();

        public boolean hasConstraints();

        public boolean hasPrimaryConstraint();

        public Constraint getPrimaryConstraint();

        public Collection<ColumnMetadata> getPrimaryConstraintColumnsMetadata();

        public String[] getPrimaryConstraintColumns();

        public Collection<Constraint> getUniqueConstraints();

        public Collection<ColumnMetadata> getConstraintColumns(Constraint var1);

        public byte[] getIntervalBinaryValue();

        public int getIntervalDataType();

        public int getDefSubpartitionCount();
    }

    public static interface StreamColumn {
        public String getName();

        public int getColNum();
    }

    public static interface Storage {
        public long getFlags();

        public CompressionType getCompressionType();
    }

    public static interface SimpleColumn {
        public int getColumnNum();

        public int getProperty();

        public String getName();

        public int getTypeNum();
    }

    public static interface Schema {
        public Timestamp createTimestamp(String var1);

        public boolean isTable();

        public boolean isTablePartition();

        public boolean isTableSubPartition();

        public boolean isLOB();

        public boolean isLOBPartition();

        public boolean isLOBSubPartition();

        public int getObjNum();

        public int getOwnerNum();

        public String getOwnerName();

        public String getName();

        public int getTypeNum();

        public SchemaType getType();

        public String getTypeName();

        public Timestamp getCreationTime();

        public Timestamp getDDLModificationTime();

        public Timestamp getSpecTime();

        public String getSubName();
    }

    public static interface PartitionColumn {
        public SimpleColumn getColumn();

        public int getPositionNum();
    }

    public static interface Partition {
        public BasePartition getBasePartition();

        public Collection<PartitionColumn> getPartitionColumns();

        public Collection<PartitionColumn> getSubpartitionColumns();

        public Collection<TablePartition> getPartitions();

        public Collection<TableCompositePartition> getCompositePartitions();

        public Collection<TemplateSubPartition> getTemplateSubPartitions();

        public PartitionType getPartitionType();

        public PartitionType getSubpartitionType();

        public int getPartType();

        public boolean isCompositePartition();

        public boolean isIntervalPartition();

        public int getSubpartType();

        public int getDefSubpartitionCount();
    }

    public static interface LobTemplateSubpartition {
        public int getBaseObjnum();

        public String getColName();

        public int getIntColNum();

        public int getSubpartPos();

        public int getFlags();

        public String getLobSpartName();

        public String getTablespaceName();

        public int getTablespaceNum();
    }

    public static interface LobPartition {
        public boolean hasPartNum();

        public int getPartNum();

        public Schema getSchema();

        public String getDefaultTablespaceName();

        public int getDefaultBlocksize();

        public int getDefaultChunk();

        public int getDefaultPctVersion();

        public int getDefaultFlags();

        public int getDefaultPartitionProperty();

        public int getDefaultIntialExtentSize();

        public int getDefaultNextExtentSize();

        public int getDefaultMinExtents();

        public int getDefaultMaxExtents();

        public int getDefaultPctIncrease();

        public int getDefaultFreelists();

        public int getDefaultFreelistGroups();

        public int getDefaultBufferPool();

        public int getSpare1();

        public int getSpare2();

        public int getSpare3();

        public int getDefaultMaxSize();

        public int getDefaultRetention();

        public int getDefaultMinRetentionTime();
    }

    public static interface Lob {
        public int getPartNum();

        public int getColNum();

        public Schema getSchema();

        public Storage getStorage();

        public DeferredStorage getDeferredStorage();

        public String getTablespaceName();

        public int getBlocksize();

        public int getChunk();

        public int getPctVersion();

        public int getFlags();

        public int getProperty();

        public int getRetentionTime();

        public int getFreepools();

        public int getSpare1();

        public int getSpare2();

        public String getSpare3();

        public int getSpare3Num();

        public boolean isPartitioned();
    }

    public static interface DeferredStorage {
        public int getPctfree();

        public int getFlags();

        public int getCmpFlag();

        public int getCmpLvl();

        public CompressionType getCompressionType();
    }

    public static interface ConstraintColumn {
        public int getConstraintNum();

        public int getPositionNum();

        public int getOidOrSetid();

        public SimpleColumn getColumn();
    }

    public static interface Constraint {
        public boolean isPrimary();

        public boolean isUnique();

        public ConstraintType getType();

        public Vector<ConstraintColumn> getColumns();
    }

    public static interface BasePartition {
        public boolean isIntervalPartition();

        public boolean isCompositePartition();

        public boolean isDirpathCompressionEnabled();

        public PartitionType getPartitionType();

        public PartitionType getSubpartitionType();

        public int getPartType();

        public int getPartitionCount();

        public int getPartitionKeyColumnsNum();

        public int getFlags();

        public long getSpare2();

        public int getSubpartType();

        public int getDefSubpartitionCount();

        public int getSpare3();

        public String getIntervalString();

        public byte[] getIntervalBinaryValue();
    }

    public static interface ColumnMetadata {
        public int getColumnNum();

        public String getName();

        public int getTypeNum();

        public SQLType getSQLType();

        public int getLength();

        public int getPrecisionNum();

        public int getScale();

        public boolean isNotNull();

        public int getCharsetId();

        public int getCharsetForm();

        public int getCharLength();

        public int getPrecision();

        public boolean isLoadTarget();

        public boolean isVirtualColumn();

        public boolean isCharType();

        public boolean isFloatType();

        public boolean isNumberType();

        public boolean isCharacterType();

        public boolean isBinaryType();

        public boolean isDateTimeType();

        public boolean isIntervalType();

        public boolean isNChar();

        public boolean isLobType();

        public boolean isLob();

        public boolean isBlob();

        public boolean isClob();

        public boolean isNClob();

        public boolean hasPrecision();

        public boolean hasScale();

        public boolean isColumnLengthInChars();

        public int getSpare3();

        public int getSegmentColumnNum();

        public void setLoadTarget(boolean var1);

        public String createDDL(boolean var1);

        public void setInputFormat(String var1);

        public String getInputFormat();
    }

    public static final class NLSContext {
        public static final int CHAR_FORM_OF_USE = 1;
        public static final int NCHAR_FORM_OF_USE = 2;
        public static final String LOCAL_TIMEZONE = "LOCAL";
        private static final Date TWO_DIGIT_YEAR_START = new Date("Sat, 01 Jan 2000 00:00:00 GMT");
        private static final String DEFAULT_ORA_DATE_FORMAT = "SYYYY-MM-DD HH24:MI:SS";
        private static final String ORA_TIMESTAMP_FORMAT = "SYYYY-MM-DD HH24:MI:SS.FF";
        private static final String ORA_TIMESTAMP_TZR_FORMAT = "SYYYY-MM-DD HH24:MI:SS.FF TZR";
        private static final String ORA_TIMESTAMP_TZH_FORMAT = "SYYYY-MM-DD HH24:MI:SS.FF TZH:TZM";
        private Map<String, String> dbProperties;
        private final GregorianCalendar dbCalendar;
        private static GregorianCalendar sessionCalendar;
        private static Map<String, DateFormat> javaDateFormats;
        private final byte[] padBytes;
        private final byte[] nPadBytes;
        private static final Object tzLock;

        public NLSContext(Map<String, String> map) {
            int n;
            this.dbProperties = map;
            CharacterSet characterSet = null;
            CharacterSet characterSet2 = null;
            String string = this.getDatabaseProperty(DBProperty.NLS_CHARACTERSET_ID);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    characterSet = NLSContext.getCharacterSet(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string = this.getDatabaseProperty(DBProperty.NLS_NCHAR_CHARACTERSET_ID)) != null) {
                try {
                    n = Integer.parseInt(string);
                    characterSet2 = NLSContext.getCharacterSet(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            String string2 = this.getDatabaseProperty(DBProperty.DBTIMEZONE);
            this.dbCalendar = new GregorianCalendar(NLSContext.getTimeZone(string2));
            this.dbCalendar.setLenient(false);
            this.padBytes = this.getPadBytes(DBProperty.CHAR_PAD, characterSet);
            this.nPadBytes = this.getPadBytes(DBProperty.NCHAR_PAD, characterSet2);
        }

        public static CharacterSet getCharacterSet(int n) {
            CharacterSet characterSet = CharacterSet.make((int)n);
            if (characterSet.getOracleId() != n) {
                characterSet = null;
            }
            return characterSet;
        }

        public GregorianCalendar getDatabaseCalendar() {
            return (GregorianCalendar)this.dbCalendar.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static GregorianCalendar getSessionCalendar() {
            Object object = tzLock;
            synchronized (object) {
                return (GregorianCalendar)sessionCalendar.clone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSessionTimezone(TimeZone timeZone) {
            Object object = tzLock;
            synchronized (object) {
                sessionCalendar = new GregorianCalendar(timeZone);
                sessionCalendar.setLenient(false);
            }
        }

        public String getDatabaseDateTimeFormatPattern() {
            return DEFAULT_ORA_DATE_FORMAT;
        }

        public static String getDatabaseTimestampFormat() {
            return ORA_TIMESTAMP_FORMAT;
        }

        public static String getDatabaseTimestampTZFormat() {
            if (ZONEIDMAP.isValidRegion((String)sessionCalendar.getTimeZone().getID())) {
                return ORA_TIMESTAMP_TZR_FORMAT;
            }
            return ORA_TIMESTAMP_TZH_FORMAT;
        }

        public String getDatabaseProperty(DBProperty dBProperty) {
            return this.dbProperties.get(dBProperty.toString());
        }

        public static DateFormat getJavaDateFormat(String string2) {
            return (DateFormat)javaDateFormats.computeIfAbsent(string2, string -> NLSContext.create(string)).clone();
        }

        private static DateFormat create(String string) {
            String string2 = string == null ? "" : string;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.setLenient(false);
            simpleDateFormat.set2DigitYearStart(TWO_DIGIT_YEAR_START);
            return simpleDateFormat;
        }

        public static TimeZone getTimeZone(String string) throws IllegalArgumentException {
            TimeZone timeZone;
            String string2;
            String string3 = string2 = string != null ? string.trim() : "";
            if (string2.equalsIgnoreCase(LOCAL_TIMEZONE)) {
                return TimeZone.getDefault();
            }
            Object object = "";
            if (string2.length() > 0) {
                char c = string2.charAt(0);
                object = c == '+' || c == '-' ? "GMT" + string2 : ("00:00".compareTo(string) == 0 || "0:00".compareTo(string) == 0 ? "GMT+00:00" : string2);
            }
            if (0 != (timeZone = TimeZone.getTimeZone((String)object)).getID().compareTo((String)object)) {
                throw new IllegalArgumentException("Invalid timezone");
            }
            return timeZone;
        }

        public byte[] getPadBytes() {
            return this.padBytes;
        }

        public byte[] getNpadBytes() {
            return this.nPadBytes;
        }

        public byte[] padToLength(byte[] byArray, int n, int n2, int n3, int n4) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byte[] byArray3 = n4 == 1 ? this.getPadBytes() : this.getNpadBytes();
            int n5 = n2 - byArray.length;
            int n6 = n5 / byArray3.length;
            n6 = Math.min(n6, n3 - n);
            int n7 = byArray.length;
            for (int i = 0; i < n6 && n7 < byArray2.length; n7 += byArray3.length, ++i) {
                System.arraycopy(byArray3, 0, byArray2, n7, byArray3.length);
            }
            return byArray2;
        }

        public byte[] unpad(byte[] byArray, int n) {
            int n2 = this.getNumBytesOfPadding(byArray, n);
            int n3 = byArray.length - n2;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }

        public int getNumBytesOfPadding(byte[] byArray, int n) {
            int n2;
            byte[] byArray2 = n == 1 ? this.getPadBytes() : this.getNpadBytes();
            int n3 = 0;
            int n4 = byArray2.length;
            for (n2 = byArray.length - 1; n2 >= 0; --n2) {
                if (byArray[n2] != byArray2[--n4]) {
                    n3 = n2 + byArray2.length - n4;
                    break;
                }
                if (n4 != 0) continue;
                n4 = byArray2.length;
            }
            n2 = byArray.length - n3;
            return n2;
        }

        private byte[] getPadBytes(DBProperty dBProperty, CharacterSet characterSet) {
            byte[] byArray;
            String string = this.getDatabaseProperty(dBProperty);
            if (string == null) {
                try {
                    byArray = characterSet.convert(" ");
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(dBProperty + " convert failure", sQLException);
                }
            } else {
                String[] stringArray = string.split(",", -1);
                byArray = new byte[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    byArray[i] = Byte.parseByte(stringArray[i]);
                }
            }
            return byArray;
        }

        static {
            javaDateFormats = new ConcurrentHashMap<String, DateFormat>();
            sessionCalendar = new GregorianCalendar();
            sessionCalendar.setLenient(false);
            tzLock = new Object();
        }
    }

    public static class DBMetadataException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final CODE code;

        public DBMetadataException(CODE cODE, String string, Throwable throwable) {
            super(string);
            this.code = cODE;
            this.initCause(throwable);
        }

        public DBMetadataException(CODE cODE, String string) {
            super(string);
            this.code = cODE;
        }

        public DBMetadataException() {
            this.code = CODE.INTERNAL;
        }

        public CODE getCode() {
            return this.code;
        }

        public static enum CODE {
            TABLE_CONFIG,
            IO_ERROR,
            GENERIC,
            INTERNAL,
            PART_KEY_NOT_FOUND,
            PART_MAX_PARTITION_EXCEEDED,
            PART_TOTAL_SUBPART_EXCEEDS_MAX,
            PART_ERROR,
            JDBC_ERROR,
            PARSE_ERROR,
            PARSE_ERROR_CONSTRAINT,
            PARSE_ERROR_UNSUPPORTED_TYPE,
            INVALID_PARTITION_FILE;

        }
    }

    public static enum CompressionType {
        NONE,
        BASIC,
        OLTP,
        QUERY_LOW,
        QUERY_HIGH,
        ARCHIVE_LOW,
        ARCHIVE_HIGH;

    }

    public static enum SchemaType {
        TABLE(2),
        TABLE_PARTITION(19),
        TABLE_SUBPARTITION(34),
        LOB(21),
        LOB_PARTITION(40),
        LOB_SUBPARTITION(41),
        UNSUPPORTED(0);

        private static final HashMap<Integer, SchemaType> lookup;
        private int m_typecode;

        private SchemaType(int n2) {
            this.m_typecode = n2;
        }

        public int getType() {
            return this.m_typecode;
        }

        public static SchemaType getName(int n) {
            try {
                if (lookup.containsKey(n)) {
                    return lookup.get(n);
                }
                return UNSUPPORTED;
            }
            catch (Throwable throwable) {
                return UNSUPPORTED;
            }
        }

        static {
            lookup = new HashMap();
            for (SchemaType schemaType : EnumSet.allOf(SchemaType.class)) {
                lookup.put(schemaType.getType(), schemaType);
            }
        }
    }

    public static enum PartitionType {
        RANGE(1),
        HASH(2),
        LIST(4),
        UNSUPPORTED(0);

        private static final HashMap<Integer, PartitionType> lookup;
        private int part_type;

        private PartitionType(int n2) {
            this.part_type = n2;
        }

        public int getType() {
            return this.part_type;
        }

        public static PartitionType getName(int n) {
            try {
                if (lookup.containsKey(n)) {
                    return lookup.get(n);
                }
                return UNSUPPORTED;
            }
            catch (Throwable throwable) {
                return UNSUPPORTED;
            }
        }

        static {
            lookup = new HashMap();
            for (PartitionType partitionType : EnumSet.allOf(PartitionType.class)) {
                lookup.put(partitionType.getType(), partitionType);
            }
        }
    }

    public static enum DBProperty {
        DBTIMEZONE,
        NLS_CALENDAR,
        NLS_CHARACTERSET,
        NLS_CHARACTERSET_ID,
        NLS_COMP,
        NLS_CURRENCY,
        NLS_DATE_FORMAT,
        NLS_DATE_LANGUAGE,
        NLS_DUAL_CURRENCY,
        NLS_ISO_CURRENCY,
        NLS_LANGUAGE,
        NLS_LENGTH_SEMANTICS,
        NLS_NCHAR_CHARACTERSET,
        NLS_NCHAR_CHARACTERSET_ID,
        NLS_NCHAR_CONV_EXCP,
        NLS_NUMERIC_CHARACTERS,
        NLS_RDBMS_VERSION,
        NLS_SORT,
        NLS_TERRITORY,
        NLS_TIMESTAMP_FORMAT,
        NLS_TIMESTAMP_TZ_FORMAT,
        NLS_TIME_FORMAT,
        NLS_TIME_TZ_FORMAT,
        CHAR_PAD,
        NCHAR_PAD,
        PORT_STRING;

    }

    public static enum ConstraintType {
        PRIMARY(2),
        UNIQUE(3),
        NOTNULL(7),
        UNSUPPORTED(0);

        private static final HashMap<Integer, ConstraintType> lookup;
        private final int m_typecode;

        private ConstraintType(int n2) {
            this.m_typecode = n2;
        }

        public int getTypecode() {
            return this.m_typecode;
        }

        public static ConstraintType getName(int n) {
            try {
                if (lookup.containsKey(n)) {
                    return lookup.get(n);
                }
                return UNSUPPORTED;
            }
            catch (Throwable throwable) {
                return UNSUPPORTED;
            }
        }

        static {
            lookup = new HashMap();
            for (ConstraintType constraintType : EnumSet.allOf(ConstraintType.class)) {
                lookup.put(constraintType.getTypecode(), constraintType);
            }
        }
    }

    public static enum ObjectColumnType {
        ADT(121),
        NESTEDTAB(122),
        VARRAY(123),
        IREF(111),
        OPAQUE(58);

        private static final HashMap<Integer, ObjectColumnType> lookup;
        private int type_num;

        private ObjectColumnType(int n2) {
            this.type_num = n2;
        }

        public int getTypeNum() {
            return this.type_num;
        }

        public static boolean isObjCol(int n) {
            try {
                return lookup.containsKey(n);
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        static {
            lookup = new HashMap();
            for (ObjectColumnType objectColumnType : EnumSet.allOf(ObjectColumnType.class)) {
                lookup.put(objectColumnType.getTypeNum(), objectColumnType);
            }
        }
    }
}

