/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffprobe.Chapter;
import com.github.kokorin.jaffree.ffprobe.Format;
import com.github.kokorin.jaffree.ffprobe.Frame;
import com.github.kokorin.jaffree.ffprobe.FrameSubtitle;
import com.github.kokorin.jaffree.ffprobe.Packet;
import com.github.kokorin.jaffree.ffprobe.PacketFrameSubtitle;
import com.github.kokorin.jaffree.ffprobe.Program;
import com.github.kokorin.jaffree.ffprobe.Stream;
import com.github.kokorin.jaffree.ffprobe.Subtitle;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFprobeResult {
    private final ProbeData probeData;
    private static final Logger LOGGER = LoggerFactory.getLogger(FFprobeResult.class);

    public FFprobeResult(ProbeData probeData) {
        this.probeData = probeData;
    }

    public ProbeData getData() {
        return this.probeData;
    }

    public Format getFormat() {
        return this.probeData.getSubData("format", Format::new);
    }

    public List<Packet> getPackets() {
        return this.probeData.getSubDataList("packets", Packet::new);
    }

    public List<FrameSubtitle> getFrames() {
        return this.probeData.getSubDataList("frames", subData -> {
            StreamType streamType = subData.getStreamType("media_type");
            if (streamType == StreamType.SUBTITLE) {
                return new Subtitle(subData);
            }
            return new Frame(subData);
        });
    }

    public List<PacketFrameSubtitle> getPacketsAndFrames() {
        return this.probeData.getSubDataList("packets_and_frames", subData -> {
            String type = subData.getString("type");
            if (type == null) {
                LOGGER.error("No type property found");
                return null;
            }
            switch (type) {
                case "packet": {
                    return new Packet(subData);
                }
                case "frame": {
                    return new Frame(subData);
                }
                case "subtitle": {
                    return new Subtitle(subData);
                }
            }
            LOGGER.error("Unknown type: " + type);
            return null;
        });
    }

    public List<Program> getPrograms() {
        return this.probeData.getSubDataList("programs", Program::new);
    }

    public List<Stream> getStreams() {
        return this.probeData.getSubDataList("streams", Stream::new);
    }

    public List<Chapter> getChapters() {
        return this.probeData.getSubDataList("chapters", Chapter::new);
    }
}

