/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.jsampler.CC;
import org.jsampler.JSI18n;
import org.linuxsampler.lscp.LSException;
import org.linuxsampler.lscp.LscpException;

public class HF {
    public static String getErrorMessage(Exception exception) {
        String string = exception.getMessage();
        if (exception instanceof LSException) {
            LSException lSException = (LSException)exception;
        } else if (!(exception instanceof LscpException)) {
            string = string != null ? string : JSI18n.i18n.getError("unknownError");
        }
        return string;
    }

    public static void showErrorMessage(String string) {
        HF.showErrorMessage(string, (Component)CC.getMainFrame());
    }

    public static void showErrorMessage(String string, Component component) {
        JOptionPane.showMessageDialog(component, string, JSI18n.i18n.getError("error"), 0);
    }

    public static void showErrorMessage(Exception exception) {
        HF.showErrorMessage(exception, CC.getMainFrame());
    }

    public static void showErrorMessage(Exception exception, String string) {
        HF.showErrorMessage(exception, CC.getMainFrame(), string);
    }

    public static void showErrorMessage(Exception exception, Frame frame) {
        HF.showErrorMessage(exception, frame, "");
    }

    public static void showErrorMessage(Exception exception, Frame frame, String string) {
        String string2 = string + HF.getErrorMessage(exception);
        CC.getLogger().log(Level.INFO, string2, exception);
        JOptionPane.showMessageDialog(frame, string2, JSI18n.i18n.getError("error"), 0);
    }

    public static void showErrorMessage(Exception exception, Dialog dialog) {
        String string = HF.getErrorMessage(exception);
        CC.getLogger().log(Level.INFO, string, exception);
        JOptionPane.showMessageDialog(dialog, string, JSI18n.i18n.getError("error"), 0);
    }

    public static boolean showYesNoDialog(Component component, String string) {
        return HF.showYesNoDialog(component, string, "");
    }

    public static boolean showYesNoDialog(Component component, String string, String string2) {
        Object[] objectArray = new Object[]{JSI18n.i18n.getButtonLabel("yes"), JSI18n.i18n.getButtonLabel("no")};
        int n = JOptionPane.showOptionDialog(component, string, string2, 0, 3, null, objectArray, objectArray[0]);
        return n == 0;
    }

    public static void setUIDefaultFont(String string) {
        if (string == null) {
            return;
        }
        Enumeration enumeration = UIManager.getDefaults().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = UIManager.get(k);
            if (!(object instanceof FontUIResource)) continue;
            FontUIResource fontUIResource = (FontUIResource)object;
            FontUIResource fontUIResource2 = new FontUIResource(string, fontUIResource.getStyle(), fontUIResource.getSize());
            UIManager.put(k, fontUIResource2);
        }
    }

    public static void deleteFile(String string) {
        String string2 = CC.getJSamplerHome();
        if (string2 == null) {
            return;
        }
        try {
            File file = new File(string2 + File.separator + string);
            if (file.isFile()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }

    public static boolean createBackup(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return false;
        }
        String string3 = CC.getJSamplerHome();
        if (string3 == null) {
            return false;
        }
        File file = new File(string3 + File.separator + string);
        if (!file.isFile()) {
            return false;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string3 + File.separator + string);
            FileOutputStream fileOutputStream = new FileOutputStream(string3 + File.separator + string2, false);
            int n = fileInputStream.read();
            while (n != -1) {
                fileOutputStream.write(n);
                n = fileInputStream.read();
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            return false;
        }
        return true;
    }

    public static double percentsToDecibels(int n) {
        if (n == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = n;
        d /= 100.0;
        d = 20.0 * Math.log10(d);
        return d;
    }

    public static int decibelsToPercents(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return 0;
        }
        double d2 = Math.pow(10.0, d / 20.0);
        return (int)(d2 *= 100.0);
    }

    public static float decibelsToFactor(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0f;
        }
        double d2 = Math.pow(10.0, d / 20.0);
        return (float)d2;
    }

    public static float percentsToFactor(int n) {
        float f = n;
        return f /= 100.0f;
    }
}

