/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.Viewport;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.NumberValue;

public abstract class AbstractCSSCanvas
implements CSSCanvas {
    protected AbstractCSSCanvas() {
    }

    @Override
    public CSSTypedValue getFeatureValue(String feature) {
        if ("width".equals(feature)) {
            return this.getWidth();
        }
        if ("height".equals(feature)) {
            return this.getHeight();
        }
        if ("aspect-ratio".equals(feature)) {
            float fratio = this.getWidthFloat() / this.getHeightFloat();
            NumberValue number = new NumberValue();
            number.setFloatValue((short)0, fratio);
            return number;
        }
        if ("orientation".equals(feature)) {
            return new IdentifierValue(this.getOrientation());
        }
        if ("resolution".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)60, this.getResolution());
            return number;
        }
        if ("scan".equals(feature)) {
            return new IdentifierValue(this.getScanType());
        }
        if ("grid".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)0, this.isGridDevice() ? 1.0f : 0.0f);
            return number;
        }
        if ("update".equals(feature)) {
            return new IdentifierValue(this.getUpdateFrequency());
        }
        if ("overflow-block".equals(feature)) {
            return new IdentifierValue(this.getOverflowBlock());
        }
        if ("overflow-inline".equals(feature)) {
            return new IdentifierValue(this.getOverflowInline());
        }
        if ("prefers-color-scheme".equals(feature)) {
            return new IdentifierValue(this.getPrefersColorScheme());
        }
        if ("prefers-reduced-motion".equals(feature)) {
            return new IdentifierValue(this.getPrefersReducedMotion());
        }
        if ("color".equals(feature)) {
            NumberValue number = new NumberValue();
            int color = this.getStyleDatabase().getColorDepth();
            number.setFloatValue((short)0, color);
            return number;
        }
        if ("color-index".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)0, this.getColorIndex());
            return number;
        }
        if ("monochrome".equals(feature)) {
            NumberValue number = new NumberValue();
            number.setFloatValue((short)0, this.getMonoBitsPerPixel());
            return number;
        }
        return null;
    }

    @Override
    public boolean matchesFeature(String feature, CSSTypedValue value) {
        if ("orientation".equals(feature)) {
            return this.matches(value, this.getOrientation());
        }
        if ("scan".equals(feature)) {
            return this.matches(value, this.getScanType());
        }
        if ("grid".equals(feature)) {
            return this.isGridDevice() ? value == null || !value.isNumberZero() : value != null && value.isNumberZero();
        }
        if ("update".equals(feature)) {
            return this.matches(value, this.getUpdateFrequency());
        }
        if ("overflow-block".equals(feature)) {
            return this.matches(value, this.getOverflowBlock());
        }
        if ("overflow-inline".equals(feature)) {
            return this.matches(value, this.getOverflowInline());
        }
        if ("prefers-color-scheme".equals(feature)) {
            String pcs = this.getPrefersColorScheme();
            if (value != null) {
                return value.getPrimitiveType() == CSSValue.Type.IDENT && pcs.equalsIgnoreCase(value.getStringValue());
            }
        } else {
            if ("prefers-reduced-motion".equals(feature)) {
                String pcs = this.getPrefersReducedMotion();
                if (value != null) {
                    return value.getPrimitiveType() == CSSValue.Type.IDENT && pcs.equalsIgnoreCase(value.getStringValue());
                }
                return !"no-preference".equals(pcs);
            }
            if ("color-gamut".equals(feature)) {
                if (value == null) {
                    return !this.supportsGamut("none");
                }
                if (value.getPrimitiveType() == CSSValue.Type.IDENT) {
                    String sv = value.getStringValue();
                    return this.supportsGamut(sv);
                }
            } else if ("pointer".equals(feature)) {
                return this.matches(value, this.getPointerAccuracy());
            }
        }
        return false;
    }

    private boolean matches(CSSTypedValue valueToMatch, String featureValue) {
        if (valueToMatch == null) {
            return !"none".equals(featureValue);
        }
        return AbstractCSSCanvas.isCSSIdentifier(valueToMatch, featureValue);
    }

    private static boolean isCSSIdentifier(CSSTypedValue value, String ident) {
        return value.getPrimitiveType() == CSSValue.Type.IDENT && ident.equalsIgnoreCase(value.getStringValue());
    }

    private NumberValue getWidth() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceWidth() : (float)viewport.getViewportWidth();
        NumberValue num = new NumberValue();
        num.setFloatValue(sdb.getNaturalUnit(), fval);
        return num;
    }

    private NumberValue getHeight() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceHeight() : (float)viewport.getViewportHeight();
        NumberValue num = new NumberValue();
        num.setFloatValue(sdb.getNaturalUnit(), fval);
        return num;
    }

    private float getWidthFloat() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceWidth() : (float)viewport.getViewportWidth();
        return fval;
    }

    private float getHeightFloat() {
        StyleDatabase sdb = this.getStyleDatabase();
        Viewport viewport = this.getViewport();
        float fval = viewport == null ? sdb.getDeviceHeight() : (float)viewport.getViewportHeight();
        return fval;
    }

    protected float getColorIndex() {
        return 1.6777216E7f;
    }

    protected boolean isGridDevice() {
        return false;
    }

    protected int getMonoBitsPerPixel() {
        return 0;
    }

    protected String getOrientation() {
        float height;
        float width = this.getWidth().getFloatValue((short)3);
        if (width >= (height = this.getHeight().getFloatValue((short)3))) {
            return "landscape";
        }
        return "portrait";
    }

    protected abstract String getOverflowBlock();

    protected abstract String getOverflowInline();

    protected String getPointerAccuracy() {
        return "none";
    }

    protected String getPrefersColorScheme() {
        return "light";
    }

    protected String getPrefersReducedMotion() {
        return "no-preference";
    }

    protected float getResolution() {
        return 96.0f;
    }

    protected String getScanType() {
        return "progressive";
    }

    protected String getUpdateFrequency() {
        return "none";
    }

    protected boolean supportsGamut(String gamut) {
        return "srgb".equalsIgnoreCase(gamut);
    }
}

