/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.ThemeColor;
import org.jkiss.dbeaver.ui.ThemeFont;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;

public class ThemeListener {
    private static final Log log = Log.getLog(ThemeListener.class);
    private final Map<String, Field[]> fieldMap = new HashMap<String, Field[]>();
    private final IThemeManager themeManager;
    private final Map<String, List<Consumer<String>>> propertyListeners = new HashMap<String, List<Consumer<String>>>();

    public ThemeListener() {
        this.themeManager = PlatformUI.getWorkbench().getThemeManager();
        IPropertyChangeListener themeChangeListener = this::updateThemeProperty;
        this.themeManager.addPropertyChangeListener(themeChangeListener);
        Field[] fieldArray = this.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            String propId = null;
            ThemeColor colorAnno = field.getAnnotation(ThemeColor.class);
            if (colorAnno != null) {
                if (!Color.class.isAssignableFrom(field.getType())) {
                    log.error((Object)("Bad color annotation " + String.valueOf(field)));
                } else {
                    propId = colorAnno.value();
                }
            } else {
                ThemeFont fontAnno = field.getAnnotation(ThemeFont.class);
                if (fontAnno != null) {
                    if (!Font.class.isAssignableFrom(field.getType())) {
                        log.error((Object)("Bad color annotation " + String.valueOf(field)));
                    } else {
                        propId = fontAnno.value();
                    }
                }
            }
            if (propId != null) {
                Object[] fields = this.fieldMap.get(propId);
                fields = fields == null ? new Field[]{field} : (Field[])ArrayUtils.add(Field.class, (Object[])fields, (Object)field);
                this.fieldMap.put(propId, (Field[])fields);
            }
            ++n2;
        }
        ITheme currentTheme = this.themeManager.getCurrentTheme();
        try {
            for (Map.Entry<String, Field[]> prop : this.fieldMap.entrySet()) {
                Field[] fields = prop.getValue();
                this.setPropertyValue(fields, currentTheme, prop.getKey());
            }
        }
        catch (IllegalAccessException e) {
            log.debug((Object)"Error filling initial theme properties", (Throwable)e);
        }
    }

    private void updateThemeProperty(PropertyChangeEvent event) {
        List<Consumer<String>> listeners;
        String property = event.getProperty();
        Field[] fields = this.fieldMap.get(property);
        if (fields != null) {
            ITheme currentTheme = this.themeManager.getCurrentTheme();
            try {
                this.setPropertyValue(fields, currentTheme, property);
            }
            catch (IllegalAccessException e) {
                log.debug((Object)e);
            }
        }
        if ((listeners = this.propertyListeners.get(property)) != null) {
            for (Consumer<String> listener : listeners) {
                listener.accept(property);
            }
        }
    }

    private void setPropertyValue(Field[] fields, ITheme currentTheme, String property) throws IllegalAccessException {
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Color.class.isAssignableFrom(field.getType())) {
                Color value = currentTheme.getColorRegistry().get(property);
                if (value == null) {
                    log.error((Object)("Color '" + property + "' not found in registry"));
                }
                field.set(this, value);
            } else if (Font.class.isAssignableFrom(field.getType())) {
                ThemeFont param = field.getAnnotation(ThemeFont.class);
                if (param != null && param.italic()) {
                    font = currentTheme.getFontRegistry().getItalic(property);
                    if (font == null) {
                        log.error((Object)("Font '" + property + "' (italic) not found in registry"));
                    }
                    field.set(this, font);
                } else if (param != null && param.bold()) {
                    if (RuntimeUtils.isMacOS()) {
                        Object oldValue = field.get(this);
                        if (oldValue instanceof Font) {
                            Font oldFont = (Font)oldValue;
                            oldFont.dispose();
                        }
                        Font normalFont = currentTheme.getFontRegistry().get(property);
                        font = UIUtils.makeBoldFont(normalFont);
                        Device device = normalFont.getDevice();
                        if (device instanceof Display) {
                            Display display = (Display)device;
                            display.disposeExec(() -> ((Font)font).dispose());
                        }
                    } else {
                        font = currentTheme.getFontRegistry().getBold(property);
                    }
                    field.set(this, font);
                } else {
                    font = currentTheme.getFontRegistry().get(property);
                    if (font == null) {
                        log.error((Object)("Font '" + property + "' not found in registry"));
                    }
                    field.set(this, font);
                }
            }
            ++n2;
        }
    }

    public synchronized void addPropertyListener(@NotNull String property, @NotNull Consumer<String> listener, @Nullable Control control) {
        this.propertyListeners.computeIfAbsent(property, p -> new ArrayList()).add(listener);
        if (control != null) {
            control.addDisposeListener(e -> this.removePropertyListener(property, listener));
        }
    }

    public synchronized void removePropertyListener(String property, Consumer<String> listener) {
        List<Consumer<String>> consumers = this.propertyListeners.get(property);
        if (consumers == null) {
            log.debug((Object)("No property '" + property + "' consumers"));
        } else if (!consumers.remove(listener)) {
            log.debug((Object)("Property '" + property + "' consumer '" + String.valueOf(listener) + "' not found"));
        } else if (consumers.isEmpty()) {
            this.propertyListeners.remove(property);
        }
    }
}

