/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.altibase.AltibaseConstants;
import org.jkiss.dbeaver.ext.altibase.AltibaseUtils;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseConstraint;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataTypeCache;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDbLink;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDirectory;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseJob;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseLibrary;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseMaterializedView;
import org.jkiss.dbeaver.ext.altibase.model.AltibasePackage;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseProcedurePackaged;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseProcedureStandAlone;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseReplication;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSchema;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSequence;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseSynonym;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTable;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTableColumn;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTableIndex;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTableTrigger;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseTypeset;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseView;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericPackage;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.generic.model.GenericTrigger;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.CommonUtils;

public class AltibaseMetaModel
extends GenericMetaModel {
    private static final Log log = Log.getLog(AltibaseMetaModel.class);

    @NotNull
    public GenericDataSource createDataSourceImpl(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new AltibaseDataSource(monitor, container, this);
    }

    public boolean isSystemSchema(GenericSchema schema) {
        return "SYSTEM_".equals(schema.getName());
    }

    public AltibaseSchema createSchemaImpl(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) throws DBException {
        return new AltibaseSchema(dataSource, catalog, schemaName);
    }

    public AltibaseDataTypeCache createDataTypeCache(@NotNull GenericStructContainer container) {
        return new AltibaseDataTypeCache(container);
    }

    /*
     * Exception decompiling
     */
    public GenericTableBase createTableImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @NotNull GenericMetaObject tableObject, @NotNull JDBCResultSet dbResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl73 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl73 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (tableType != null && this.isView(tableType)) {
            if (tableType.equalsIgnoreCase("MATERIALIZED VIEW")) {
                return new AltibaseMaterializedView(null, container, tableName, tableType, dbResult);
            }
            return new AltibaseView(null, container, tableName, tableType, dbResult);
        }
        return new AltibaseTable(container, tableName, tableType, dbResult);
    }

    public String getIndexDDL(DBRProgressMonitor monitor, AltibaseTableIndex sourceObject, Map<String, Object> options) throws DBException {
        StringBuilder ddl = new StringBuilder();
        String schemaName = ((GenericTableBase)sourceObject.getTable()).getSchema().getName();
        String ddlFromMetadata = this.getDDLFromDbmsMetadata(monitor, (DBSObject)sourceObject, schemaName, "INDEX");
        if (CommonUtils.isEmpty((String)ddlFromMetadata)) {
            ddl.append(String.format(AltibaseConstants.NO_DDL_WITHOUT_DBMS_METADATA, "INDEX"));
        } else {
            if (sourceObject.isSystemGenerated()) {
                ddl.append("-- System generated index. Not for user creation.").append(AltibaseConstants.NEW_LINE).append("/*").append(AltibaseConstants.NEW_LINE);
            }
            ddl.append(ddlFromMetadata).append(";");
            if (sourceObject.isSystemGenerated()) {
                ddl.append(AltibaseConstants.NEW_LINE).append("*/");
            }
        }
        return ddl.toString();
    }

    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) throws DBException {
        StringBuilder ddl = new StringBuilder();
        String schemaName = ((GenericStructContainer)sourceObject.getContainer()).getName();
        String ddlFromMetadata = this.getDDLFromDbmsMetadata(monitor, (DBSObject)sourceObject, schemaName, sourceObject.getTableType());
        if (CommonUtils.isEmpty((String)ddlFromMetadata)) {
            ddl.append(AltibaseConstants.NO_DBMS_METADATA).append(super.getTableDDL(monitor, sourceObject, options));
        } else {
            ddl.append(ddlFromMetadata).append(";").append(AltibaseConstants.NEW_LINE);
            this.addTableDependentDdl(ddl, "COMMENT", monitor, (DBSObject)sourceObject, schemaName);
            for (GenericTableIndex index : sourceObject.getIndexes(monitor)) {
                AltibaseTableIndex altiIndex = (AltibaseTableIndex)index;
                if (altiIndex.isSystemGenerated()) continue;
                ddl.append(AltibaseConstants.NEW_LINE).append(altiIndex.getObjectDefinitionText(monitor, options)).append(AltibaseConstants.NEW_LINE);
            }
        }
        return ddl.toString();
    }

    private void addTableDependentDdl(StringBuilder ddl, String depObjType, DBRProgressMonitor monitor, DBSObject sourceObject, String schemaName) {
        String depDdl = null;
        depDdl = this.getDepDDLFromDbmsMetadata(monitor, sourceObject, schemaName, depObjType);
        if ((depDdl = depDdl.replaceAll("\\n\\n", AltibaseConstants.NEW_LINE)) != null && depDdl.length() > 0) {
            ddl.append(AltibaseConstants.NEW_LINE).append(depDdl).append(AltibaseConstants.NEW_LINE);
        }
    }

    public String getSynonymDDL(DBRProgressMonitor monitor, AltibaseSynonym sourceObject, Map<String, Object> options) throws DBException {
        return this.getDDLFromDbmsMetadata(monitor, (DBSObject)sourceObject, (String)options.get("SCHEMA"), "SYNONYM");
    }

    public String getReplicationDDL(@NotNull DBRProgressMonitor monitor, @NotNull AltibaseReplication sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return this.getDDLFromDbmsMetadata(monitor, sourceObject, null, "REPLICATION");
    }

    public String getJobDDL(DBRProgressMonitor monitor, AltibaseJob sourceObject, Map<String, Object> options) throws DBException {
        return this.getDDLFromDbmsMetadata(monitor, sourceObject, null, "JOB");
    }

    public String getDbLinkDDL(DBRProgressMonitor monitor, AltibaseDbLink sourceObject, Map<String, Object> options) throws DBException {
        return this.getDDLFromDbmsMetadata(monitor, sourceObject, (String)options.get("SCHEMA"), "DB_LINK");
    }

    public String getLibraryDDL(DBRProgressMonitor monitor, AltibaseLibrary sourceObject, Map<String, Object> options) throws DBException {
        return this.getDDLFromDbmsMetadata(monitor, sourceObject, null, "LIBRARY");
    }

    public String getDirectoryDDL(DBRProgressMonitor monitor, AltibaseDirectory sourceObject, Map<String, Object> options) throws DBException {
        return this.getDDLFromDbmsMetadata(monitor, sourceObject, null, "DIRECTORY");
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        String ddl = this.getDDLFromDbmsMetadata(monitor, (DBSObject)sourceObject, sourceObject.getSchema().getName(), AltibaseUtils.getDmbsMetaDataObjTypeName(sourceObject.getTableType()));
        if (CommonUtils.isEmpty((String)ddl)) {
            String sql = sourceObject instanceof AltibaseMaterializedView ? "SELECT parse FROM SYSTEM_.SYS_VIEW_PARSE_ VP ,SYSTEM_.SYS_USERS_ U ,SYSTEM_.SYS_MATERIALIZED_VIEWS_ MV WHERE U.USER_NAME = ? AND MV.MVIEW_NAME = ? AND VP.USER_ID = U.USER_ID AND VP.VIEW_ID = MV.VIEW_ID ORDER BY SEQ_NO ASC" : "SELECT  parse  FROM  SYSTEM_.SYS_VIEW_PARSE_ VP, SYSTEM_.SYS_USERS_ U, SYSTEM_.SYS_TABLES_ T WHERE U.USER_NAME = ? AND T.TABLE_NAME = ? AND T.TABLE_TYPE = 'V' AND VP.USER_ID = U.USER_ID AND VP.VIEW_ID = T.TABLE_ID ORDER BY SEQ_NO ASC";
            ddl = this.getViewProcDDLFromCatalog(monitor, (DBSObject)sourceObject, sourceObject.getSchema().getName(), sql);
        }
        return ddl.length() < 1 ? "-- View definition not available" : ddl;
    }

    public String getProcedureDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericProcedure sourceObject) throws DBException {
        String ddl = this.getDDLFromDbmsMetadata(monitor, (DBSObject)sourceObject, sourceObject.getSchema().getName(), ((AltibaseProcedureStandAlone)sourceObject).getProcedureTypeName());
        if (CommonUtils.isEmpty((String)ddl)) {
            String sql = "SELECT  parse  FROM  SYSTEM_.SYS_PROC_PARSE_ PP, SYSTEM_.SYS_USERS_ U, SYSTEM_.SYS_PROCEDURES_ P WHERE U.USER_NAME = ? AND P.PROC_NAME = ? AND PP.USER_ID = U.USER_ID AND PP.PROC_OID = P.PROC_OID ORDER BY SEQ_NO ASC";
            ddl = this.getViewProcDDLFromCatalog(monitor, (DBSObject)sourceObject, sourceObject.getSchema().getName(), sql);
        }
        return ddl;
    }

    public String getPackageDDL(DBRProgressMonitor monitor, AltibasePackage sourceObject, int packageType) throws DBException {
        String ddl = this.getDDLFromDbmsMetadata(monitor, (DBSObject)sourceObject, sourceObject.getSchema().getName(), packageType == 6 ? "PACKAGE_SPEC" : "PACKAGE_BODY");
        boolean hasDbmsMetadata = ddl.startsWith("--");
        if (hasDbmsMetadata || CommonUtils.isEmpty((String)ddl)) {
            String sql = "SELECT  parse  FROM  SYSTEM_.SYS_PACKAGE_PARSE_ PP, SYSTEM_.SYS_USERS_ U, SYSTEM_.SYS_PACKAGES_ P WHERE U.USER_NAME = ? AND P.PACKAGE_NAME = ? AND PP.USER_ID = U.USER_ID AND PP.PACKAGE_OID = P.PACKAGE_OID AND PP.PACKAGE_TYPE = P.PACKAGE_TYPE AND PP.PACKAGE_TYPE = " + packageType + " ORDER BY PP.PACKAGE_TYPE, SEQ_NO ASC";
            ddl = this.getPackageDDLFromCatalog(monitor, (DBSObject)sourceObject, sourceObject.getSchema().getName(), sql, hasDbmsMetadata);
        }
        return ddl;
    }

    public GenericTableColumn createTableColumnImpl(@NotNull DBRProgressMonitor monitor, @Nullable JDBCResultSet dbResult, @NotNull GenericTableBase table, String columnName, String typeName, int valueType, int sourceType, int ordinalPos, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) {
        return new AltibaseTableColumn(table, columnName, typeName, valueType, sourceType, ordinalPos, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
    }

    public boolean supportsSequences(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSequencesLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TABLE_NAME, CURRENT_SEQ, START_SEQ, INCREMENT_SEQ, CACHE_SIZE, MAX_SEQ, MIN_SEQ, IS_CYCLE FROM V$SEQ S, SYSTEM_.SYS_TABLES_ T, SYSTEM_.SYS_USERS_ U WHERE U.USER_NAME = ? AND U.USER_ID = T.USER_ID AND T.TABLE_OID = S.SEQ_OID AND T.TABLE_TYPE= 'S' ORDER BY TABLE_NAME ASC");
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    public GenericSequence createSequenceImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) {
        return new AltibaseSequence(container, dbResult);
    }

    public boolean supportsSynonyms(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public JDBCStatement prepareSynonymsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container) throws SQLException {
        boolean isPublic = container.getName().equalsIgnoreCase("PUBLIC");
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT NVL2(SYNONYM_OWNER_ID, SYNONYM_OWNER_ID, -1) AS SYNONYM_OWNER_ID, SYNONYM_NAME, OBJECT_OWNER_NAME, OBJECT_NAME FROM SYSTEM_.SYS_SYNONYMS_ S " + (isPublic ? "" : ", SYSTEM_.SYS_USERS_ U") + " WHERE" + (isPublic ? " SYNONYM_OWNER_ID IS NULL" : " U.USER_NAME = ? AND U.USER_ID = S.SYNONYM_OWNER_ID") + " ORDER BY SYNONYM_NAME");
        if (!isPublic) {
            dbStat.setString(1, container.getName());
        }
        return dbStat;
    }

    public GenericSynonym createSynonymImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws DBException {
        return new AltibaseSynonym(container, JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SYNONYM_OWNER_ID"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SYNONYM_NAME"), "", JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_OWNER_NAME"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME"));
    }

    public boolean supportsTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    @NotNull
    public JDBCStatement prepareTableTriggersLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable GenericTableBase table) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT   TR.OWNER_SCHEMA , TR.OWNER_TABLE AS OWNER , TR.USER_NAME AS TRIGGER_SCHEMA , TR.TRIGGER_NAME , TR.IS_ENABLE , CASE2(TR.EVENT_TIME = 1, 'BEFORE', TR.EVENT_TIME = 2, 'AFTER', TR.EVENT_TIME = 3, 'INSTEAD OF', 'Unknown') AS EVENT_TIME , CASE2(TR.EVENT_TYPE = 1, 'INSERT', TR.EVENT_TYPE = 2, 'DELETE', TR.EVENT_TYPE = 4, 'UPDATE', 'Unknown') AS EVENT_TYPE  , CASE2(TR.GRANULARITY = 1, 'FOR EACH ROW', TR.GRANULARITY = 12, 'TFOR EACH STATEMENT', 'Unknown') AS GRANULARITY , TR.UPDATE_COLUMN_CNT , TR.REF_ROW_CNT , CASE2(TDT.STMT_TYPE = 8, 'DELETE', TDT.STMT_TYPE = 19, 'INSERT', TDT.STMT_TYPE = 33, 'UPDATE',  TDT.STMT_TYPE IS NULL, NULL, 'Unknown') AS DML_STMT_TYPE , TDT.USER_NAME AS DMLTABLE_SCHEMA , TDT.TABLE_NAME AS DMLTABLE_NAME FROM  (SELECT  R.* ,U.USER_NAME AS OWNER_SCHEMA ,T.TABLE_NAME AS OWNER_TABLE FROM  SYSTEM_.SYS_USERS_ U , SYSTEM_.SYS_TABLES_ T , SYSTEM_.SYS_TRIGGERS_ R  WHERE  U.USER_ID = T.USER_ID  AND T.TABLE_ID = R.TABLE_ID  AND U.USER_NAME = ? AND T.TABLE_NAME " + (table == null ? " IS NOT NULL" : "= ?") + ") TR  LEFT OUTER JOIN  (SELECT TRIGGER_OID , STMT_TYPE , U.USER_NAME , T.TABLE_NAME FROM  SYSTEM_.SYS_USERS_ U , SYSTEM_.SYS_TABLES_ T , SYSTEM_.SYS_TRIGGER_DML_TABLES_ WHERE DML_TABLE_ID = T.TABLE_ID AND T.USER_ID = U.USER_ID ) TDT ON TR.TRIGGER_OID = TDT.TRIGGER_OID");
        dbStat.setString(1, container.getName());
        if (table != null) {
            dbStat.setString(2, table.getName());
        }
        return dbStat;
    }

    @NotNull
    public GenericTrigger createTableTriggerImpl(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull GenericTableBase parent, String triggerName, @NotNull JDBCResultSet dbResult) throws DBException {
        String newTriggerName = triggerName;
        if (CommonUtils.isEmpty((String)newTriggerName)) {
            newTriggerName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"TRIGGER_NAME");
        }
        if (newTriggerName == null) {
            return null;
        }
        return new AltibaseTableTrigger(parent, newTriggerName, null, dbResult);
    }

    public boolean supportsDatabaseTriggers(@NotNull GenericDataSource dataSource) {
        return true;
    }

    public String getTriggerDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTrigger trigger) throws DBException {
        String ddl = null;
        String schemaName = null;
        schemaName = trigger.getParentObject() instanceof GenericTable ? trigger.getParentObject().getParentObject().getName() : trigger.getParentObject().getName();
        ddl = this.getDDLFromDbmsMetadata(monitor, (DBSObject)trigger, schemaName, "TRIGGER");
        if (CommonUtils.isEmpty((String)ddl)) {
            String sql = "SELECT  substring FROM system_.sys_triggers_ t , system_.sys_trigger_strings_ sts WHERE t.user_name = ? AND t.trigger_name = ? AND sts.trigger_oid = t.trigger_oid ORDER BY seqno";
            ddl = this.getTriggerDDLFromCatalog(monitor, (DBSObject)trigger, schemaName, sql);
        }
        return ddl;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    public JDBCStatement prepareUniqueConstraintsLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase forParent) throws SQLException {
        boolean hasParent = forParent != null;
        StringBuilder qry = new StringBuilder("SELECT (SELECT db_name FROM v$database) AS TABLE_CAT, u.user_name AS TABLE_SCHEME, t.table_name AS TABLE_NAME, col.column_name AS COLUMN_NAME,  (ccol.constraint_col_order + 1) AS KEY_SEQ, c.constraint_name AS PK_NAME,  c.constraint_type,  c.check_condition,  c.validated FROM system_.sys_users_ u, system_.sys_tables_ t, system_.sys_columns_ col, system_.sys_constraints_ c, system_.sys_constraint_columns_ ccol WHERE u.user_name = ? AND u.user_id = c.user_id AND u.user_id = t.user_id AND t.table_id = c.table_id AND c.constraint_type != 0 AND c.constraint_id = ccol.constraint_id AND ccol.column_id = col.column_id");
        if (hasParent) {
            qry.append(" AND t.table_name = ?");
        }
        JDBCPreparedStatement dbStat = session.prepareStatement(qry.toString());
        dbStat.setString(1, owner.getName());
        if (hasParent) {
            dbStat.setString(2, forParent.getName());
        }
        return dbStat;
    }

    @NotNull
    public GenericUniqueKey createConstraintImpl(@NotNull GenericTableBase table, String constraintName, DBSEntityConstraintType constraintType, JDBCResultSet dbResult, boolean persisted) {
        String condition = "";
        boolean validated = true;
        if (dbResult != null) {
            condition = constraintType.equals(DBSEntityConstraintType.CHECK) ? JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CHECK_CONDITION") : "";
            validated = "T".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"VALIDATED"));
        }
        return new AltibaseConstraint(table, constraintName, null, constraintType, persisted, condition, validated);
    }

    public DBSEntityConstraintType getUniqueConstraintType(@NotNull JDBCResultSet dbResult) throws DBException, SQLException {
        int constraintType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"CONSTRAINT_TYPE");
        switch (constraintType) {
            case 1: {
                return DBSEntityConstraintType.NOT_NULL;
            }
            case 2: {
                return DBSEntityConstraintType.UNIQUE_KEY;
            }
            case 3: {
                return DBSEntityConstraintType.PRIMARY_KEY;
            }
            case 7: {
                return DBSEntityConstraintType.CHECK;
            }
            case 5: {
                return AltibaseConstraint.TIMESTAMP;
            }
            case 6: {
                return AltibaseConstraint.LOCAL_UNIQUE_KEY;
            }
        }
        String exMsg = String.format("Unknown constraint type [NAME] %s [TYPE] %d", JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PK_NAME"), constraintType);
        log.error((Object)exMsg);
        throw new DBException(exMsg);
    }

    public boolean supportsUniqueKeys() {
        return true;
    }

    public boolean supportsCheckConstraints() {
        return true;
    }

    private void loadPackages(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container, JDBCSession session, Map<String, AltibasePackage> packageMap) throws SQLException, DBException {
        block17: {
            String schemaName = container.getName();
            Throwable throwable = null;
            Object var7_8 = null;
            try (JDBCStatement dbStat = this.preparePackageLoadStatement(session, (GenericStructContainer)container);){
                dbStat.setFetchSize(1000);
                dbStat.executeStatement();
                JDBCResultSet dbResult = dbStat.getResultSet();
                if (dbResult == null) break block17;
                try {
                    while (dbResult.next()) {
                        if (monitor.isCanceled()) {
                            break;
                        }
                        String pkgName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PACKAGE_NAME");
                        String key = schemaName + "." + pkgName;
                        AltibasePackage pkg = packageMap.get(key);
                        if (pkg == null) {
                            pkg = this.createPackageImpl((GenericStructContainer)container, pkgName, dbResult);
                            if (pkg != null) {
                                container.addPackage((GenericPackage)pkg);
                                packageMap.put(key, pkg);
                                continue;
                            }
                            log.warn((Object)("Fail to create Package: " + key));
                            continue;
                        }
                        if (JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"PACKAGE_TYPE") == 7) {
                            pkg.setBody(true);
                            pkg.setStatus(JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"STATUS", (String)"0"));
                            continue;
                        }
                        throw new DBException("Duplicated package name found: " + key);
                    }
                }
                finally {
                    dbResult.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void loadPackageDepedentProcedures(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container, JDBCSession session, Map<String, AltibasePackage> packageMap) throws SQLException, DBException {
        block14: {
            String pkgSchema = container.getName();
            Throwable throwable = null;
            Object var7_8 = null;
            try (JDBCStatement dbStat = this.prepareProcedurePackagedLoadStatement(session, (GenericStructContainer)container);){
                dbStat.setFetchSize(1000);
                dbStat.executeStatement();
                JDBCResultSet dbResult = dbStat.getResultSet();
                if (dbResult == null) break block14;
                try {
                    while (dbResult.next()) {
                        AltibaseProcedurePackaged procedure;
                        String key;
                        AltibasePackage pkg;
                        if (monitor.isCanceled()) {
                            break;
                        }
                        String pkgName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PACKAGE_NAME");
                        String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUB_PROC_NAME");
                        int subType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SUB_TYPE");
                        if (CommonUtils.isEmpty((String)procName) || (pkg = packageMap.get(key = pkgSchema + "." + pkgName)) == null || (procedure = new AltibaseProcedurePackaged((GenericStructContainer)container, pkgSchema, pkgName, procName, true, subType == 0 ? DBSProcedureType.PROCEDURE : DBSProcedureType.FUNCTION, null)) == null) continue;
                        pkg.addProcedure(procedure);
                    }
                }
                finally {
                    dbResult.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPSMs(DBRProgressMonitor monitor, @NotNull GenericObjectContainer container, JDBCSession session) throws SQLException, DBException {
        Throwable throwable = null;
        Object var9_6 = null;
        try (JDBCStatement dbStat = this.preparePsmLoadStatement(session, (GenericStructContainer)container);){
            dbStat.setFetchSize(1000);
            dbStat.executeStatement();
            try (JDBCResultSet dbResult = dbStat.getResultSet();){
                block13: while (true) {
                    AltibaseProcedureStandAlone procedure;
                    if (!dbResult.next()) {
                        return;
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    String procName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROC_NAME");
                    boolean valid = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"STATUS", (String)"0");
                    int procType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"OBJECT_TYPE");
                    switch (procType) {
                        case 0: {
                            procedure = new AltibaseProcedureStandAlone((GenericStructContainer)container, procName, valid, DBSProcedureType.PROCEDURE, null);
                            break;
                        }
                        case 1: {
                            procedure = new AltibaseProcedureStandAlone((GenericStructContainer)container, procName, valid, DBSProcedureType.FUNCTION, null);
                            break;
                        }
                        case 3: {
                            procedure = new AltibaseTypeset((GenericStructContainer)container, procName, valid);
                            break;
                        }
                        default: {
                            procedure = null;
                            log.error((Object)("Unknown PSM type found: " + procName + ": " + procType));
                            continue block13;
                        }
                    }
                    if (procedure == null) continue;
                    container.addProcedure((GenericProcedure)procedure);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public void loadProcedures(@NotNull DBRProgressMonitor monitor, @NotNull GenericObjectContainer container) throws DBException {
        HashMap<String, AltibasePackage> packageMap = new HashMap<String, AltibasePackage>();
        GenericDataSource dataSource = container.getDataSource();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load procedures");){
                this.loadPackages(monitor, container, session, packageMap);
                this.loadPackageDepedentProcedures(monitor, container, session, packageMap);
                this.loadPSMs(monitor, container, session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)dataSource);
        }
    }

    public JDBCStatement preparePsmLoadStatement(JDBCSession session, GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.* FROM system_.sys_procedures_ p, system_.sys_users_ u WHERE u.user_name = ? and u.user_id = p.user_id ORDER BY proc_name ASC");
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    public JDBCStatement preparePackageLoadStatement(JDBCSession session, GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT PACKAGE_NAME, PACKAGE_TYPE, AUTHID, STATUS FROM SYSTEM_.SYS_PACKAGES_ P, SYSTEM_.SYS_USERS_ U WHERE U.USER_NAME = ? AND U.USER_ID = P.USER_ID ORDER BY PACKAGE_NAME, PACKAGE_TYPE ASC");
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    public AltibasePackage createPackageImpl(GenericStructContainer container, String packageName, JDBCResultSet resultSet) {
        return new AltibasePackage(container, packageName, resultSet);
    }

    public JDBCStatement prepareProcedurePackagedLoadStatement(JDBCSession session, GenericStructContainer container) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT PP.PACKAGE_NAME, PP.OBJECT_NAME AS SUB_PROC_NAME, PP.SUB_TYPE FROM SYSTEM_.SYS_PACKAGES_ P, SYSTEM_.SYS_USERS_ U, SYSTEM_.SYS_PACKAGE_PARAS_ PP WHERE U.USER_NAME = ? AND U.USER_ID = P.USER_ID AND P.PACKAGE_OID = PP.PACKAGE_OID AND ( PARA_ORDER = 1 OR PARA_ORDER = 0 )");
        dbStat.setString(1, container.getName());
        return dbStat;
    }

    public JDBCPreparedStatement prepareProcedurePackagedColumnLoadStatement(JDBCSession session, String pkgSchema, String pkgName, String procName) throws SQLException {
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT PP.*, D.TYPE_NAME FROM SYSTEM_.SYS_USERS_ U, SYSTEM_.SYS_PACKAGE_PARAS_ PP, V$DATATYPE D WHERE U.USER_NAME = ? AND PP.PACKAGE_NAME = ? AND PP.OBJECT_NAME = ? AND U.USER_ID = PP.USER_ID AND PP.DATA_TYPE = D.DATA_TYPE ORDER BY PARA_ORDER ASC");
        dbStat.setString(1, pkgSchema);
        dbStat.setString(2, pkgName);
        dbStat.setString(3, procName);
        return dbStat;
    }

    private String getViewProcDDLFromCatalog(DBRProgressMonitor monitor, DBSObject sourceObject, String schemaName, String sql) {
        return this.geDDLFromCatalog(monitor, sourceObject, schemaName, sql, "PARSE", false);
    }

    private String getPackageDDLFromCatalog(DBRProgressMonitor monitor, DBSObject sourceObject, String schemaName, String sql, boolean hasDbmsMetdata) {
        return this.geDDLFromCatalog(monitor, sourceObject, schemaName, sql, "PARSE", hasDbmsMetdata);
    }

    private String getTriggerDDLFromCatalog(DBRProgressMonitor monitor, DBSObject sourceObject, String schemaName, String sql) {
        return this.geDDLFromCatalog(monitor, sourceObject, schemaName, sql, "SUBSTRING", false);
    }

    private String geDDLFromCatalog(DBRProgressMonitor monitor, DBSObject sourceObject, String schemaName, String sql, String colname, boolean hasDbmsMetdata) {
        StringBuilder ddl;
        block16: {
            ddl = new StringBuilder(hasDbmsMetdata ? "" : AltibaseConstants.NO_DBMS_METADATA);
            String content = null;
            JDBCPreparedStatement jpstmt = null;
            JDBCResultSet jrs = null;
            GenericMetaObject metaObject = this.getMetaObject("table");
            try {
                try {
                    Throwable throwable = null;
                    Object var13_15 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get DDL from DB");){
                        jpstmt = session.prepareStatement(sql);
                        jpstmt.setString(1, schemaName);
                        jpstmt.setString(2, sourceObject.getName());
                        jrs = jpstmt.executeQuery();
                        while (jrs.next()) {
                            if (monitor.isCanceled()) {
                                break;
                            }
                            content = GenericUtils.safeGetString((GenericMetaObject)metaObject, (ResultSet)jrs, (String)colname);
                            if (content == null) continue;
                            ddl.append(content);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Can't read DDL", (Throwable)e);
                    jrs.close();
                    jpstmt.close();
                    break block16;
                }
            }
            catch (Throwable throwable) {
                jrs.close();
                jpstmt.close();
                throw throwable;
            }
            jrs.close();
            jpstmt.close();
        }
        return ddl.toString();
    }

    private String getDDLFromDbmsMetadata(DBRProgressMonitor monitor, DBSObject sourceObject, String schemaName, String objectType) {
        String ddl = "";
        Statement cstmt = null;
        try {
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get DDL from DBMS_METADATA");){
                    if (this.hasDbmsMetadataPacakge(session)) {
                        Connection conn = session.getOriginal();
                        cstmt = conn.prepareCall("exec ? := dbms_metadata.get_ddl(?, ?, ?)");
                        cstmt.registerOutParameter(1, 12);
                        cstmt.setString(2, objectType);
                        cstmt.setString(3, sourceObject.getName());
                        cstmt.setString(4, schemaName);
                        cstmt.execute();
                        ddl = cstmt.getString(1);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("22026")) {
                    ddl = "-- DDL is too long to be fetched.";
                }
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Can't read DDL from DBMS_METADATA", (Throwable)e);
                try {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return ddl;
    }

    private String getDepDDLFromDbmsMetadata(DBRProgressMonitor monitor, DBSObject sourceObject, String schemaName, String depObjectType) {
        String ddl;
        block39: {
            ddl = "";
            String sqlTerm = "SQLTERMINATOR";
            String getDepDdlQry = "SELECT dbms_metadata.get_dependent_ddl('%s', '%s', '%s') FROM DUAL";
            Connection conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                Throwable throwable = null;
                Object var12_15 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)sourceObject, (String)"Get Dependent DDL from DBMS_METADATA");){
                    if (this.hasDbmsMetadataPacakge(session)) {
                        conn = session.getOriginal();
                        this.setTransformParam(conn, sqlTerm, "T");
                        stmt = conn.createStatement();
                        rs = stmt.executeQuery(String.format(getDepDdlQry, depObjectType, sourceObject.getName(), schemaName));
                        if (rs.next()) {
                            ddl = rs.getString(1);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 990013) {
                    log.warn((Object)("Failed to get dbms_metadata.get_dependent_ddl [TYPE] " + depObjectType + " [BASE OBJECT] " + schemaName + "." + sourceObject.getName()), (Throwable)e);
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        this.setTransformParam(conn, sqlTerm, "F");
                    }
                    break block39;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                break block39;
            }
            catch (Exception e) {
                try {
                    log.warn((Object)("Failed to get dbms_metadata.get_dependent_ddl [TYPE] " + depObjectType + " [BASE OBJECT] " + schemaName + "." + sourceObject.getName()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (conn != null) {
                            this.setTransformParam(conn, sqlTerm, "F");
                        }
                    }
                    catch (SQLException e3) {
                        e3.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        this.setTransformParam(conn, sqlTerm, "F");
                    }
                    break block39;
                }
                catch (SQLException e4) {
                    e4.printStackTrace();
                }
                break block39;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    this.setTransformParam(conn, sqlTerm, "F");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return ddl;
    }

    private boolean setTransformParam(Connection conn, String key, String value) throws SQLException {
        boolean result;
        block2: {
            result = false;
            CallableStatement cstmt = null;
            try {
                cstmt = conn.prepareCall("exec dbms_metadata.set_transform_param(?, ?)");
                cstmt.setString(1, key);
                cstmt.setString(2, value);
                result = cstmt.execute();
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to execute dbms_metadata.set_transform_param [KEY]" + key + ", [VALUE]" + value), (Throwable)e);
                if (cstmt == null) break block2;
                cstmt.close();
            }
        }
        return result;
    }

    private boolean hasDbmsMetadataPacakge(JDBCSession session) {
        boolean hasDbmsMetadataPacakge = false;
        String sql = "SELECT  count(*) FROM  SYSTEM_.SYS_PACKAGES_ P WHERE PACKAGE_NAME = 'DBMS_METADATA'  AND STATUS = 0";
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCPreparedStatement jpstmt = session.prepareStatement(sql);){
                JDBCResultSet jrs = jpstmt.executeQuery();
                if (jrs.next()) {
                    hasDbmsMetadataPacakge = jrs.getInt(1) == 2;
                }
                jrs.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.warn((Object)"Can't check DBMS_METADATA", (Throwable)e);
        }
        return hasDbmsMetadataPacakge;
    }

    @NotNull
    public AltibaseTableIndex createIndexImpl(@NotNull GenericTableBase table, boolean nonUnique, String qualifier, long cardinality, String indexName, DBSIndexType indexType, boolean persisted) {
        return new AltibaseTableIndex(table, nonUnique, qualifier, cardinality, indexName, indexType, persisted);
    }

    public JDBCStatement prepareDbLinkLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable AltibaseDbLink object, @Nullable String objectName) throws SQLException {
        boolean isNullObject = object == null && objectName == null;
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT u.user_name, l.* FROM system_.sys_database_links_ l, system_.sys_users_ u WHERE l.user_id = u.user_id AND u.user_name = ?" + (isNullObject ? "" : " AND l.link_name = ?") + " ORDER BY link_name ASC");
        dbStat.setString(1, container.getName());
        if (!isNullObject) {
            dbStat.setString(2, object != null ? object.getName() : objectName);
        }
        return dbStat;
    }

    public AltibaseDbLink createDbLinkImpl(GenericStructContainer container, JDBCResultSet resultSet) {
        return new AltibaseDbLink(container, resultSet);
    }

    public JDBCStatement prepareLibraryLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable AltibaseLibrary object, @Nullable String objectName) throws SQLException {
        boolean isNullObject = object == null && objectName == null;
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT l.* FROM system_.sys_users_ u, system_.sys_libraries_ l WHERE u.user_id = l.user_id AND u.user_name =  ? " + (isNullObject ? "" : " AND l.library_name = ?") + " ORDER BY library_name ASC");
        dbStat.setString(1, container.getName());
        if (!isNullObject) {
            dbStat.setString(2, object != null ? object.getName() : objectName);
        }
        return dbStat;
    }

    public AltibaseLibrary createLibraryImpl(GenericStructContainer container, JDBCResultSet resultSet) {
        return new AltibaseLibrary(container, resultSet);
    }

    public JDBCStatement prepareDirectoryLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @Nullable AltibaseDirectory object, @Nullable String objectName) throws SQLException {
        boolean isNullObject = object == null && objectName == null;
        JDBCPreparedStatement dbStat = session.prepareStatement("SELECT d.* FROM system_.sys_users_ u, system_.sys_directories_ d WHERE u.user_id = d.user_id AND u.user_name =  ? " + (isNullObject ? "" : " AND d.directory_name = ?") + " ORDER BY directory_name ASC");
        dbStat.setString(1, container.getName());
        if (!isNullObject) {
            dbStat.setString(2, object != null ? object.getName() : objectName);
        }
        return dbStat;
    }

    public AltibaseDirectory createDirectoryImpl(GenericStructContainer container, JDBCResultSet resultSet) {
        return new AltibaseDirectory(container, resultSet);
    }
}

