/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.undo.snapshot;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.internal.resources.undo.snapshot.AbstractResourceSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.IFileContentSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.ResourceSnapshotMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileSnapshot
extends AbstractResourceSnapshot<IFile> {
    String name;
    URI location;
    String charset;
    private IFileContentSnapshot fileContentDescription;

    public FileSnapshot(IFile file) {
        super(file);
        this.name = file.getName();
        try {
            this.charset = file.getCharset(false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (file.isLinked()) {
            this.location = file.getLocationURI();
        }
    }

    public FileSnapshot(IFile file, URI linkLocation, IFileContentSnapshot fileContentDescription) {
        super(file);
        this.name = file.getName();
        this.location = linkLocation;
        this.charset = null;
        this.fileContentDescription = fileContentDescription;
    }

    @Override
    public void recordStateFromHistory(IProgressMonitor monitor) throws CoreException {
        IFile resource = this.createResourceHandle();
        Assert.isLegal((resource.getType() == 1 ? 1 : 0) != 0);
        if (this.location != null) {
            return;
        }
        IFileState[] states = resource.getHistory(monitor);
        if (states.length > 0) {
            final IFileState state = this.getMatchingFileState(states);
            this.fileContentDescription = new IFileContentSnapshot(){

                @Override
                public boolean exists() {
                    return state.exists();
                }

                @Override
                public InputStream getContents() throws CoreException {
                    return state.getContents();
                }

                @Override
                public String getCharset() throws CoreException {
                    return state.getCharset();
                }
            };
        }
    }

    @Override
    public IFile createResourceHandle() {
        IWorkspaceRoot workspaceRoot = this.parent.getWorkspace().getRoot();
        IPath fullPath = this.parent.getFullPath().append(this.name);
        return workspaceRoot.getFile(fullPath);
    }

    @Override
    public void createExistentResourceFromHandle(IProgressMonitor mon) throws CoreException {
        IFile fileHandle = this.createResourceHandle();
        if (fileHandle.exists()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (int)200);
        subMonitor.setTaskName(ResourceSnapshotMessages.FileDescription_NewFileProgress);
        try {
            if (this.location != null) {
                fileHandle.createLink(this.location, 16, (IProgressMonitor)subMonitor.split(200));
            } else {
                InputStream contents = new ByteArrayInputStream(ResourceSnapshotMessages.FileDescription_ContentsCouldNotBeRestored.getBytes());
                if (this.fileContentDescription != null && this.fileContentDescription.exists()) {
                    contents = this.fileContentDescription.getContents();
                }
                fileHandle.create(contents, false, (IProgressMonitor)subMonitor.split(100));
                fileHandle.setCharset(this.charset, (IProgressMonitor)subMonitor.split(100));
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
    }

    @Override
    public boolean isValid() {
        if (this.location != null) {
            return super.isValid();
        }
        return super.isValid() && this.fileContentDescription != null && this.fileContentDescription.exists();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private IFileState getMatchingFileState(IFileState[] states) {
        IFileState[] iFileStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            IFileState state = iFileStateArray[n2];
            if (this.localTimeStamp == state.getModificationTime()) {
                return state;
            }
            ++n2;
        }
        return states[0];
    }

    @Override
    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        super.restoreResourceAttributes(resource);
        Assert.isLegal((boolean)(resource instanceof IFile));
        IFile file = (IFile)resource;
        if (this.charset != null) {
            file.setCharset(this.charset, null);
        }
    }
}

