/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchemaObject;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypeDescriptor;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx2;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;

public class OracleSequence
extends OracleSchemaObject
implements DBSSequence,
DBPScriptObject,
DBSTypedObjectEx2 {
    private BigDecimal minValue;
    private BigDecimal maxValue;
    private long incrementBy;
    private long cacheSize;
    private BigDecimal lastValue;
    private boolean flagCycle;
    private boolean flagOrder;
    private String sourceText;
    private OracleDataType valueType = null;
    private DBSTypeDescriptor typeDescriptor = null;

    public OracleSequence(OracleSchema schema, String name) {
        super(schema, name, false);
        this.minValue = null;
        this.maxValue = null;
        this.incrementBy = 0L;
        this.cacheSize = 0L;
        this.lastValue = new BigDecimal(0);
        this.flagCycle = false;
        this.flagOrder = false;
    }

    public OracleSequence(OracleSchema schema, ResultSet dbResult) {
        super(schema, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEQUENCE_NAME"), true);
        this.minValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MIN_VALUE");
        this.maxValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"MAX_VALUE");
        this.incrementBy = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INCREMENT_BY");
        this.cacheSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CACHE_SIZE");
        this.lastValue = JDBCUtils.safeGetBigDecimal((ResultSet)dbResult, (String)"LAST_NUMBER");
        this.flagCycle = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"CYCLE_FLAG", (String)"Y");
        this.flagOrder = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"ORDER_FLAG", (String)"Y");
    }

    public OracleDataType getValueType() {
        if (this.valueType == null) {
            this.valueType = this.getSchema().getDataSource().getLocalDataType("NUMBER");
        }
        return this.valueType;
    }

    @Nullable
    public DBSTypeDescriptor getTypeDescriptor(@NotNull DBRProgressMonitor monitor) {
        if (this.typeDescriptor == null) {
            this.typeDescriptor = new OracleSequenceTypeDescriptor();
        }
        return this.typeDescriptor;
    }

    @Override
    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=true, updatable=true, order=2)
    public BigDecimal getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(BigDecimal lastValue) {
        this.lastValue = lastValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=3)
    public BigDecimal getMinValue() {
        return this.minValue;
    }

    public void setMinValue(BigDecimal minValue) {
        this.minValue = minValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=4)
    public BigDecimal getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(BigDecimal maxValue) {
        this.maxValue = maxValue;
    }

    @Property(viewable=true, editable=true, updatable=true, order=5)
    public Long getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(Long incrementBy) {
        this.incrementBy = incrementBy;
    }

    @Property(viewable=true, editable=true, updatable=true, order=6)
    public long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Property(viewable=true, editable=true, updatable=true, order=7)
    public boolean isCycle() {
        return this.flagCycle;
    }

    public void setCycle(boolean flagCycle) {
        this.flagCycle = flagCycle;
    }

    @Property(viewable=true, editable=true, updatable=true, order=8)
    public boolean isOrder() {
        return this.flagOrder;
    }

    public void setOrder(boolean flagOrder) {
        this.flagOrder = flagOrder;
    }

    public String buildStatement(boolean forUpdate) {
        StringBuilder sb = new StringBuilder();
        if (forUpdate) {
            sb.append("ALTER SEQUENCE ");
        } else {
            sb.append("CREATE SEQUENCE ");
        }
        sb.append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
        if (this.getIncrementBy() != null) {
            sb.append("INCREMENT BY ").append(this.getIncrementBy()).append(" ");
        }
        if (this.getMinValue() != null) {
            sb.append("MINVALUE ").append(this.getMinValue()).append(" ");
        }
        if (this.getMaxValue() != null) {
            sb.append("MAXVALUE ").append(this.getMaxValue()).append(" ");
        }
        if (this.isCycle()) {
            sb.append("CYCLE ");
        } else {
            sb.append("NOCYCLE ");
        }
        if (this.getCacheSize() > 0L) {
            sb.append("CACHE ").append(this.getCacheSize()).append(" ");
        } else {
            sb.append("NOCACHE ");
        }
        if (this.isOrder()) {
            sb.append("ORDER ");
        } else {
            sb.append("NOORDER ");
        }
        return sb.toString();
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.sourceText == null) {
            this.sourceText = this.buildStatement(false);
        }
        return this.sourceText;
    }

    private class OracleSequenceTypeDescriptor
    implements DBSTypeDescriptor {
        private final DBSTypeDescriptor valueTypeDescriptor = new DBSTypeDescriptor(){

            @NotNull
            public String getTypeName() {
                return OracleSequence.this.getValueType().getName();
            }

            @Nullable
            public DBSDataType getUnderlyingType() {
                return OracleSequence.this.getValueType();
            }
        };
        private final List<DBSTypeDescriptor.CompositeMemberInfo> members = List.of(new DBSTypeDescriptor.CompositeMemberInfo("CURRVAL", this.valueTypeDescriptor), new DBSTypeDescriptor.CompositeMemberInfo("NEXTVAL", this.valueTypeDescriptor));

        private OracleSequenceTypeDescriptor() {
        }

        @NotNull
        public DBSTypeDescriptor.Kind getKind() {
            return DBSTypeDescriptor.Kind.COMPOSITE;
        }

        public Collection<DBSTypeDescriptor.CompositeMemberInfo> getCompositeMembers(@NotNull DBRProgressMonitor monitor) throws DBException {
            return this.members;
        }

        @Nullable
        public DBSTypeDescriptor findCompositeMember(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
            return this.members.stream().filter(m -> m.name().equalsIgnoreCase(name)).findFirst().map(DBSTypeDescriptor.CompositeMemberInfo::type).orElse(null);
        }

        @NotNull
        public String getTypeName() {
            return OracleSequence.this.getName();
        }
    }
}

