﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/workspaces-web/WorkSpacesWeb_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WorkSpacesWeb {
namespace Model {
class CreateBrowserSettingsResult {
 public:
  AWS_WORKSPACESWEB_API CreateBrowserSettingsResult() = default;
  AWS_WORKSPACESWEB_API CreateBrowserSettingsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WORKSPACESWEB_API CreateBrowserSettingsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The ARN of the browser settings.</p>
   */
  inline const Aws::String& GetBrowserSettingsArn() const { return m_browserSettingsArn; }
  template <typename BrowserSettingsArnT = Aws::String>
  void SetBrowserSettingsArn(BrowserSettingsArnT&& value) {
    m_browserSettingsArnHasBeenSet = true;
    m_browserSettingsArn = std::forward<BrowserSettingsArnT>(value);
  }
  template <typename BrowserSettingsArnT = Aws::String>
  CreateBrowserSettingsResult& WithBrowserSettingsArn(BrowserSettingsArnT&& value) {
    SetBrowserSettingsArn(std::forward<BrowserSettingsArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateBrowserSettingsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_browserSettingsArn;

  Aws::String m_requestId;
  bool m_browserSettingsArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WorkSpacesWeb
}  // namespace Aws
