﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendationsRequest.h>
#include <aws/migrationhubstrategy/MigrationHubStrategyRecommendations_EXPORTS.h>
#include <aws/migrationhubstrategy/model/StrategyOption.h>

#include <utility>

namespace Aws {
namespace MigrationHubStrategyRecommendations {
namespace Model {

/**
 */
class UpdateServerConfigRequest : public MigrationHubStrategyRecommendationsRequest {
 public:
  AWS_MIGRATIONHUBSTRATEGYRECOMMENDATIONS_API UpdateServerConfigRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateServerConfig"; }

  AWS_MIGRATIONHUBSTRATEGYRECOMMENDATIONS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p> The ID of the server. </p>
   */
  inline const Aws::String& GetServerId() const { return m_serverId; }
  inline bool ServerIdHasBeenSet() const { return m_serverIdHasBeenSet; }
  template <typename ServerIdT = Aws::String>
  void SetServerId(ServerIdT&& value) {
    m_serverIdHasBeenSet = true;
    m_serverId = std::forward<ServerIdT>(value);
  }
  template <typename ServerIdT = Aws::String>
  UpdateServerConfigRequest& WithServerId(ServerIdT&& value) {
    SetServerId(std::forward<ServerIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The preferred strategy options for the application component. See the
   * response from <a>GetServerStrategies</a>.</p>
   */
  inline const StrategyOption& GetStrategyOption() const { return m_strategyOption; }
  inline bool StrategyOptionHasBeenSet() const { return m_strategyOptionHasBeenSet; }
  template <typename StrategyOptionT = StrategyOption>
  void SetStrategyOption(StrategyOptionT&& value) {
    m_strategyOptionHasBeenSet = true;
    m_strategyOption = std::forward<StrategyOptionT>(value);
  }
  template <typename StrategyOptionT = StrategyOption>
  UpdateServerConfigRequest& WithStrategyOption(StrategyOptionT&& value) {
    SetStrategyOption(std::forward<StrategyOptionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_serverId;

  StrategyOption m_strategyOption;
  bool m_serverIdHasBeenSet = false;
  bool m_strategyOptionHasBeenSet = false;
};

}  // namespace Model
}  // namespace MigrationHubStrategyRecommendations
}  // namespace Aws
