---
myst:
  html_meta:
    keywords: LaTeX, programmation, environnements, environnement, environnements personnalisés
---
# Que sont les environnements LaTeX ?

Les *environnements* ont été mis en place avec LaTeX : ils effectuent une action sur la totalité d'un bloc délimité dans le document plutôt que d'agir en un point donné de votre document.

## Environnement sans paramètre

Un environnement simple pourrait changer la police utilisée pour une partie du texte. En voici un exemple de définition avec la commande dédiée, `\newenvironment` :

```{noedit}
\newenvironment{chassefixe}%
  {% Code exécuté au début de l'environnement
   \ttfamily}%
  {% Code exécuté en fin d'environnement
  }
```

L'environnement `chassefixe` ainsi défini peut ensuite être utilisé de la manière suivante :

```
\documentclass{article}
  \usepackage{lmodern}
  \pagestyle{empty}

\newenvironment{chassefixe}%
  {\ttfamily}%
  {}

\begin{document}
Voici un exemple%
\begin{chassefixe}
de texte à chasse fixe.
\end{chassefixe}
\end{document}
```

Certains environnements s'avèrent autrement plus complexes tel `document`. Simple d'usage, il n'en appelle pas moins des codes TeX peu évidents. De fait, la plupart des environnements sont plus élaborés que `chassefixe` et *beaucoup* plus simples que `document`.

Un environnement place son contenu dans un *groupe* TeX, de sorte que les commandes utilisées à l'intérieur de l'environnement « ne s'en échappent pas ». Ainsi, l'environnement `chassefixe`, ci-dessus, restreint son effet à son propre contenu (ce qui figure entre `\begin{chassefixe}` et `\end{chassefixe}`), ce qui correspond exactement à notre besoin.

:::{tip}
Certains environnements simples ne nous font pas gagner beaucoup de temps en matière de saisie. De fait, notre environnement `chassefixe` pourrait être remplacé par :

```{noedit}
Voici un exemple {\ttfamily de texte à chasse fixe.}
```

Cependant, ces environnements :

- peuvent rendre votre code plus lisible ;
- permettent de mieux gérer la mise en forme de votre document. Ainsi, modifier la définition de votre environnement modifiera la mise en forme de tous les environnements présents dans votre document.
:::

## Environnement avec paramètres

LaTeX permet également d'utiliser des paramètres avec les environnements. Voici un exemple d'environnement demandant un paramètre :

```{noedit}
\newenvironment{blocfonte}[1]%
  {#1\selectfont}%
  {}
```

Cet environnement s'utilise alors ainsi (et produit ici le même résultat que l'environnement `chassefixe` vu plus haut) :

```{noedit}
Voici un exemple%
\begin{blocfonte}{\ttfamily}
de texte à chasse fixe.
\end{blocfonte}
```

## Les paramètres optionnels

Les environnements peuvent également avoir des paramètres optionnels, à l'image des commandes. Voici un exemple :

```{noedit}
\newenvironment{textespecial}[1][\itshape]%
  {#1}%
  {}
```

En temps normal, cet environnement compose son contenu en italique mais, dès qu'un paramètre lui est transmis, il modifie la mise en forme (ici, une nouvelle fois pour restituer la mise en forme obtenue avec `chassefixe`) :

```{noedit}
Voici un exemple%
\begin{textespecial}{\ttfamily}
de texte à chasse fixe.
\end{textespecial}
```

## Pour aller plus loin

Pour plus de détails sur les possibilités de la commande `\newenvironment`, vous pouvez consulter la question "[](commande_newenvironment.md)".


:::{sources}
[What are LaTeX environments](faquk:FAQ-whatenv)
:::
