#### Note: this error code is no longer emitted by the compiler.


`#[ffi_returns_twice]` was used on something other than a foreign function
declaration.

Erroneous code example:

```compile_fail
#![feature(ffi_returns_twice)]
#![crate_type = "lib"]

#[ffi_returns_twice] // error!
pub fn foo() {}
```

`#[ffi_returns_twice]` can only be used on foreign function declarations.
For example, we might correct the previous example by declaring
the function inside of an `extern` block.

```compile_fail
#![feature(ffi_returns_twice)]

extern "C" {
   #[ffi_returns_twice] // ok!
   pub fn foo();
}
```
