# 2023-05-23 Triage Log

There were a few regressions, but most were expected, and one in particular (PR
#111807) is expected yield gains in object code performance at the expense of a
slight compile-time hit. There are a couple PR's that need future followup,
namely PRs #111364 and #111524.

Triage done by **@pnkfelix**.
Revision range: [3ea9ad53..cda5becc](https://perf.rust-lang.org/?start=3ea9ad532474343426e564b997891e459cda89a6&end=cda5becc27cbc7106646fbc40aacea5e7896d954&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 2.3%]   | 28    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.7%]   | 19    |
| Improvements ✅ <br /> (primary)   | -0.9% | [-4.4%, -0.3%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.2%, -0.4%] | 11    |
| All ❌✅ (primary)                 | 0.1%  | [-4.4%, 2.3%]  | 39    |


3 Regressions, 2 Improvements, 5 Mixed; 2 of them in rollups
51 artifact comparisons made in total

#### Regressions

Remove the ThinLTO CU hack [#111364](https://github.com/rust-lang/rust/pull/111364) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=24c180c438b5ee9a150d20b9822bd7712bef8f62&end=77fb0cd3aa276919e00397f526616c5036562ea1&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.6% | [1.1%, 2.2%] | 2     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.6% | [1.1%, 2.2%] | 2     |

* This is being discussed on the comment thread for PR #111364.
* what is worrisome is not instructions:u, but rather the regressions to size:linked_artifact (aka binary sizes).
* the PR author is going to try to replicate locally and investigate further if so.

Add creation time support to `FileTimes` on apple and windows [#109773](https://github.com/rust-lang/rust/pull/109773) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8a281f9c796ee8cbebb07bbeec04ef2f2dd8db45&end=521f4dae1bdf7fe9cf9436ecef9ee7c7442708bf&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.7%, 0.8%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.3%, 0.7%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.7%, 0.8%] | 4     |

* already marked as triaged.


[rustc_ty_utils] Treat `drop_in_place`'s *mut argument like &mut when adding LLVM attributes [#111807](https://github.com/rust-lang/rust/pull/111807) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cda5becc27cbc7106646fbc40aacea5e7896d954&end=f3d597b31c0f101a02c230798afa31a36bdacbc6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.7%]   | 17    |
| Regressions ❌ <br /> (secondary)  | 1.3%  | [0.2%, 2.9%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.4%  | [-0.2%, 0.7%]  | 18    |


* This change emits more attributes; it is expected to slow down the compiler, and that is compensated by the fact that it enables better code-generation from what we emit out of the compiler
* marking as triaged.

#### Improvements

Rollup of 7 pull requests [#111650](https://github.com/rust-lang/rust/pull/111650) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b652d9a0fd5c5a7eeacd1ae8299166941c221230&end=e77366b57b799dfa3ce1fcb850c068723a3213ee&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.3% | [-4.4%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.5%, -2.0%] | 2     |
| All ❌✅ (primary)                 | -2.3% | [-4.4%, -0.6%] | 3     |

* solely improvements to rustdoc benchmarks

Rollup of 7 pull requests [#111721](https://github.com/rust-lang/rust/pull/111721) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ba6f5e3b4d60ea5a847cd4402cca594cd40b218f&end=fdd030127cc68afec44a8d3f6341525dd34e50ae&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 6     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 3     |

* minor improvement to primary regex and secondary externs.

#### Mixed

Specialize query execution for incremental and non-incremental [#108062](https://github.com/rust-lang/rust/pull/108062) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9239760da89cd8e9a51536beeb0a23762064037d&end=b652d9a0fd5c5a7eeacd1ae8299166941c221230&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 9     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 2.9%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.1%, -0.3%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.2%, -0.2%] | 31    |
| All ❌✅ (primary)                 | -0.3% | [-1.1%, 0.3%]  | 26    |

* the sea of green improvements to scenario=full outweighs the occasional (and minor) red regressions to incr cases.
* marking as triaged.

Merge return place with other locals in CopyProp. [#111556](https://github.com/rust-lang/rust/pull/111556) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e77366b57b799dfa3ce1fcb850c068723a3213ee&end=5c3a3362f86f9748b4a6cb18b147893774a189ac&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.4%, 0.4%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.7%, -0.2%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.9%, -0.7%] | 4     |
| All ❌✅ (primary)                 | -0.4% | [-0.7%, -0.2%] | 17    |

* already marked as triaged.

Shorten backtraces for queries in ICEs [#108938](https://github.com/rust-lang/rust/pull/108938) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=77fb0cd3aa276919e00397f526616c5036562ea1&end=77c836e1ae582661924d3b6ec4d57a2de120f59f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.6%]   | 10    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 3     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 3     |

* already marked as triaged.

do not allow inference in `predicate_must_hold` (alternative approach) [#110100](https://github.com/rust-lang/rust/pull/110100) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=92f5dea0ebe2e34ad8411e8cd8a0c97dd45b3400&end=19ca5692f69d20643656bf501fd171f1907ef875&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.9%, 1.4%]   | 6     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 1.1%  | [0.9%, 1.4%]   | 6     |

* diesel took a 1% regression in various scenarios.
* there are indications from T-types that this is fixing a bug
* therefore, the performance regression is acceptable; marking as triaged.

`ascii::Char`-ify the escaping code in `core` [#111524](https://github.com/rust-lang/rust/pull/111524) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7047d97e012d5ed90cf2837c361150bc149837b4&end=e86fd62b6b198584a47798eb271d4b54c4dc96ec&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.7%]   | 6     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.7%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 3     |
| All ❌✅ (primary)                 | 0.1%  | [-0.7%, 0.7%]  | 9     |

* lqd identified most of this as noise.
* however, there was a bump on the compile-time for html5ever that has not yet receded as of 2023-05-23; i.e. that might not be noise.
* therefore, not yet marking as triaged...

#### Untriaged Pull Requests

- [#111807 [rustc_ty_utils] Treat `drop_in_place`'s *mut argument like &mut when adding LLVM attributes](https://github.com/rust-lang/rust/pull/111807)
- [#111524 `ascii::Char`-ify the escaping code in `core`](https://github.com/rust-lang/rust/pull/111524)
- [#111425 Populate effective visibilities in `rustc_privacy` (take 2)](https://github.com/rust-lang/rust/pull/111425)
- [#111364 Remove the ThinLTO CU hack](https://github.com/rust-lang/rust/pull/111364)
- [#111311 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/111311)
- [#111306 Update hashbrown from 0.12.3 to 0.13.1 for std](https://github.com/rust-lang/rust/pull/111306)
- [#111221 Combine three generalizer implementations](https://github.com/rust-lang/rust/pull/111221)
- [#111007 Disable nrvo mir opt](https://github.com/rust-lang/rust/pull/111007)
- [#110967 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/110967)
- [#110546 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/110546)
- [#110542 resolve: Remove `module_children_untracked`](https://github.com/rust-lang/rust/pull/110542)
- [#110440 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110440)
- [#110100 do not allow inference in `predicate_must_hold` (alternative approach)](https://github.com/rust-lang/rust/pull/110100)
- [#110012 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/110012)
- [#109900 Only enable ConstProp at mir-opt-level >= 2.](https://github.com/rust-lang/rust/pull/109900)
- [#109732 Uplift `clippy::{drop,forget}_{ref,copy}` lints](https://github.com/rust-lang/rust/pull/109732)
- [#109692 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/109692)
- [#109588 Alloc `hir::Lit` in an arena to remove the destructor from `Expr`](https://github.com/rust-lang/rust/pull/109588)
- [#109247 Permit MIR inlining without #[inline]](https://github.com/rust-lang/rust/pull/109247)
- [#109097 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/109097)
- [#108934 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/108934)
- [#108872 Strengthen state tracking in const-prop](https://github.com/rust-lang/rust/pull/108872)
- [#108830 Treat projections with infer as placeholder during fast reject in new solver](https://github.com/rust-lang/rust/pull/108830)
- [#108587 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/108587)
- [#108080 Add a builtin `FnPtr` trait that is implemented for all function pointers](https://github.com/rust-lang/rust/pull/108080)
- [#108062 Specialize query execution for incremental and non-incremental](https://github.com/rust-lang/rust/pull/108062)
- [#108025 rustdoc: add more tooltips to intra-doc links](https://github.com/rust-lang/rust/pull/108025)
- [#107833 Factor query arena allocation out from query caches](https://github.com/rust-lang/rust/pull/107833)
- [#107783 rustdoc: simplify DOM for `.item-table`](https://github.com/rust-lang/rust/pull/107783)
- [#107765 rustc/rustdoc: Perform name resolver cleanups enabled by #94857](https://github.com/rust-lang/rust/pull/107765)
