# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class ContainerGroupInstanceCountSummary(_model_base.Model):
    """Displays the counts of container groups in each state, as known by the StandbyPool resource
    provider.

    :ivar zone: The zone that the provided counts are in. It will not have a value if zones are not
     enabled.
    :vartype zone: int
    :ivar instance_counts_by_state: The count of pooled container groups in each state for the
     given zone. Required.
    :vartype instance_counts_by_state:
     list[~azure.mgmt.standbypool.models.PoolContainerGroupStateCount]
    """

    zone: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The zone that the provided counts are in. It will not have a value if zones are not enabled."""
    instance_counts_by_state: List["_models.PoolContainerGroupStateCount"] = rest_field(
        name="instanceCountsByState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The count of pooled container groups in each state for the given zone. Required."""

    @overload
    def __init__(
        self,
        *,
        instance_counts_by_state: List["_models.PoolContainerGroupStateCount"],
        zone: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContainerGroupProfile(_model_base.Model):
    """Details of the ContainerGroupProfile.

    :ivar id: Specifies container group profile id of standby container groups. Required.
    :vartype id: str
    :ivar revision: Specifies revision of container group profile.
    :vartype revision: int
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies container group profile id of standby container groups. Required."""
    revision: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies revision of container group profile."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        revision: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContainerGroupProperties(_model_base.Model):
    """Details of the ContainerGroupProperties.

    :ivar container_group_profile: Specifies container group profile of standby container groups.
     Required.
    :vartype container_group_profile: ~azure.mgmt.standbypool.models.ContainerGroupProfile
    :ivar subnet_ids: Specifies subnet Ids for container group.
    :vartype subnet_ids: list[~azure.mgmt.standbypool.models.Subnet]
    """

    container_group_profile: "_models.ContainerGroupProfile" = rest_field(
        name="containerGroupProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies container group profile of standby container groups. Required."""
    subnet_ids: Optional[List["_models.Subnet"]] = rest_field(
        name="subnetIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies subnet Ids for container group."""

    @overload
    def __init__(
        self,
        *,
        container_group_profile: "_models.ContainerGroupProfile",
        subnet_ids: Optional[List["_models.Subnet"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_model_base.Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_model_base.Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.standbypool.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.standbypool.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_model_base.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.standbypool.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_model_base.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.standbypool.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.standbypool.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.standbypool.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_model_base.Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PoolContainerGroupStateCount(_model_base.Model):
    """Displays the counts of pooled container groups in each state, as known by the StandbyPool
    resource provider.

    :ivar state: The state that the pooled container groups count is for. Required. Known values
     are: "Running", "Creating", and "Deleting".
    :vartype state: str or ~azure.mgmt.standbypool.models.PoolContainerGroupState
    :ivar count: The count of pooled container groups in the given state. Required.
    :vartype count: int
    """

    state: Union[str, "_models.PoolContainerGroupState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The state that the pooled container groups count is for. Required. Known values are:
     \"Running\", \"Creating\", and \"Deleting\"."""
    count: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The count of pooled container groups in the given state. Required."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.PoolContainerGroupState"],
        count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PoolStatus(_model_base.Model):
    """Displays StandbyPool status.

    :ivar code: Displays the healthy state of the StandbyPool. Required. Known values are:
     "HealthState/healthy" and "HealthState/degraded".
    :vartype code: str or ~azure.mgmt.standbypool.models.HealthStateCode
    :ivar message: Displays the StandbyPool health state details.
    :vartype message: str
    """

    code: Union[str, "_models.HealthStateCode"] = rest_field(visibility=["read"])
    """Displays the healthy state of the StandbyPool. Required. Known values are:
     \"HealthState/healthy\" and \"HealthState/degraded\"."""
    message: Optional[str] = rest_field(visibility=["read"])
    """Displays the StandbyPool health state details."""


class PoolVirtualMachineStateCount(_model_base.Model):
    """Displays the counts of pooled virtual machines in each state, as known by the StandbyPool
    resource provider.

    :ivar state: The state that the pooled virtual machines count is for. Required. Known values
     are: "Running", "Creating", "Starting", "Deleting", "Deallocated", "Deallocating",
     "Hibernated", and "Hibernating".
    :vartype state: str or ~azure.mgmt.standbypool.models.PoolVirtualMachineState
    :ivar count: The count of pooled virtual machines in the given state. Required.
    :vartype count: int
    """

    state: Union[str, "_models.PoolVirtualMachineState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The state that the pooled virtual machines count is for. Required. Known values are:
     \"Running\", \"Creating\", \"Starting\", \"Deleting\", \"Deallocated\", \"Deallocating\",
     \"Hibernated\", and \"Hibernating\"."""
    count: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The count of pooled virtual machines in the given state. Required."""

    @overload
    def __init__(
        self,
        *,
        state: Union[str, "_models.PoolVirtualMachineState"],
        count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_model_base.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    """


class StandbyContainerGroupPoolElasticityProfile(_model_base.Model):  # pylint: disable=name-too-long
    """Specifies the elasticity profile of the standby container group pools.

    :ivar max_ready_capacity: Specifies maximum number of standby container groups in the standby
     pool. Required.
    :vartype max_ready_capacity: int
    :ivar refill_policy: Specifies refill policy of the pool. "always"
    :vartype refill_policy: str or ~azure.mgmt.standbypool.models.RefillPolicy
    """

    max_ready_capacity: int = rest_field(
        name="maxReadyCapacity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies maximum number of standby container groups in the standby pool. Required."""
    refill_policy: Optional[Union[str, "_models.RefillPolicy"]] = rest_field(
        name="refillPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies refill policy of the pool. \"always\""""

    @overload
    def __init__(
        self,
        *,
        max_ready_capacity: int,
        refill_policy: Optional[Union[str, "_models.RefillPolicy"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolForecastValues(_model_base.Model):
    """Displays the forecast information of the standby pool.

    :ivar instances_requested_count: Displays the predicted count of instances to be requested from
     the standby pool. Required.
    :vartype instances_requested_count: list[int]
    """

    instances_requested_count: List[int] = rest_field(name="instancesRequestedCount", visibility=["read"])
    """Displays the predicted count of instances to be requested from the standby pool. Required."""


class StandbyContainerGroupPoolPrediction(_model_base.Model):
    """Displays prediction information of the standby pool.

    :ivar forecast_values: Displays the forecast information of the standby pool. Required.
    :vartype forecast_values:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolForecastValues
    :ivar forecast_start_time: Displays the UTC timestamp of when the prediction was retrieved for
     the standby pool. Required.
    :vartype forecast_start_time: ~datetime.datetime
    :ivar forecast_info: Displays additional information for the prediction of the standby pool.
     Required.
    :vartype forecast_info: str
    """

    forecast_values: "_models.StandbyContainerGroupPoolForecastValues" = rest_field(
        name="forecastValues", visibility=["read"]
    )
    """Displays the forecast information of the standby pool. Required."""
    forecast_start_time: datetime.datetime = rest_field(name="forecastStartTime", visibility=["read"], format="rfc3339")
    """Displays the UTC timestamp of when the prediction was retrieved for the standby pool. Required."""
    forecast_info: str = rest_field(name="forecastInfo", visibility=["read"])
    """Displays additional information for the prediction of the standby pool. Required."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResource(TrackedResource):
    """A StandbyContainerGroupPoolResource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceProperties
    """

    properties: Optional["_models.StandbyContainerGroupPoolResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyContainerGroupPoolResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Details of the StandbyContainerGroupPool.

    :ivar elasticity_profile: Specifies elasticity profile of standby container group pools.
     Required.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfile
    :ivar container_group_properties: Specifies container group properties of standby container
     group pools. Required.
    :vartype container_group_properties: ~azure.mgmt.standbypool.models.ContainerGroupProperties
    :ivar zones: Specifies zones of standby container group pools.
    :vartype zones: list[str]
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    elasticity_profile: "_models.StandbyContainerGroupPoolElasticityProfile" = rest_field(
        name="elasticityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies elasticity profile of standby container group pools. Required."""
    container_group_properties: "_models.ContainerGroupProperties" = rest_field(
        name="containerGroupProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies container group properties of standby container group pools. Required."""
    zones: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies zones of standby container group pools."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        elasticity_profile: "_models.StandbyContainerGroupPoolElasticityProfile",
        container_group_properties: "_models.ContainerGroupProperties",
        zones: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResourceUpdate(_model_base.Model):
    """The type used for update operations of the StandbyContainerGroupPoolResource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolResourceUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.StandbyContainerGroupPoolResourceUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyContainerGroupPoolResourceUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolResourceUpdateProperties(_model_base.Model):  # pylint: disable=name-too-long
    """The updatable properties of the StandbyContainerGroupPoolResource.

    :ivar elasticity_profile: Specifies elasticity profile of standby container group pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolElasticityProfile
    :ivar container_group_properties: Specifies container group properties of standby container
     group pools.
    :vartype container_group_properties: ~azure.mgmt.standbypool.models.ContainerGroupProperties
    :ivar zones: Specifies zones of standby container group pools.
    :vartype zones: list[str]
    """

    elasticity_profile: Optional["_models.StandbyContainerGroupPoolElasticityProfile"] = rest_field(
        name="elasticityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies elasticity profile of standby container group pools."""
    container_group_properties: Optional["_models.ContainerGroupProperties"] = rest_field(
        name="containerGroupProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies container group properties of standby container group pools."""
    zones: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies zones of standby container group pools."""

    @overload
    def __init__(
        self,
        *,
        elasticity_profile: Optional["_models.StandbyContainerGroupPoolElasticityProfile"] = None,
        container_group_properties: Optional["_models.ContainerGroupProperties"] = None,
        zones: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolRuntimeViewResource(ProxyResource):  # pylint: disable=name-too-long
    """Contains information about a standby container group pool as last known by the StandbyPool
    resource provider.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolRuntimeViewResourceProperties
    """

    properties: Optional["_models.StandbyContainerGroupPoolRuntimeViewResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StandbyContainerGroupPoolRuntimeViewResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyContainerGroupPoolRuntimeViewResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Contains information about a standby pool as last known by the StandbyPool resource provider.

    :ivar instance_count_summary: A list containing the counts of container groups in each possible
     state, as known by the StandbyPool resource provider. Required.
    :vartype instance_count_summary:
     list[~azure.mgmt.standbypool.models.ContainerGroupInstanceCountSummary]
    :ivar status: Display status of the standby pool.
    :vartype status: ~azure.mgmt.standbypool.models.PoolStatus
    :ivar provisioning_state: Displays the provisioning state of the standby pool. Known values
     are: "Succeeded", "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    :ivar prediction: Displays prediction information of the standby pool.
    :vartype prediction: ~azure.mgmt.standbypool.models.StandbyContainerGroupPoolPrediction
    """

    instance_count_summary: List["_models.ContainerGroupInstanceCountSummary"] = rest_field(
        name="instanceCountSummary", visibility=["read"]
    )
    """A list containing the counts of container groups in each possible state, as known by the
     StandbyPool resource provider. Required."""
    status: Optional["_models.PoolStatus"] = rest_field(visibility=["read"])
    """Display status of the standby pool."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Displays the provisioning state of the standby pool. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", and \"Deleting\"."""
    prediction: Optional["_models.StandbyContainerGroupPoolPrediction"] = rest_field(visibility=["read"])
    """Displays prediction information of the standby pool."""


class StandbyVirtualMachinePoolElasticityProfile(_model_base.Model):  # pylint: disable=name-too-long
    """Details of the elasticity profile.

    :ivar max_ready_capacity: Specifies the maximum number of virtual machines in the standby
     virtual machine pool. Required.
    :vartype max_ready_capacity: int
    :ivar min_ready_capacity: Specifies the desired minimum number of virtual machines in the
     standby virtual machine pool. MinReadyCapacity cannot exceed MaxReadyCapacity.
    :vartype min_ready_capacity: int
    """

    max_ready_capacity: int = rest_field(
        name="maxReadyCapacity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the maximum number of virtual machines in the standby virtual machine pool. Required."""
    min_ready_capacity: Optional[int] = rest_field(
        name="minReadyCapacity", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the desired minimum number of virtual machines in the standby virtual machine pool.
     MinReadyCapacity cannot exceed MaxReadyCapacity."""

    @overload
    def __init__(
        self,
        *,
        max_ready_capacity: int,
        min_ready_capacity: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolForecastValues(_model_base.Model):
    """Displays the forecast information of the standby pool.

    :ivar instances_requested_count: Displays the predicted count of instances to be requested from
     the standby pool. Required.
    :vartype instances_requested_count: list[int]
    """

    instances_requested_count: List[int] = rest_field(name="instancesRequestedCount", visibility=["read"])
    """Displays the predicted count of instances to be requested from the standby pool. Required."""


class StandbyVirtualMachinePoolPrediction(_model_base.Model):
    """Displays prediction information of the standby pool.

    :ivar forecast_values: Displays the forecast information of the standby pool. Required.
    :vartype forecast_values:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolForecastValues
    :ivar forecast_start_time: Displays the UTC timestamp of when the prediction was retrieved for
     the standby pool. Required.
    :vartype forecast_start_time: ~datetime.datetime
    :ivar forecast_info: Displays additional information for the prediction of the standby pool.
     Required.
    :vartype forecast_info: str
    """

    forecast_values: "_models.StandbyVirtualMachinePoolForecastValues" = rest_field(
        name="forecastValues", visibility=["read"]
    )
    """Displays the forecast information of the standby pool. Required."""
    forecast_start_time: datetime.datetime = rest_field(name="forecastStartTime", visibility=["read"], format="rfc3339")
    """Displays the UTC timestamp of when the prediction was retrieved for the standby pool. Required."""
    forecast_info: str = rest_field(name="forecastInfo", visibility=["read"])
    """Displays additional information for the prediction of the standby pool. Required."""


class StandbyVirtualMachinePoolResource(TrackedResource):
    """A StandbyVirtualMachinePoolResource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceProperties
    """

    properties: Optional["_models.StandbyVirtualMachinePoolResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyVirtualMachinePoolResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Details of the StandbyVirtualMachinePool.

    :ivar elasticity_profile: Specifies the elasticity profile of the standby virtual machine
     pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfile
    :ivar virtual_machine_state: Specifies the desired state of virtual machines in the pool.
     Required. Known values are: "Running", "Deallocated", and "Hibernated".
    :vartype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
    :ivar attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
     virtual machine scale set the pool is attached to.
    :vartype attached_virtual_machine_scale_set_id: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = rest_field(
        name="elasticityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the elasticity profile of the standby virtual machine pools."""
    virtual_machine_state: Union[str, "_models.VirtualMachineState"] = rest_field(
        name="virtualMachineState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the desired state of virtual machines in the pool. Required. Known values are:
     \"Running\", \"Deallocated\", and \"Hibernated\"."""
    attached_virtual_machine_scale_set_id: Optional[str] = rest_field(
        name="attachedVirtualMachineScaleSetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached
     to."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        virtual_machine_state: Union[str, "_models.VirtualMachineState"],
        elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = None,
        attached_virtual_machine_scale_set_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolResourceUpdate(_model_base.Model):
    """The type used for update operations of the StandbyVirtualMachinePoolResource.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolResourceUpdateProperties
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.StandbyVirtualMachinePoolResourceUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.StandbyVirtualMachinePoolResourceUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolResourceUpdateProperties(_model_base.Model):  # pylint: disable=name-too-long
    """The updatable properties of the StandbyVirtualMachinePoolResource.

    :ivar elasticity_profile: Specifies the elasticity profile of the standby virtual machine
     pools.
    :vartype elasticity_profile:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolElasticityProfile
    :ivar virtual_machine_state: Specifies the desired state of virtual machines in the pool. Known
     values are: "Running", "Deallocated", and "Hibernated".
    :vartype virtual_machine_state: str or ~azure.mgmt.standbypool.models.VirtualMachineState
    :ivar attached_virtual_machine_scale_set_id: Specifies the fully qualified resource ID of a
     virtual machine scale set the pool is attached to.
    :vartype attached_virtual_machine_scale_set_id: str
    """

    elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = rest_field(
        name="elasticityProfile", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the elasticity profile of the standby virtual machine pools."""
    virtual_machine_state: Optional[Union[str, "_models.VirtualMachineState"]] = rest_field(
        name="virtualMachineState", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the desired state of virtual machines in the pool. Known values are: \"Running\",
     \"Deallocated\", and \"Hibernated\"."""
    attached_virtual_machine_scale_set_id: Optional[str] = rest_field(
        name="attachedVirtualMachineScaleSetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached
     to."""

    @overload
    def __init__(
        self,
        *,
        elasticity_profile: Optional["_models.StandbyVirtualMachinePoolElasticityProfile"] = None,
        virtual_machine_state: Optional[Union[str, "_models.VirtualMachineState"]] = None,
        attached_virtual_machine_scale_set_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolRuntimeViewResource(ProxyResource):  # pylint: disable=name-too-long
    """Contains information about a standby virtual machine pool as last known by the StandbyPool
    resource provider.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties:
     ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolRuntimeViewResourceProperties
    """

    properties: Optional["_models.StandbyVirtualMachinePoolRuntimeViewResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StandbyVirtualMachinePoolRuntimeViewResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyVirtualMachinePoolRuntimeViewResourceProperties(_model_base.Model):  # pylint: disable=name-too-long
    """Contains information about a standby pool as last known by the StandbyPool resource provider.

    :ivar instance_count_summary: A list containing the counts of virtual machines in each possible
     power state for each zone if enabled, as known by the StandbyPool resource provider. If zones
     are not enabled on the attached VMSS, the list will contain a single entry without zone values.
     Note: any resources in the Running state may still be installing extensions / not fully
     provisioned. Required.
    :vartype instance_count_summary:
     list[~azure.mgmt.standbypool.models.VirtualMachineInstanceCountSummary]
    :ivar status: Display status of the standby pool.
    :vartype status: ~azure.mgmt.standbypool.models.PoolStatus
    :ivar provisioning_state: Displays the provisioning state of the standby pool. Known values
     are: "Succeeded", "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    :ivar prediction: Displays prediction information of the standby pool.
    :vartype prediction: ~azure.mgmt.standbypool.models.StandbyVirtualMachinePoolPrediction
    """

    instance_count_summary: List["_models.VirtualMachineInstanceCountSummary"] = rest_field(
        name="instanceCountSummary", visibility=["read"]
    )
    """A list containing the counts of virtual machines in each possible power state for each zone if
     enabled, as known by the StandbyPool resource provider. If zones are not enabled on the
     attached VMSS, the list will contain a single entry without zone values. Note: any resources in
     the Running state may still be installing extensions / not fully provisioned. Required."""
    status: Optional["_models.PoolStatus"] = rest_field(visibility=["read"])
    """Display status of the standby pool."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Displays the provisioning state of the standby pool. Known values are: \"Succeeded\",
     \"Failed\", \"Canceled\", and \"Deleting\"."""
    prediction: Optional["_models.StandbyVirtualMachinePoolPrediction"] = rest_field(visibility=["read"])
    """Displays prediction information of the standby pool."""


class StandbyVirtualMachineResource(ProxyResource):
    """Concrete proxy resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.standbypool.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.standbypool.models.StandbyVirtualMachineResourceProperties
    """

    properties: Optional["_models.StandbyVirtualMachineResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.StandbyVirtualMachineResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StandbyVirtualMachineResourceProperties(_model_base.Model):
    """Details of the StandbyVirtualMachine.

    :ivar virtual_machine_resource_id: Resource id of the virtual machine. Required.
    :vartype virtual_machine_resource_id: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.standbypool.models.ProvisioningState
    """

    virtual_machine_resource_id: str = rest_field(
        name="virtualMachineResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Resource id of the virtual machine. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     and \"Deleting\"."""

    @overload
    def __init__(
        self,
        *,
        virtual_machine_resource_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Subnet(_model_base.Model):
    """Subnet of container group.

    :ivar id: Specifies ARM resource id of the subnet. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specifies ARM resource id of the subnet. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_model_base.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.standbypool.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VirtualMachineInstanceCountSummary(_model_base.Model):
    """Contains the counts of VMs in each power state in a given zone, fault domain, as known by the
    StandbyPool resource provider. Note: any resources in the Running state may still be installing
    extensions / not fully provisioned.

    :ivar zone: The zone that the provided counts are in. It will not have a value if zones are not
     enabled on the attached VMSS.
    :vartype zone: int
    :ivar instance_counts_by_state: The count of pooled virtual machines in each state for the
     given zone. Required.
    :vartype instance_counts_by_state:
     list[~azure.mgmt.standbypool.models.PoolVirtualMachineStateCount]
    """

    zone: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The zone that the provided counts are in. It will not have a value if zones are not enabled on
     the attached VMSS."""
    instance_counts_by_state: List["_models.PoolVirtualMachineStateCount"] = rest_field(
        name="instanceCountsByState", visibility=["read", "create", "update", "delete", "query"]
    )
    """The count of pooled virtual machines in each state for the given zone. Required."""

    @overload
    def __init__(
        self,
        *,
        instance_counts_by_state: List["_models.PoolVirtualMachineStateCount"],
        zone: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
