MapServer MapScript Modules
===========================

Much of MapServer's functionality is accessible from Java, Perl, PHP, Python,
Ruby, C#, and Tcl.  MapScript is not a language like JavaScript or Python, it
is a loadable module that brings MapServer capabilities to your favorite 
high-level programming language.

MapScript Family
----------------------------------

The MapScript family tree looks like this:

```

               MapServer
                   | 
                   |    
                   | 
              SWIGMapScript
                   |
   +----+-----+----+----+--+--+-----------+
   |    |     |    |    |  |  |           |
 Perl Python Ruby Java C# Tcl PHPNG ...
```                 


The SWIGMapScript modules are generated by [SWIG](http://www.swig.org). 

SWIG MapScript
--------------

Installation instructions are located in the individual languages
directories such as ``mapscript/perl``, ``mapscript/python``. 

The main MapScript SWIG interface file is ``mapscript/mapscript.i``.  This
file includes specific class interface files from ``mapscript/swiginc`` and
language specific code from the language directories.

Note the **v8** folder contains files for [V8 MapScript Support](https://mapserver.org/installation/v8.html). 
This is not a JavaScript version of MapScript, but provides support for the use of JavaScript
in [STYLEITEM](https://mapserver.org/mapfile/styleitem.html#styleitemjs) and 
[GEOTRANSFORM](https://mapserver.org/mapfile/geomtransform.html#geomtransformjs). 

API Documentation can be found at the [Shared SWIG MapScript Documentation](https://mapserver.org/mapscript/index.html) 
page. 

PHPNG (SWIG) MapScript
----------------------

PHP support ("PHPNG") is included in the [SWIG API](https://mapserver.org/mapscript/index.html) 
since the MapServer 7.4.0 release.  You can specify `WITH_PHPNG=ON` at your 
CMake commandline, to compile PHPNG support for MapServer.

The old native PHPMapScript module developed using the PHP C API was removed in 
the MapServer 8.0.0 release. 

