#include "hoz.h"
#include "hozcli.h"
#include "getopt.h"


extern char outpath[MAXLEN];
extern size_t fullsize, partsize, headersize;
extern int showprogress, forceow, simulate;


void hoz_print(const char *str)
{
    printf(str);
}

void hoz_lf()
{
    hoz_print("\n");
}


/**
 * main
 *
 * hoz [-pvf] [-c size[k|m|g]] [-o outpath] inputfname
 */
int main(int argc, char **argv)
{
    int cflag, pflag, oflag, help;
    char *cval, *ifname;
    int c, j;
    int option_index;
    size_t size_multiplier;
    static struct option long_options[] = {
	{"cut",     1, NULL, 'c'},
	{"paste",   0, NULL, 'p'},
	{"verbose", 0, NULL, 'v'},
	{"force",   0, NULL, 'f'},
	{"outpath", 1, NULL, 'o'},
	{"help",    0, NULL, 'h'},
	{"version", 0, NULL, '!'},
	{0, 0, NULL, 0}
    };

    cflag = pflag = oflag = showprogress = forceow = simulate = help = 0;
    cval = ifname = NULL;
    opterr = 1;
    size_multiplier = 1;
    getcwd(outpath, MAXLEN);

    while (1) {
	option_index = 0;
	c = getopt_long(argc, argv, "c:pvfo:h", long_options, &option_index);
	if (c == -1) {
	    break;
	}
        switch (c) {
        case 'c':
            cflag = 1;
            cval = optarg;
            break;
        case 'p':
            pflag = 1;
            break;
        case 'v':
            showprogress = 1;
            break;
        case 'o':
            oflag = 1;
            strcpy(outpath, optarg);
            break;
        case 'f':
            forceow = 1;
            break;
        case 's':
            simulate = 1;
            break;
        case 'h':
            help = 1;
            break;
	case '!': /* dummy hack, there is no short opt for --version */
	    hoz_echo(301, NULL);
	    return 0;
	case '?':
	    hoz_echo(415, argv[0]);
	    return 415;
        }
    }
    ifname = argv[optind];
    fullsize = 0;
    partsize = 0;
    if (argc < 2) {
        hoz_echo(413, argv[0]);
        return 413;
    }
    if (help) {
        hoz_echo(401, argv[0]);
        return 0;
    }
    if (!cflag && !pflag) {
        hoz_echo(413, argv[0]);
        return 413;
    }
    if (cflag) {
	if (cval && strlen(cval) && strchr("kKmM", cval[strlen(cval)-1])) {
	    switch (cval[strlen(cval)-1]) {
		case 'k':
		case 'K':
		    size_multiplier = 1024;
		    break;
		case 'm':
		case 'M':
		    size_multiplier = 1024*1024;
		    break;
		/*
		case 'g':
		case 'G':
		    size_multiplier = 1024*1024*1024;
		*/
	    }
	    cval[strlen(cval)-1] = '\0';
	}
	partsize = atolmp(cval, size_multiplier);
        if (!partsize) {
            hoz_echo(409, cval);
            return 409;
        }
	partsize *= size_multiplier;
    }

    j = 0;
    if ((!ifname || !*ifname) || (oflag && (!outpath || !*outpath))) {
        hoz_echo(414, argv[0]);
        return 414;
    }

    if (!isdir(outpath)) {
        hoz_echo(411, outpath);
        return 411;
    }



    /* display the program version */
    hoz_echo(301, NULL);

    if (cflag) {                /* cut */
        return hoz_cut_main(ifname);
    } else {                    /* paste */
        return hoz_paste_main(ifname);
    }
}

/**
 * hoz_replace_ask - ask the user if an output file should be replaced
 * @s: filename
 */
int hoz_replace_ask(const char *s)
{
    unsigned char foo[1024], bar, *baz;
    sprintf(foo, HOZ_REPLACE_C, s);
    hoz_lf();
    hoz_print(foo);
    for (bar = 0;;) {
        bar = fgetc(stdin);
        for (baz = HOZ_YESCHARS; *baz; ++baz) {
            if (bar == *baz) {
                return 1;
            }
        }
        for (baz = HOZ_NOCHARS; *baz; ++baz) {
            if (bar == *baz) {
                return 0;
            }
        }
    }
}
