//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/migrate/armmigrate"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// ImportCollectorsServer is a fake server for instances of the armmigrate.ImportCollectorsClient type.
type ImportCollectorsServer struct {
	// Create is the fake for method ImportCollectorsClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, projectName string, importCollectorName string, options *armmigrate.ImportCollectorsClientCreateOptions) (resp azfake.Responder[armmigrate.ImportCollectorsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ImportCollectorsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, projectName string, importCollectorName string, options *armmigrate.ImportCollectorsClientDeleteOptions) (resp azfake.Responder[armmigrate.ImportCollectorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ImportCollectorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, projectName string, importCollectorName string, options *armmigrate.ImportCollectorsClientGetOptions) (resp azfake.Responder[armmigrate.ImportCollectorsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByProjectPager is the fake for method ImportCollectorsClient.NewListByProjectPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProjectPager func(resourceGroupName string, projectName string, options *armmigrate.ImportCollectorsClientListByProjectOptions) (resp azfake.PagerResponder[armmigrate.ImportCollectorsClientListByProjectResponse])
}

// NewImportCollectorsServerTransport creates a new instance of ImportCollectorsServerTransport with the provided implementation.
// The returned ImportCollectorsServerTransport instance is connected to an instance of armmigrate.ImportCollectorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewImportCollectorsServerTransport(srv *ImportCollectorsServer) *ImportCollectorsServerTransport {
	return &ImportCollectorsServerTransport{
		srv:                   srv,
		newListByProjectPager: newTracker[azfake.PagerResponder[armmigrate.ImportCollectorsClientListByProjectResponse]](),
	}
}

// ImportCollectorsServerTransport connects instances of armmigrate.ImportCollectorsClient to instances of ImportCollectorsServer.
// Don't use this type directly, use NewImportCollectorsServerTransport instead.
type ImportCollectorsServerTransport struct {
	srv                   *ImportCollectorsServer
	newListByProjectPager *tracker[azfake.PagerResponder[armmigrate.ImportCollectorsClientListByProjectResponse]]
}

// Do implements the policy.Transporter interface for ImportCollectorsServerTransport.
func (i *ImportCollectorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ImportCollectorsClient.Create":
		resp, err = i.dispatchCreate(req)
	case "ImportCollectorsClient.Delete":
		resp, err = i.dispatchDelete(req)
	case "ImportCollectorsClient.Get":
		resp, err = i.dispatchGet(req)
	case "ImportCollectorsClient.NewListByProjectPager":
		resp, err = i.dispatchNewListByProjectPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *ImportCollectorsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if i.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/importcollectors/(?P<importCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmigrate.ImportCollector](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	importCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("importCollectorName")])
	if err != nil {
		return nil, err
	}
	var options *armmigrate.ImportCollectorsClientCreateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmigrate.ImportCollectorsClientCreateOptions{
			CollectorBody: &body,
		}
	}
	respr, errRespr := i.srv.Create(req.Context(), resourceGroupNameParam, projectNameParam, importCollectorNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ImportCollector, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}

func (i *ImportCollectorsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if i.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/importcollectors/(?P<importCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	importCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("importCollectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Delete(req.Context(), resourceGroupNameParam, projectNameParam, importCollectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}

func (i *ImportCollectorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/importcollectors/(?P<importCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	importCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("importCollectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, projectNameParam, importCollectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ImportCollector, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}

func (i *ImportCollectorsServerTransport) dispatchNewListByProjectPager(req *http.Request) (*http.Response, error) {
	if i.srv.NewListByProjectPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProjectPager not implemented")}
	}
	newListByProjectPager := i.newListByProjectPager.get(req)
	if newListByProjectPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/importcollectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		resp := i.srv.NewListByProjectPager(resourceGroupNameParam, projectNameParam, nil)
		newListByProjectPager = &resp
		i.newListByProjectPager.add(req, newListByProjectPager)
	}
	resp, err := server.PagerResponderNext(newListByProjectPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		i.newListByProjectPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProjectPager) {
		i.newListByProjectPager.remove(req)
	}
	return resp, nil
}
