//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/kusto/armkusto/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ClustersServer is a fake server for instances of the armkusto.ClustersClient type.
type ClustersServer struct {
	// BeginAddLanguageExtensions is the fake for method ClustersClient.BeginAddLanguageExtensions
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAddLanguageExtensions func(ctx context.Context, resourceGroupName string, clusterName string, languageExtensionsToAdd armkusto.LanguageExtensionsList, options *armkusto.ClustersClientBeginAddLanguageExtensionsOptions) (resp azfake.PollerResponder[armkusto.ClustersClientAddLanguageExtensionsResponse], errResp azfake.ErrorResponder)

	// CheckNameAvailability is the fake for method ClustersClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, location string, clusterName armkusto.ClusterCheckNameRequest, options *armkusto.ClustersClientCheckNameAvailabilityOptions) (resp azfake.Responder[armkusto.ClustersClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ClustersClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, clusterName string, parameters armkusto.Cluster, options *armkusto.ClustersClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armkusto.ClustersClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ClustersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, clusterName string, options *armkusto.ClustersClientBeginDeleteOptions) (resp azfake.PollerResponder[armkusto.ClustersClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDetachFollowerDatabases is the fake for method ClustersClient.BeginDetachFollowerDatabases
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDetachFollowerDatabases func(ctx context.Context, resourceGroupName string, clusterName string, followerDatabaseToRemove armkusto.FollowerDatabaseDefinition, options *armkusto.ClustersClientBeginDetachFollowerDatabasesOptions) (resp azfake.PollerResponder[armkusto.ClustersClientDetachFollowerDatabasesResponse], errResp azfake.ErrorResponder)

	// BeginDiagnoseVirtualNetwork is the fake for method ClustersClient.BeginDiagnoseVirtualNetwork
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDiagnoseVirtualNetwork func(ctx context.Context, resourceGroupName string, clusterName string, options *armkusto.ClustersClientBeginDiagnoseVirtualNetworkOptions) (resp azfake.PollerResponder[armkusto.ClustersClientDiagnoseVirtualNetworkResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ClustersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, clusterName string, options *armkusto.ClustersClientGetOptions) (resp azfake.Responder[armkusto.ClustersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ClustersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armkusto.ClustersClientListOptions) (resp azfake.PagerResponder[armkusto.ClustersClientListResponse])

	// NewListByResourceGroupPager is the fake for method ClustersClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armkusto.ClustersClientListByResourceGroupOptions) (resp azfake.PagerResponder[armkusto.ClustersClientListByResourceGroupResponse])

	// NewListFollowerDatabasesPager is the fake for method ClustersClient.NewListFollowerDatabasesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListFollowerDatabasesPager func(resourceGroupName string, clusterName string, options *armkusto.ClustersClientListFollowerDatabasesOptions) (resp azfake.PagerResponder[armkusto.ClustersClientListFollowerDatabasesResponse])

	// NewListLanguageExtensionsPager is the fake for method ClustersClient.NewListLanguageExtensionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListLanguageExtensionsPager func(resourceGroupName string, clusterName string, options *armkusto.ClustersClientListLanguageExtensionsOptions) (resp azfake.PagerResponder[armkusto.ClustersClientListLanguageExtensionsResponse])

	// NewListOutboundNetworkDependenciesEndpointsPager is the fake for method ClustersClient.NewListOutboundNetworkDependenciesEndpointsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListOutboundNetworkDependenciesEndpointsPager func(resourceGroupName string, clusterName string, options *armkusto.ClustersClientListOutboundNetworkDependenciesEndpointsOptions) (resp azfake.PagerResponder[armkusto.ClustersClientListOutboundNetworkDependenciesEndpointsResponse])

	// NewListSKUsPager is the fake for method ClustersClient.NewListSKUsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSKUsPager func(options *armkusto.ClustersClientListSKUsOptions) (resp azfake.PagerResponder[armkusto.ClustersClientListSKUsResponse])

	// NewListSKUsByResourcePager is the fake for method ClustersClient.NewListSKUsByResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSKUsByResourcePager func(resourceGroupName string, clusterName string, options *armkusto.ClustersClientListSKUsByResourceOptions) (resp azfake.PagerResponder[armkusto.ClustersClientListSKUsByResourceResponse])

	// BeginMigrate is the fake for method ClustersClient.BeginMigrate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrate func(ctx context.Context, resourceGroupName string, clusterName string, clusterMigrateRequest armkusto.ClusterMigrateRequest, options *armkusto.ClustersClientBeginMigrateOptions) (resp azfake.PollerResponder[armkusto.ClustersClientMigrateResponse], errResp azfake.ErrorResponder)

	// BeginRemoveLanguageExtensions is the fake for method ClustersClient.BeginRemoveLanguageExtensions
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRemoveLanguageExtensions func(ctx context.Context, resourceGroupName string, clusterName string, languageExtensionsToRemove armkusto.LanguageExtensionsList, options *armkusto.ClustersClientBeginRemoveLanguageExtensionsOptions) (resp azfake.PollerResponder[armkusto.ClustersClientRemoveLanguageExtensionsResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method ClustersClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, clusterName string, options *armkusto.ClustersClientBeginStartOptions) (resp azfake.PollerResponder[armkusto.ClustersClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method ClustersClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, clusterName string, options *armkusto.ClustersClientBeginStopOptions) (resp azfake.PollerResponder[armkusto.ClustersClientStopResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ClustersClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, clusterName string, parameters armkusto.ClusterUpdate, options *armkusto.ClustersClientBeginUpdateOptions) (resp azfake.PollerResponder[armkusto.ClustersClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewClustersServerTransport creates a new instance of ClustersServerTransport with the provided implementation.
// The returned ClustersServerTransport instance is connected to an instance of armkusto.ClustersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewClustersServerTransport(srv *ClustersServer) *ClustersServerTransport {
	return &ClustersServerTransport{
		srv:                            srv,
		beginAddLanguageExtensions:     newTracker[azfake.PollerResponder[armkusto.ClustersClientAddLanguageExtensionsResponse]](),
		beginCreateOrUpdate:            newTracker[azfake.PollerResponder[armkusto.ClustersClientCreateOrUpdateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armkusto.ClustersClientDeleteResponse]](),
		beginDetachFollowerDatabases:   newTracker[azfake.PollerResponder[armkusto.ClustersClientDetachFollowerDatabasesResponse]](),
		beginDiagnoseVirtualNetwork:    newTracker[azfake.PollerResponder[armkusto.ClustersClientDiagnoseVirtualNetworkResponse]](),
		newListPager:                   newTracker[azfake.PagerResponder[armkusto.ClustersClientListResponse]](),
		newListByResourceGroupPager:    newTracker[azfake.PagerResponder[armkusto.ClustersClientListByResourceGroupResponse]](),
		newListFollowerDatabasesPager:  newTracker[azfake.PagerResponder[armkusto.ClustersClientListFollowerDatabasesResponse]](),
		newListLanguageExtensionsPager: newTracker[azfake.PagerResponder[armkusto.ClustersClientListLanguageExtensionsResponse]](),
		newListOutboundNetworkDependenciesEndpointsPager: newTracker[azfake.PagerResponder[armkusto.ClustersClientListOutboundNetworkDependenciesEndpointsResponse]](),
		newListSKUsPager:              newTracker[azfake.PagerResponder[armkusto.ClustersClientListSKUsResponse]](),
		newListSKUsByResourcePager:    newTracker[azfake.PagerResponder[armkusto.ClustersClientListSKUsByResourceResponse]](),
		beginMigrate:                  newTracker[azfake.PollerResponder[armkusto.ClustersClientMigrateResponse]](),
		beginRemoveLanguageExtensions: newTracker[azfake.PollerResponder[armkusto.ClustersClientRemoveLanguageExtensionsResponse]](),
		beginStart:                    newTracker[azfake.PollerResponder[armkusto.ClustersClientStartResponse]](),
		beginStop:                     newTracker[azfake.PollerResponder[armkusto.ClustersClientStopResponse]](),
		beginUpdate:                   newTracker[azfake.PollerResponder[armkusto.ClustersClientUpdateResponse]](),
	}
}

// ClustersServerTransport connects instances of armkusto.ClustersClient to instances of ClustersServer.
// Don't use this type directly, use NewClustersServerTransport instead.
type ClustersServerTransport struct {
	srv                                              *ClustersServer
	beginAddLanguageExtensions                       *tracker[azfake.PollerResponder[armkusto.ClustersClientAddLanguageExtensionsResponse]]
	beginCreateOrUpdate                              *tracker[azfake.PollerResponder[armkusto.ClustersClientCreateOrUpdateResponse]]
	beginDelete                                      *tracker[azfake.PollerResponder[armkusto.ClustersClientDeleteResponse]]
	beginDetachFollowerDatabases                     *tracker[azfake.PollerResponder[armkusto.ClustersClientDetachFollowerDatabasesResponse]]
	beginDiagnoseVirtualNetwork                      *tracker[azfake.PollerResponder[armkusto.ClustersClientDiagnoseVirtualNetworkResponse]]
	newListPager                                     *tracker[azfake.PagerResponder[armkusto.ClustersClientListResponse]]
	newListByResourceGroupPager                      *tracker[azfake.PagerResponder[armkusto.ClustersClientListByResourceGroupResponse]]
	newListFollowerDatabasesPager                    *tracker[azfake.PagerResponder[armkusto.ClustersClientListFollowerDatabasesResponse]]
	newListLanguageExtensionsPager                   *tracker[azfake.PagerResponder[armkusto.ClustersClientListLanguageExtensionsResponse]]
	newListOutboundNetworkDependenciesEndpointsPager *tracker[azfake.PagerResponder[armkusto.ClustersClientListOutboundNetworkDependenciesEndpointsResponse]]
	newListSKUsPager                                 *tracker[azfake.PagerResponder[armkusto.ClustersClientListSKUsResponse]]
	newListSKUsByResourcePager                       *tracker[azfake.PagerResponder[armkusto.ClustersClientListSKUsByResourceResponse]]
	beginMigrate                                     *tracker[azfake.PollerResponder[armkusto.ClustersClientMigrateResponse]]
	beginRemoveLanguageExtensions                    *tracker[azfake.PollerResponder[armkusto.ClustersClientRemoveLanguageExtensionsResponse]]
	beginStart                                       *tracker[azfake.PollerResponder[armkusto.ClustersClientStartResponse]]
	beginStop                                        *tracker[azfake.PollerResponder[armkusto.ClustersClientStopResponse]]
	beginUpdate                                      *tracker[azfake.PollerResponder[armkusto.ClustersClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ClustersServerTransport.
func (c *ClustersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ClustersClient.BeginAddLanguageExtensions":
		resp, err = c.dispatchBeginAddLanguageExtensions(req)
	case "ClustersClient.CheckNameAvailability":
		resp, err = c.dispatchCheckNameAvailability(req)
	case "ClustersClient.BeginCreateOrUpdate":
		resp, err = c.dispatchBeginCreateOrUpdate(req)
	case "ClustersClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ClustersClient.BeginDetachFollowerDatabases":
		resp, err = c.dispatchBeginDetachFollowerDatabases(req)
	case "ClustersClient.BeginDiagnoseVirtualNetwork":
		resp, err = c.dispatchBeginDiagnoseVirtualNetwork(req)
	case "ClustersClient.Get":
		resp, err = c.dispatchGet(req)
	case "ClustersClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "ClustersClient.NewListByResourceGroupPager":
		resp, err = c.dispatchNewListByResourceGroupPager(req)
	case "ClustersClient.NewListFollowerDatabasesPager":
		resp, err = c.dispatchNewListFollowerDatabasesPager(req)
	case "ClustersClient.NewListLanguageExtensionsPager":
		resp, err = c.dispatchNewListLanguageExtensionsPager(req)
	case "ClustersClient.NewListOutboundNetworkDependenciesEndpointsPager":
		resp, err = c.dispatchNewListOutboundNetworkDependenciesEndpointsPager(req)
	case "ClustersClient.NewListSKUsPager":
		resp, err = c.dispatchNewListSKUsPager(req)
	case "ClustersClient.NewListSKUsByResourcePager":
		resp, err = c.dispatchNewListSKUsByResourcePager(req)
	case "ClustersClient.BeginMigrate":
		resp, err = c.dispatchBeginMigrate(req)
	case "ClustersClient.BeginRemoveLanguageExtensions":
		resp, err = c.dispatchBeginRemoveLanguageExtensions(req)
	case "ClustersClient.BeginStart":
		resp, err = c.dispatchBeginStart(req)
	case "ClustersClient.BeginStop":
		resp, err = c.dispatchBeginStop(req)
	case "ClustersClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginAddLanguageExtensions(req *http.Request) (*http.Response, error) {
	if c.srv.BeginAddLanguageExtensions == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAddLanguageExtensions not implemented")}
	}
	beginAddLanguageExtensions := c.beginAddLanguageExtensions.get(req)
	if beginAddLanguageExtensions == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/addLanguageExtensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armkusto.LanguageExtensionsList](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginAddLanguageExtensions(req.Context(), resourceGroupNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAddLanguageExtensions = &respr
		c.beginAddLanguageExtensions.add(req, beginAddLanguageExtensions)
	}

	resp, err := server.PollerResponderNext(beginAddLanguageExtensions, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginAddLanguageExtensions.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAddLanguageExtensions) {
		c.beginAddLanguageExtensions.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if c.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armkusto.ClusterCheckNameRequest](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CheckNameAvailability(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := c.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armkusto.Cluster](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		ifNoneMatchParam := getOptional(getHeaderValue(req.Header, "If-None-Match"))
		var options *armkusto.ClustersClientBeginCreateOrUpdateOptions
		if ifMatchParam != nil || ifNoneMatchParam != nil {
			options = &armkusto.ClustersClientBeginCreateOrUpdateOptions{
				IfMatch:     ifMatchParam,
				IfNoneMatch: ifNoneMatchParam,
			}
		}
		respr, errRespr := c.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, clusterNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		c.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		c.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginDetachFollowerDatabases(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDetachFollowerDatabases == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDetachFollowerDatabases not implemented")}
	}
	beginDetachFollowerDatabases := c.beginDetachFollowerDatabases.get(req)
	if beginDetachFollowerDatabases == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/detachFollowerDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armkusto.FollowerDatabaseDefinition](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDetachFollowerDatabases(req.Context(), resourceGroupNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDetachFollowerDatabases = &respr
		c.beginDetachFollowerDatabases.add(req, beginDetachFollowerDatabases)
	}

	resp, err := server.PollerResponderNext(beginDetachFollowerDatabases, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginDetachFollowerDatabases.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDetachFollowerDatabases) {
		c.beginDetachFollowerDatabases.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginDiagnoseVirtualNetwork(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDiagnoseVirtualNetwork == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDiagnoseVirtualNetwork not implemented")}
	}
	beginDiagnoseVirtualNetwork := c.beginDiagnoseVirtualNetwork.get(req)
	if beginDiagnoseVirtualNetwork == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/diagnoseVirtualNetwork`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDiagnoseVirtualNetwork(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDiagnoseVirtualNetwork = &respr
		c.beginDiagnoseVirtualNetwork.add(req, beginDiagnoseVirtualNetwork)
	}

	resp, err := server.PollerResponderNext(beginDiagnoseVirtualNetwork, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginDiagnoseVirtualNetwork.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDiagnoseVirtualNetwork) {
		c.beginDiagnoseVirtualNetwork.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Cluster, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListPager(nil)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := c.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		c.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		c.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListFollowerDatabasesPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListFollowerDatabasesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListFollowerDatabasesPager not implemented")}
	}
	newListFollowerDatabasesPager := c.newListFollowerDatabasesPager.get(req)
	if newListFollowerDatabasesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listFollowerDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListFollowerDatabasesPager(resourceGroupNameParam, clusterNameParam, nil)
		newListFollowerDatabasesPager = &resp
		c.newListFollowerDatabasesPager.add(req, newListFollowerDatabasesPager)
	}
	resp, err := server.PagerResponderNext(newListFollowerDatabasesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListFollowerDatabasesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListFollowerDatabasesPager) {
		c.newListFollowerDatabasesPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListLanguageExtensionsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListLanguageExtensionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListLanguageExtensionsPager not implemented")}
	}
	newListLanguageExtensionsPager := c.newListLanguageExtensionsPager.get(req)
	if newListLanguageExtensionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listLanguageExtensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListLanguageExtensionsPager(resourceGroupNameParam, clusterNameParam, nil)
		newListLanguageExtensionsPager = &resp
		c.newListLanguageExtensionsPager.add(req, newListLanguageExtensionsPager)
	}
	resp, err := server.PagerResponderNext(newListLanguageExtensionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListLanguageExtensionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListLanguageExtensionsPager) {
		c.newListLanguageExtensionsPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListOutboundNetworkDependenciesEndpointsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListOutboundNetworkDependenciesEndpointsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListOutboundNetworkDependenciesEndpointsPager not implemented")}
	}
	newListOutboundNetworkDependenciesEndpointsPager := c.newListOutboundNetworkDependenciesEndpointsPager.get(req)
	if newListOutboundNetworkDependenciesEndpointsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/outboundNetworkDependenciesEndpoints`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListOutboundNetworkDependenciesEndpointsPager(resourceGroupNameParam, clusterNameParam, nil)
		newListOutboundNetworkDependenciesEndpointsPager = &resp
		c.newListOutboundNetworkDependenciesEndpointsPager.add(req, newListOutboundNetworkDependenciesEndpointsPager)
		server.PagerResponderInjectNextLinks(newListOutboundNetworkDependenciesEndpointsPager, req, func(page *armkusto.ClustersClientListOutboundNetworkDependenciesEndpointsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListOutboundNetworkDependenciesEndpointsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListOutboundNetworkDependenciesEndpointsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListOutboundNetworkDependenciesEndpointsPager) {
		c.newListOutboundNetworkDependenciesEndpointsPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListSKUsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListSKUsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSKUsPager not implemented")}
	}
	newListSKUsPager := c.newListSKUsPager.get(req)
	if newListSKUsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListSKUsPager(nil)
		newListSKUsPager = &resp
		c.newListSKUsPager.add(req, newListSKUsPager)
	}
	resp, err := server.PagerResponderNext(newListSKUsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListSKUsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSKUsPager) {
		c.newListSKUsPager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchNewListSKUsByResourcePager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListSKUsByResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSKUsByResourcePager not implemented")}
	}
	newListSKUsByResourcePager := c.newListSKUsByResourcePager.get(req)
	if newListSKUsByResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/skus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListSKUsByResourcePager(resourceGroupNameParam, clusterNameParam, nil)
		newListSKUsByResourcePager = &resp
		c.newListSKUsByResourcePager.add(req, newListSKUsByResourcePager)
	}
	resp, err := server.PagerResponderNext(newListSKUsByResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListSKUsByResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSKUsByResourcePager) {
		c.newListSKUsByResourcePager.remove(req)
	}
	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginMigrate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginMigrate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrate not implemented")}
	}
	beginMigrate := c.beginMigrate.get(req)
	if beginMigrate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armkusto.ClusterMigrateRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginMigrate(req.Context(), resourceGroupNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrate = &respr
		c.beginMigrate.add(req, beginMigrate)
	}

	resp, err := server.PollerResponderNext(beginMigrate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginMigrate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrate) {
		c.beginMigrate.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginRemoveLanguageExtensions(req *http.Request) (*http.Response, error) {
	if c.srv.BeginRemoveLanguageExtensions == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRemoveLanguageExtensions not implemented")}
	}
	beginRemoveLanguageExtensions := c.beginRemoveLanguageExtensions.get(req)
	if beginRemoveLanguageExtensions == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/removeLanguageExtensions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armkusto.LanguageExtensionsList](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginRemoveLanguageExtensions(req.Context(), resourceGroupNameParam, clusterNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRemoveLanguageExtensions = &respr
		c.beginRemoveLanguageExtensions.add(req, beginRemoveLanguageExtensions)
	}

	resp, err := server.PollerResponderNext(beginRemoveLanguageExtensions, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginRemoveLanguageExtensions.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRemoveLanguageExtensions) {
		c.beginRemoveLanguageExtensions.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if c.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := c.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginStart(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		c.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		c.beginStart.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if c.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := c.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginStop(req.Context(), resourceGroupNameParam, clusterNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		c.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		c.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		c.beginStop.remove(req)
	}

	return resp, nil
}

func (c *ClustersServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armkusto.ClusterUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
		if err != nil {
			return nil, err
		}
		ifMatchParam := getOptional(getHeaderValue(req.Header, "If-Match"))
		var options *armkusto.ClustersClientBeginUpdateOptions
		if ifMatchParam != nil {
			options = &armkusto.ClustersClientBeginUpdateOptions{
				IfMatch: ifMatchParam,
			}
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), resourceGroupNameParam, clusterNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}
