//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatabox

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ServiceClient contains the methods for the Service group.
// Don't use this type directly, use NewServiceClient() instead.
type ServiceClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewServiceClient creates a new instance of ServiceClient with the specified values.
//   - subscriptionID - The Subscription Id
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewServiceClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ServiceClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ServiceClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListAvailableSKUsByResourceGroupPager - This method provides the list of available skus for the given subscription,
// resource group and location.
//
// Generated from API version 2022-12-01
//   - resourceGroupName - The Resource Group Name
//   - location - The location of the resource
//   - availableSKURequest - Filters for showing the available skus.
//   - options - ServiceClientListAvailableSKUsByResourceGroupOptions contains the optional parameters for the ServiceClient.NewListAvailableSKUsByResourceGroupPager
//     method.
func (client *ServiceClient) NewListAvailableSKUsByResourceGroupPager(resourceGroupName string, location string, availableSKURequest AvailableSKURequest, options *ServiceClientListAvailableSKUsByResourceGroupOptions) *runtime.Pager[ServiceClientListAvailableSKUsByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ServiceClientListAvailableSKUsByResourceGroupResponse]{
		More: func(page ServiceClientListAvailableSKUsByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ServiceClientListAvailableSKUsByResourceGroupResponse) (ServiceClientListAvailableSKUsByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ServiceClient.NewListAvailableSKUsByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listAvailableSKUsByResourceGroupCreateRequest(ctx, resourceGroupName, location, availableSKURequest, options)
			}, nil)
			if err != nil {
				return ServiceClientListAvailableSKUsByResourceGroupResponse{}, err
			}
			return client.listAvailableSKUsByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listAvailableSKUsByResourceGroupCreateRequest creates the ListAvailableSKUsByResourceGroup request.
func (client *ServiceClient) listAvailableSKUsByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, location string, availableSKURequest AvailableSKURequest, options *ServiceClientListAvailableSKUsByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/availableSkus"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, availableSKURequest); err != nil {
		return nil, err
	}
	return req, nil
}

// listAvailableSKUsByResourceGroupHandleResponse handles the ListAvailableSKUsByResourceGroup response.
func (client *ServiceClient) listAvailableSKUsByResourceGroupHandleResponse(resp *http.Response) (ServiceClientListAvailableSKUsByResourceGroupResponse, error) {
	result := ServiceClientListAvailableSKUsByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AvailableSKUsResult); err != nil {
		return ServiceClientListAvailableSKUsByResourceGroupResponse{}, err
	}
	return result, nil
}

// RegionConfiguration - This API provides configuration details specific to given region/location at Subscription level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-12-01
//   - location - The location of the resource
//   - regionConfigurationRequest - Request body to get the configuration for the region.
//   - options - ServiceClientRegionConfigurationOptions contains the optional parameters for the ServiceClient.RegionConfiguration
//     method.
func (client *ServiceClient) RegionConfiguration(ctx context.Context, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationOptions) (ServiceClientRegionConfigurationResponse, error) {
	var err error
	const operationName = "ServiceClient.RegionConfiguration"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.regionConfigurationCreateRequest(ctx, location, regionConfigurationRequest, options)
	if err != nil {
		return ServiceClientRegionConfigurationResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServiceClientRegionConfigurationResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServiceClientRegionConfigurationResponse{}, err
	}
	resp, err := client.regionConfigurationHandleResponse(httpResp)
	return resp, err
}

// regionConfigurationCreateRequest creates the RegionConfiguration request.
func (client *ServiceClient) regionConfigurationCreateRequest(ctx context.Context, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, regionConfigurationRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// regionConfigurationHandleResponse handles the RegionConfiguration response.
func (client *ServiceClient) regionConfigurationHandleResponse(resp *http.Response) (ServiceClientRegionConfigurationResponse, error) {
	result := ServiceClientRegionConfigurationResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegionConfigurationResponse); err != nil {
		return ServiceClientRegionConfigurationResponse{}, err
	}
	return result, nil
}

// RegionConfigurationByResourceGroup - This API provides configuration details specific to given region/location at Resource
// group level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-12-01
//   - resourceGroupName - The Resource Group Name
//   - location - The location of the resource
//   - regionConfigurationRequest - Request body to get the configuration for the region at resource group level.
//   - options - ServiceClientRegionConfigurationByResourceGroupOptions contains the optional parameters for the ServiceClient.RegionConfigurationByResourceGroup
//     method.
func (client *ServiceClient) RegionConfigurationByResourceGroup(ctx context.Context, resourceGroupName string, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationByResourceGroupOptions) (ServiceClientRegionConfigurationByResourceGroupResponse, error) {
	var err error
	const operationName = "ServiceClient.RegionConfigurationByResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.regionConfigurationByResourceGroupCreateRequest(ctx, resourceGroupName, location, regionConfigurationRequest, options)
	if err != nil {
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, err
	}
	resp, err := client.regionConfigurationByResourceGroupHandleResponse(httpResp)
	return resp, err
}

// regionConfigurationByResourceGroupCreateRequest creates the RegionConfigurationByResourceGroup request.
func (client *ServiceClient) regionConfigurationByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, location string, regionConfigurationRequest RegionConfigurationRequest, options *ServiceClientRegionConfigurationByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/regionConfiguration"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, regionConfigurationRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// regionConfigurationByResourceGroupHandleResponse handles the RegionConfigurationByResourceGroup response.
func (client *ServiceClient) regionConfigurationByResourceGroupHandleResponse(resp *http.Response) (ServiceClientRegionConfigurationByResourceGroupResponse, error) {
	result := ServiceClientRegionConfigurationByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RegionConfigurationResponse); err != nil {
		return ServiceClientRegionConfigurationByResourceGroupResponse{}, err
	}
	return result, nil
}

// ValidateAddress - [DEPRECATED NOTICE: This operation will soon be removed]. This method validates the customer shipping
// address and provide alternate addresses if any.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-12-01
//   - location - The location of the resource
//   - validateAddress - Shipping address of the customer.
//   - options - ServiceClientValidateAddressOptions contains the optional parameters for the ServiceClient.ValidateAddress method.
func (client *ServiceClient) ValidateAddress(ctx context.Context, location string, validateAddress ValidateAddress, options *ServiceClientValidateAddressOptions) (ServiceClientValidateAddressResponse, error) {
	var err error
	const operationName = "ServiceClient.ValidateAddress"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateAddressCreateRequest(ctx, location, validateAddress, options)
	if err != nil {
		return ServiceClientValidateAddressResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServiceClientValidateAddressResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServiceClientValidateAddressResponse{}, err
	}
	resp, err := client.validateAddressHandleResponse(httpResp)
	return resp, err
}

// validateAddressCreateRequest creates the ValidateAddress request.
func (client *ServiceClient) validateAddressCreateRequest(ctx context.Context, location string, validateAddress ValidateAddress, options *ServiceClientValidateAddressOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateAddress"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, validateAddress); err != nil {
		return nil, err
	}
	return req, nil
}

// validateAddressHandleResponse handles the ValidateAddress response.
func (client *ServiceClient) validateAddressHandleResponse(resp *http.Response) (ServiceClientValidateAddressResponse, error) {
	result := ServiceClientValidateAddressResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AddressValidationOutput); err != nil {
		return ServiceClientValidateAddressResponse{}, err
	}
	return result, nil
}

// ValidateInputs - This method does all necessary pre-job creation validation under subscription.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-12-01
//   - location - The location of the resource
//   - validationRequest - Inputs of the customer.
//   - options - ServiceClientValidateInputsOptions contains the optional parameters for the ServiceClient.ValidateInputs method.
func (client *ServiceClient) ValidateInputs(ctx context.Context, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsOptions) (ServiceClientValidateInputsResponse, error) {
	var err error
	const operationName = "ServiceClient.ValidateInputs"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateInputsCreateRequest(ctx, location, validationRequest, options)
	if err != nil {
		return ServiceClientValidateInputsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServiceClientValidateInputsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServiceClientValidateInputsResponse{}, err
	}
	resp, err := client.validateInputsHandleResponse(httpResp)
	return resp, err
}

// validateInputsCreateRequest creates the ValidateInputs request.
func (client *ServiceClient) validateInputsCreateRequest(ctx context.Context, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.DataBox/locations/{location}/validateInputs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, validationRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// validateInputsHandleResponse handles the ValidateInputs response.
func (client *ServiceClient) validateInputsHandleResponse(resp *http.Response) (ServiceClientValidateInputsResponse, error) {
	result := ServiceClientValidateInputsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidationResponse); err != nil {
		return ServiceClientValidateInputsResponse{}, err
	}
	return result, nil
}

// ValidateInputsByResourceGroup - This method does all necessary pre-job creation validation under resource group.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-12-01
//   - resourceGroupName - The Resource Group Name
//   - location - The location of the resource
//   - validationRequest - Inputs of the customer.
//   - options - ServiceClientValidateInputsByResourceGroupOptions contains the optional parameters for the ServiceClient.ValidateInputsByResourceGroup
//     method.
func (client *ServiceClient) ValidateInputsByResourceGroup(ctx context.Context, resourceGroupName string, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsByResourceGroupOptions) (ServiceClientValidateInputsByResourceGroupResponse, error) {
	var err error
	const operationName = "ServiceClient.ValidateInputsByResourceGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.validateInputsByResourceGroupCreateRequest(ctx, resourceGroupName, location, validationRequest, options)
	if err != nil {
		return ServiceClientValidateInputsByResourceGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ServiceClientValidateInputsByResourceGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ServiceClientValidateInputsByResourceGroupResponse{}, err
	}
	resp, err := client.validateInputsByResourceGroupHandleResponse(httpResp)
	return resp, err
}

// validateInputsByResourceGroupCreateRequest creates the ValidateInputsByResourceGroup request.
func (client *ServiceClient) validateInputsByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, location string, validationRequest ValidationRequestClassification, options *ServiceClientValidateInputsByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataBox/locations/{location}/validateInputs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-12-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, validationRequest); err != nil {
		return nil, err
	}
	return req, nil
}

// validateInputsByResourceGroupHandleResponse handles the ValidateInputsByResourceGroup response.
func (client *ServiceClient) validateInputsByResourceGroupHandleResponse(resp *http.Response) (ServiceClientValidateInputsByResourceGroupResponse, error) {
	result := ServiceClientValidateInputsByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ValidationResponse); err != nil {
		return ServiceClientValidateInputsByResourceGroupResponse{}, err
	}
	return result, nil
}
