//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/blueprint/armblueprint"
	"net/http"
	"net/url"
	"regexp"
)

// ArtifactsServer is a fake server for instances of the armblueprint.ArtifactsClient type.
type ArtifactsServer struct {
	// CreateOrUpdate is the fake for method ArtifactsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceScope string, blueprintName string, artifactName string, artifact armblueprint.ArtifactClassification, options *armblueprint.ArtifactsClientCreateOrUpdateOptions) (resp azfake.Responder[armblueprint.ArtifactsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ArtifactsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceScope string, blueprintName string, artifactName string, options *armblueprint.ArtifactsClientDeleteOptions) (resp azfake.Responder[armblueprint.ArtifactsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ArtifactsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceScope string, blueprintName string, artifactName string, options *armblueprint.ArtifactsClientGetOptions) (resp azfake.Responder[armblueprint.ArtifactsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ArtifactsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceScope string, blueprintName string, options *armblueprint.ArtifactsClientListOptions) (resp azfake.PagerResponder[armblueprint.ArtifactsClientListResponse])
}

// NewArtifactsServerTransport creates a new instance of ArtifactsServerTransport with the provided implementation.
// The returned ArtifactsServerTransport instance is connected to an instance of armblueprint.ArtifactsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewArtifactsServerTransport(srv *ArtifactsServer) *ArtifactsServerTransport {
	return &ArtifactsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armblueprint.ArtifactsClientListResponse]](),
	}
}

// ArtifactsServerTransport connects instances of armblueprint.ArtifactsClient to instances of ArtifactsServer.
// Don't use this type directly, use NewArtifactsServerTransport instead.
type ArtifactsServerTransport struct {
	srv          *ArtifactsServer
	newListPager *tracker[azfake.PagerResponder[armblueprint.ArtifactsClientListResponse]]
}

// Do implements the policy.Transporter interface for ArtifactsServerTransport.
func (a *ArtifactsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ArtifactsClient.CreateOrUpdate":
		resp, err = a.dispatchCreateOrUpdate(req)
	case "ArtifactsClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "ArtifactsClient.Get":
		resp, err = a.dispatchGet(req)
	case "ArtifactsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *ArtifactsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts/(?P<artifactName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalArtifactClassification(raw)
	if err != nil {
		return nil, err
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	artifactNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("artifactName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateOrUpdate(req.Context(), resourceScopeParam, blueprintNameParam, artifactNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ArtifactClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ArtifactsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts/(?P<artifactName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	artifactNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("artifactName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceScopeParam, blueprintNameParam, artifactNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ArtifactClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ArtifactsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts/(?P<artifactName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
	if err != nil {
		return nil, err
	}
	blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
	if err != nil {
		return nil, err
	}
	artifactNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("artifactName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), resourceScopeParam, blueprintNameParam, artifactNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ArtifactClassification, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *ArtifactsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<resourceScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Blueprint/blueprints/(?P<blueprintName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/artifacts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceScope")])
		if err != nil {
			return nil, err
		}
		blueprintNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("blueprintName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(resourceScopeParam, blueprintNameParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armblueprint.ArtifactsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
