//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ReportsServer is a fake server for instances of the armapimanagement.ReportsClient type.
type ReportsServer struct {
	// NewListByAPIPager is the fake for method ReportsClient.NewListByAPIPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByAPIPager func(resourceGroupName string, serviceName string, filter string, options *armapimanagement.ReportsClientListByAPIOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListByAPIResponse])

	// NewListByGeoPager is the fake for method ReportsClient.NewListByGeoPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByGeoPager func(resourceGroupName string, serviceName string, filter string, options *armapimanagement.ReportsClientListByGeoOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListByGeoResponse])

	// NewListByOperationPager is the fake for method ReportsClient.NewListByOperationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByOperationPager func(resourceGroupName string, serviceName string, filter string, options *armapimanagement.ReportsClientListByOperationOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListByOperationResponse])

	// NewListByProductPager is the fake for method ReportsClient.NewListByProductPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProductPager func(resourceGroupName string, serviceName string, filter string, options *armapimanagement.ReportsClientListByProductOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListByProductResponse])

	// NewListByRequestPager is the fake for method ReportsClient.NewListByRequestPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByRequestPager func(resourceGroupName string, serviceName string, filter string, options *armapimanagement.ReportsClientListByRequestOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListByRequestResponse])

	// NewListBySubscriptionPager is the fake for method ReportsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(resourceGroupName string, serviceName string, filter string, options *armapimanagement.ReportsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListBySubscriptionResponse])

	// NewListByTimePager is the fake for method ReportsClient.NewListByTimePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTimePager func(resourceGroupName string, serviceName string, filter string, interval string, options *armapimanagement.ReportsClientListByTimeOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListByTimeResponse])

	// NewListByUserPager is the fake for method ReportsClient.NewListByUserPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByUserPager func(resourceGroupName string, serviceName string, filter string, options *armapimanagement.ReportsClientListByUserOptions) (resp azfake.PagerResponder[armapimanagement.ReportsClientListByUserResponse])
}

// NewReportsServerTransport creates a new instance of ReportsServerTransport with the provided implementation.
// The returned ReportsServerTransport instance is connected to an instance of armapimanagement.ReportsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReportsServerTransport(srv *ReportsServer) *ReportsServerTransport {
	return &ReportsServerTransport{
		srv:                        srv,
		newListByAPIPager:          newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListByAPIResponse]](),
		newListByGeoPager:          newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListByGeoResponse]](),
		newListByOperationPager:    newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListByOperationResponse]](),
		newListByProductPager:      newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListByProductResponse]](),
		newListByRequestPager:      newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListByRequestResponse]](),
		newListBySubscriptionPager: newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListBySubscriptionResponse]](),
		newListByTimePager:         newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListByTimeResponse]](),
		newListByUserPager:         newTracker[azfake.PagerResponder[armapimanagement.ReportsClientListByUserResponse]](),
	}
}

// ReportsServerTransport connects instances of armapimanagement.ReportsClient to instances of ReportsServer.
// Don't use this type directly, use NewReportsServerTransport instead.
type ReportsServerTransport struct {
	srv                        *ReportsServer
	newListByAPIPager          *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListByAPIResponse]]
	newListByGeoPager          *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListByGeoResponse]]
	newListByOperationPager    *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListByOperationResponse]]
	newListByProductPager      *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListByProductResponse]]
	newListByRequestPager      *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListByRequestResponse]]
	newListBySubscriptionPager *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListBySubscriptionResponse]]
	newListByTimePager         *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListByTimeResponse]]
	newListByUserPager         *tracker[azfake.PagerResponder[armapimanagement.ReportsClientListByUserResponse]]
}

// Do implements the policy.Transporter interface for ReportsServerTransport.
func (r *ReportsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReportsClient.NewListByAPIPager":
		resp, err = r.dispatchNewListByAPIPager(req)
	case "ReportsClient.NewListByGeoPager":
		resp, err = r.dispatchNewListByGeoPager(req)
	case "ReportsClient.NewListByOperationPager":
		resp, err = r.dispatchNewListByOperationPager(req)
	case "ReportsClient.NewListByProductPager":
		resp, err = r.dispatchNewListByProductPager(req)
	case "ReportsClient.NewListByRequestPager":
		resp, err = r.dispatchNewListByRequestPager(req)
	case "ReportsClient.NewListBySubscriptionPager":
		resp, err = r.dispatchNewListBySubscriptionPager(req)
	case "ReportsClient.NewListByTimePager":
		resp, err = r.dispatchNewListByTimePager(req)
	case "ReportsClient.NewListByUserPager":
		resp, err = r.dispatchNewListByUserPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListByAPIPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByAPIPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByAPIPager not implemented")}
	}
	newListByAPIPager := r.newListByAPIPager.get(req)
	if newListByAPIPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/byApi`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armapimanagement.ReportsClientListByAPIOptions
		if topParam != nil || skipParam != nil || orderbyParam != nil {
			options = &armapimanagement.ReportsClientListByAPIOptions{
				Top:     topParam,
				Skip:    skipParam,
				Orderby: orderbyParam,
			}
		}
		resp := r.srv.NewListByAPIPager(resourceGroupNameParam, serviceNameParam, filterParam, options)
		newListByAPIPager = &resp
		r.newListByAPIPager.add(req, newListByAPIPager)
		server.PagerResponderInjectNextLinks(newListByAPIPager, req, func(page *armapimanagement.ReportsClientListByAPIResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByAPIPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByAPIPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByAPIPager) {
		r.newListByAPIPager.remove(req)
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListByGeoPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByGeoPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByGeoPager not implemented")}
	}
	newListByGeoPager := r.newListByGeoPager.get(req)
	if newListByGeoPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/byGeo`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.ReportsClientListByGeoOptions
		if topParam != nil || skipParam != nil {
			options = &armapimanagement.ReportsClientListByGeoOptions{
				Top:  topParam,
				Skip: skipParam,
			}
		}
		resp := r.srv.NewListByGeoPager(resourceGroupNameParam, serviceNameParam, filterParam, options)
		newListByGeoPager = &resp
		r.newListByGeoPager.add(req, newListByGeoPager)
		server.PagerResponderInjectNextLinks(newListByGeoPager, req, func(page *armapimanagement.ReportsClientListByGeoResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByGeoPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByGeoPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByGeoPager) {
		r.newListByGeoPager.remove(req)
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListByOperationPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByOperationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByOperationPager not implemented")}
	}
	newListByOperationPager := r.newListByOperationPager.get(req)
	if newListByOperationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/byOperation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armapimanagement.ReportsClientListByOperationOptions
		if topParam != nil || skipParam != nil || orderbyParam != nil {
			options = &armapimanagement.ReportsClientListByOperationOptions{
				Top:     topParam,
				Skip:    skipParam,
				Orderby: orderbyParam,
			}
		}
		resp := r.srv.NewListByOperationPager(resourceGroupNameParam, serviceNameParam, filterParam, options)
		newListByOperationPager = &resp
		r.newListByOperationPager.add(req, newListByOperationPager)
		server.PagerResponderInjectNextLinks(newListByOperationPager, req, func(page *armapimanagement.ReportsClientListByOperationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByOperationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByOperationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByOperationPager) {
		r.newListByOperationPager.remove(req)
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListByProductPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByProductPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProductPager not implemented")}
	}
	newListByProductPager := r.newListByProductPager.get(req)
	if newListByProductPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/byProduct`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armapimanagement.ReportsClientListByProductOptions
		if topParam != nil || skipParam != nil || orderbyParam != nil {
			options = &armapimanagement.ReportsClientListByProductOptions{
				Top:     topParam,
				Skip:    skipParam,
				Orderby: orderbyParam,
			}
		}
		resp := r.srv.NewListByProductPager(resourceGroupNameParam, serviceNameParam, filterParam, options)
		newListByProductPager = &resp
		r.newListByProductPager.add(req, newListByProductPager)
		server.PagerResponderInjectNextLinks(newListByProductPager, req, func(page *armapimanagement.ReportsClientListByProductResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByProductPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByProductPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProductPager) {
		r.newListByProductPager.remove(req)
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListByRequestPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByRequestPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByRequestPager not implemented")}
	}
	newListByRequestPager := r.newListByRequestPager.get(req)
	if newListByRequestPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/byRequest`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.ReportsClientListByRequestOptions
		if topParam != nil || skipParam != nil {
			options = &armapimanagement.ReportsClientListByRequestOptions{
				Top:  topParam,
				Skip: skipParam,
			}
		}
		resp := r.srv.NewListByRequestPager(resourceGroupNameParam, serviceNameParam, filterParam, options)
		newListByRequestPager = &resp
		r.newListByRequestPager.add(req, newListByRequestPager)
	}
	resp, err := server.PagerResponderNext(newListByRequestPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByRequestPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByRequestPager) {
		r.newListByRequestPager.remove(req)
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := r.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/bySubscription`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armapimanagement.ReportsClientListBySubscriptionOptions
		if topParam != nil || skipParam != nil || orderbyParam != nil {
			options = &armapimanagement.ReportsClientListBySubscriptionOptions{
				Top:     topParam,
				Skip:    skipParam,
				Orderby: orderbyParam,
			}
		}
		resp := r.srv.NewListBySubscriptionPager(resourceGroupNameParam, serviceNameParam, filterParam, options)
		newListBySubscriptionPager = &resp
		r.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armapimanagement.ReportsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		r.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListByTimePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByTimePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTimePager not implemented")}
	}
	newListByTimePager := r.newListByTimePager.get(req)
	if newListByTimePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/byTime`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		intervalParam, err := url.QueryUnescape(qp.Get("interval"))
		if err != nil {
			return nil, err
		}
		var options *armapimanagement.ReportsClientListByTimeOptions
		if topParam != nil || skipParam != nil || orderbyParam != nil {
			options = &armapimanagement.ReportsClientListByTimeOptions{
				Top:     topParam,
				Skip:    skipParam,
				Orderby: orderbyParam,
			}
		}
		resp := r.srv.NewListByTimePager(resourceGroupNameParam, serviceNameParam, filterParam, intervalParam, options)
		newListByTimePager = &resp
		r.newListByTimePager.add(req, newListByTimePager)
		server.PagerResponderInjectNextLinks(newListByTimePager, req, func(page *armapimanagement.ReportsClientListByTimeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTimePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByTimePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTimePager) {
		r.newListByTimePager.remove(req)
	}
	return resp, nil
}

func (r *ReportsServerTransport) dispatchNewListByUserPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByUserPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByUserPager not implemented")}
	}
	newListByUserPager := r.newListByUserPager.get(req)
	if newListByUserPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ApiManagement/service/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reports/byUser`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		filterParam, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armapimanagement.ReportsClientListByUserOptions
		if topParam != nil || skipParam != nil || orderbyParam != nil {
			options = &armapimanagement.ReportsClientListByUserOptions{
				Top:     topParam,
				Skip:    skipParam,
				Orderby: orderbyParam,
			}
		}
		resp := r.srv.NewListByUserPager(resourceGroupNameParam, serviceNameParam, filterParam, options)
		newListByUserPager = &resp
		r.newListByUserPager.add(req, newListByUserPager)
		server.PagerResponderInjectNextLinks(newListByUserPager, req, func(page *armapimanagement.ReportsClientListByUserResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByUserPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByUserPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByUserPager) {
		r.newListByUserPager.remove(req)
	}
	return resp, nil
}
