// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

// @generated by tools/make/codegen/src/capi_datetime.rs

#[rustfmt::skip]
#[diplomat::bridge]
#[diplomat::abi_rename = "icu4x_{0}_mv1"]
#[diplomat::attr(auto, namespace = "icu4x")]
pub mod ffi {
    use alloc::boxed::Box;
    use writeable::Writeable;

    #[allow(unused_imports)]
    use crate::datetime_helpers::map_or_default;

    #[allow(unused_imports)]
    use crate::unstable::{
        date::ffi::{Date, IsoDate},
        datetime::ffi::DateTime,
        datetime_options::ffi::{DateTimeAlignment, DateTimeLength, TimePrecision, YearStyle},
        errors::ffi::DateTimeFormatterLoadError,
        errors::ffi::DateTimeMismatchedCalendarError,
        locale_core::ffi::Locale,
        time::ffi::Time,
    };

    #[cfg(feature = "buffer_provider")]
    use crate::unstable::provider::ffi::DataProvider;

    #[diplomat::opaque]
    #[diplomat::rust_link(icu::datetime::NoCalendarFormatter, Typedef)]
    pub struct TimeFormatter(
        pub  icu_datetime::FixedCalendarDateTimeFormatter<
            (),
            icu_datetime::fieldsets::enums::TimeFieldSet,
        >,
    );

    impl TimeFormatter {
        #[diplomat::attr(supports = fallible_constructors, constructor)]
        #[diplomat::rust_link(icu::datetime::NoCalendarFormatter::try_new, FnInTypedef)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_precision, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[diplomat::demo(default_constructor)]
        #[cfg(feature = "compiled_data")]
        pub fn create(
            locale: &Locale,
            length: Option<DateTimeLength>,
            time_precision: Option<TimePrecision>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::T::for_length(map_or_default(length));
            options.time_precision = time_precision.map(Into::into);
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "with_provider")]
        #[diplomat::rust_link(icu::datetime::NoCalendarFormatter::try_new, FnInTypedef)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_precision, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::T::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            time_precision: Option<TimePrecision>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::T::for_length(map_or_default(length));
            options.time_precision = time_precision.map(Into::into);
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::rust_link(icu::datetime::NoCalendarFormatter::format, FnInTypedef)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime, Struct, hidden)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime::to_string, FnInStruct, hidden)]
        pub fn format(
            &self,
            time: &Time,
            write: &mut diplomat_runtime::DiplomatWrite,
        ) {
            let value = time.0;
            let _infallible = self.0.format(&value).write_to(write);
        }
        
    }
    
}
