// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

// @generated by tools/make/codegen/src/capi_datetime.rs

#[rustfmt::skip]
#[diplomat::bridge]
#[diplomat::abi_rename = "icu4x_{0}_mv1"]
#[diplomat::attr(auto, namespace = "icu4x")]
pub mod ffi {
    use alloc::boxed::Box;
    use icu_calendar::Gregorian;
    use writeable::Writeable;

    #[allow(unused_imports)]
    use crate::datetime_helpers::map_or_default;

    #[allow(unused_imports)]
    use crate::unstable::{
        date::ffi::{Date, IsoDate},
        datetime::ffi::DateTime,
        datetime_options::ffi::{DateTimeAlignment, DateTimeLength, TimePrecision, YearStyle},
        errors::ffi::DateTimeFormatterLoadError,
        errors::ffi::DateTimeMismatchedCalendarError,
        locale_core::ffi::Locale,
        time::ffi::Time,
    };

    #[cfg(feature = "buffer_provider")]
    use crate::unstable::provider::ffi::DataProvider;

    #[diplomat::opaque]
    #[diplomat::rust_link(icu::datetime::DateTimeFormatter, Struct)]
    pub struct DateFormatter(
        pub  icu_datetime::DateTimeFormatter<
            icu_datetime::fieldsets::enums::DateFieldSet,
        >,
    );

    impl DateFormatter {
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "d")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_d(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::D::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "d_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_d_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::D::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "md")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_md(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "md_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_md_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymd")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[diplomat::demo(default_constructor)]
        #[cfg(feature = "compiled_data")]
        pub fn create_ymd(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymd_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_ymd_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "de")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_de(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::DE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "de_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_de_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::DE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "mde")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_mde(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "mde_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_mde_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymde")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_ymde(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymde_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_ymde_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "e")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_e(
            locale: &Locale,
            length: Option<DateTimeLength>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            #[allow(unused_mut)]
            let mut options = icu_datetime::fieldsets::E::for_length(map_or_default(length));
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "e_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_e_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            #[allow(unused_mut)]
            let mut options = icu_datetime::fieldsets::E::for_length(map_or_default(length));
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "m")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::long, FnInStruct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_m(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::M::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "m_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::long, FnInStruct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_m_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::M::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ym")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::long, FnInStruct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_ym(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YM::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ym_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::long, FnInStruct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_ym_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YM::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "y")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::long, FnInStruct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_y(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::Y::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "y_with_provider")]
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::long, FnInStruct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_y_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::Y::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::DateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::format, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime, Struct, hidden)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime::to_string, FnInStruct, hidden)]
        pub fn format_iso(
            &self,
            date: &IsoDate,
            write: &mut diplomat_runtime::DiplomatWrite,
        ) {
            let date = date.0;
            let value = date;
            let _infallible = self.0.format(&value).write_to(write);
        }
        
        #[diplomat::rust_link(icu::datetime::DateTimeFormatter::format_same_calendar, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime, Struct, hidden)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime::to_string, FnInStruct, hidden)]
        pub fn format_same_calendar(
            &self,
            date: &Date,
            write: &mut diplomat_runtime::DiplomatWrite,
        ) -> Result<(), DateTimeMismatchedCalendarError> {
            let date = date.0.as_borrowed();
            let value = date;
            let _infallible = self.0.format_same_calendar(&value)?.write_to(write);
            Ok(())
        }
    }
    

    #[diplomat::opaque]
    #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter, Struct)]
    pub struct DateFormatterGregorian(
        pub  icu_datetime::FixedCalendarDateTimeFormatter<
            Gregorian,
            icu_datetime::fieldsets::enums::DateFieldSet,
        >,
    );

    impl DateFormatterGregorian {
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "d")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_d(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::D::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "d_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::D::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_d_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::D::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "md")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_md(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "md_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_md_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymd")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[diplomat::demo(default_constructor)]
        #[cfg(feature = "compiled_data")]
        pub fn create_ymd(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymd_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMD::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_ymd_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMD::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "de")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_de(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::DE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "de_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::DE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_de_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::DE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "mde")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_mde(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "mde_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::MDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_mde_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::MDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymde")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_ymde(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ymde_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YMDE::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_ymde_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YMDE::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "e")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "compiled_data")]
        pub fn create_e(
            locale: &Locale,
            length: Option<DateTimeLength>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            #[allow(unused_mut)]
            let mut options = icu_datetime::fieldsets::E::for_length(map_or_default(length));
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "e_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::long, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hm, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hms, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_time_hmss, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::E::with_zone, FnInStruct, hidden)] // functionality is in the zoned formatter but rustlink is here
        #[cfg(feature = "buffer_provider")]
        pub fn create_e_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            #[allow(unused_mut)]
            let mut options = icu_datetime::fieldsets::E::for_length(map_or_default(length));
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "m")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::long, FnInStruct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_m(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::M::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "m_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::M::long, FnInStruct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_m_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::M::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ym")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::long, FnInStruct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_ym(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YM::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "ym_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::YM::long, FnInStruct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_ym_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::YM::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "y")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::long, FnInStruct, hidden)]
        #[cfg(feature = "compiled_data")]
        pub fn create_y(
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::Y::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new(
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::attr(all(supports = fallible_constructors, supports = named_constructors), named_constructor = "y_with_provider")]
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::try_new, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y, Struct)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_alignment, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_year_style, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::for_length, FnInStruct, compact)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::with_length, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::short, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::medium, FnInStruct, hidden)]
        #[diplomat::rust_link(icu::datetime::fieldsets::Y::long, FnInStruct, hidden)]
        #[cfg(feature = "buffer_provider")]
        pub fn create_y_with_provider(
            provider: &DataProvider,
            locale: &Locale,
            length: Option<DateTimeLength>,
            alignment: Option<DateTimeAlignment>,
            year_style: Option<YearStyle>,
        ) -> Result<Box<Self>, DateTimeFormatterLoadError> {
            let prefs = (&locale.0).into();
            let mut options = icu_datetime::fieldsets::Y::for_length(map_or_default(length));
            options.alignment = alignment.map(Into::into);
            options.year_style = year_style.map(Into::into);
            Ok(Box::new(Self(
                icu_datetime
                    ::FixedCalendarDateTimeFormatter
                    ::try_new_with_buffer_provider(
                        provider.get()?,
                        prefs,
                        options
                    )?
                .cast_into_fset(),
            )))
        }
        
        #[diplomat::rust_link(icu::datetime::FixedCalendarDateTimeFormatter::format, FnInStruct)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime, Struct, hidden)]
        #[diplomat::rust_link(icu::datetime::FormattedDateTime::to_string, FnInStruct, hidden)]
        pub fn format_iso(
            &self,
            date: &IsoDate,
            write: &mut diplomat_runtime::DiplomatWrite,
        ) {
            let date = date.0.to_calendar(Gregorian);
            let value = date;
            let _infallible = self.0.format(&value).write_to(write);
        }
        
    }
    
}
