// generated by diplomat-tool
import { IanaParser } from "./IanaParser.mjs"
import { IsoDate } from "./IsoDate.mjs"
import { Rfc9557ParseError } from "./Rfc9557ParseError.mjs"
import { Time } from "./Time.mjs"
import { TimeZoneInfo } from "./TimeZoneInfo.mjs"
import { UtcOffset } from "./UtcOffset.mjs"
import { VariantOffsetsCalculator } from "./VariantOffsetsCalculator.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An ICU4X ZonedDateTime object capable of containing a ISO-8601 date, time, and zone.
 *
 * See the [Rust documentation for `ZonedDateTime`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html) for more information.
 */


export class ZonedIsoDateTime {
    #date;
    get date() {
        return this.#date;
    }
    #time;
    get time() {
        return this.#time;
    }
    #zone;
    get zone() {
        return this.#zone;
    }
    #internalConstructor(structObj, internalConstructor) {
        if (typeof structObj !== "object") {
            throw new Error("ZonedIsoDateTime's constructor takes an object of ZonedIsoDateTime's fields.");
        }

        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("ZonedIsoDateTime is an out struct and can only be created internally.");
        }
        if ("date" in structObj) {
            this.#date = structObj.date;
        } else {
            throw new Error("Missing required field date.");
        }

        if ("time" in structObj) {
            this.#time = structObj.time;
        } else {
            throw new Error("Missing required field time.");
        }

        if ("zone" in structObj) {
            this.#zone = structObj.zone;
        } else {
            throw new Error("Missing required field zone.");
        }

        return this;
    }

    // Return this struct in FFI function friendly format.
    // Returns an array that can be expanded with spread syntax (...)
    _intoFFI(
        functionCleanupArena,
        appendArrayMap
    ) {
        return [this.#date.ffiValue, this.#time.ffiValue, this.#zone.ffiValue]
    }

    static _fromSuppliedValue(internalConstructor, obj) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("_fromSuppliedValue cannot be called externally.");
        }

        if (obj instanceof ZonedIsoDateTime) {
            return obj;
        }

        return ZonedIsoDateTime.fromFields(obj);
    }

    _writeToArrayBuffer(
        arrayBuffer,
        offset,
        functionCleanupArena,
        appendArrayMap
    ) {
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, this.#date.ffiValue, Uint32Array);
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 4, this.#time.ffiValue, Uint32Array);
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 8, this.#zone.ffiValue, Uint32Array);
    }

    // This struct contains borrowed fields, so this takes in a list of
    // "edges" corresponding to where each lifetime's data may have been borrowed from
    // and passes it down to individual fields containing the borrow.
    // This method does not attempt to handle any dependencies between lifetimes, the caller
    // should handle this when constructing edge arrays.
    static _fromFFI(internalConstructor, ptr) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("ZonedIsoDateTime._fromFFI is not meant to be called externally. Please use the default constructor.");
        }
        let structObj = {};
        const dateDeref = diplomatRuntime.ptrRead(wasm, ptr);
        structObj.date = new IsoDate(diplomatRuntime.internalConstructor, dateDeref, []);
        const timeDeref = diplomatRuntime.ptrRead(wasm, ptr + 4);
        structObj.time = new Time(diplomatRuntime.internalConstructor, timeDeref, []);
        const zoneDeref = diplomatRuntime.ptrRead(wasm, ptr + 8);
        structObj.zone = new TimeZoneInfo(diplomatRuntime.internalConstructor, zoneDeref, []);

        return new ZonedIsoDateTime(structObj, internalConstructor);
    }


    /**
     * Creates a new [`ZonedIsoDateTime`] from an IXDTF string.
     *
     * See the [Rust documentation for `try_full_from_str`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html#method.try_full_from_str) for more information.
     */
    static fullFromString(v, ianaParser, offsetCalculator) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 13, 4, true);


        const result = wasm.icu4x_ZonedIsoDateTime_full_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat(), ianaParser.ffiValue, offsetCalculator.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new Rfc9557ParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('Rfc9557ParseError: ' + cause.value, { cause });
            }
            return ZonedIsoDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    /**
     * Creates a new [`ZonedIsoDateTime`] from milliseconds since epoch (timestamp) and a UTC offset.
     *
     * Note: [`ZonedIsoDateTime`]s created with this constructor can only be formatted using localized offset zone styles.
     *
     * See the [Rust documentation for `from_epoch_milliseconds_and_utc_offset`](https://docs.rs/icu/latest/icu/time/struct.ZonedDateTime.html#method.from_epoch_milliseconds_and_utc_offset) for more information.
     */
    static fromEpochMillisecondsAndUtcOffset(epochMilliseconds, utcOffset) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 12, 4, false);


        const result = wasm.icu4x_ZonedIsoDateTime_from_epoch_milliseconds_and_utc_offset_mv1(diplomatReceive.buffer, epochMilliseconds, utcOffset.ffiValue);

        try {
            return ZonedIsoDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor(structObj, internalConstructor) {
        return this.#internalConstructor(...arguments)
    }
}